/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.controls;

import com.jfoenix.controls.JFXCheckBox;
import com.jfoenix.controls.JFXSlider;
import java.util.Locale;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import us.hebi.gui.controls.Css;
import us.hebi.gui.controls.HSpacer;
import us.hebi.gui.controls.Observables;
import us.hebi.gui.controls.SliderUtil;
import us.hebi.gui.controls.buttons.HTargetButton;

public class HCommandSlider
extends VBox {
    private final CheckBox enabledCheckbox = Css.addClass(new JFXCheckBox(), "sw-Block_SubTitle");
    private final Text unitLabel = Css.addClass(new Text(), "sw-Block_Value");
    private final HTargetButton targetButton = new HTargetButton();
    private final JFXSlider slider = Css.addClass(new JFXSlider(), "mo-Monitoring_Slider");
    private final DoubleProperty feedbackValue = new SimpleDoubleProperty(Double.NaN);
    private Runnable onCommandChange = () -> {};

    public HCommandSlider() {
        this.setupTargetButton();
        this.setupSlider();
        Css.addClass(this, "hebi-slider");
        HBox hBox = Css.addClass(new HBox(new Node[]{this.enabledCheckbox, new HSpacer(), this.unitLabel}), "hebi-slider-header");
        this.getChildren().addAll((Object[])new Node[]{hBox, this.slider});
    }

    private void setupTargetButton() {
        Tooltip tooltip = new Tooltip();
        StringBinding stringBinding = Bindings.createStringBinding(() -> "Set specific " + this.getTitle().toLowerCase(Locale.ENGLISH) + "...", (Observable[])new Observable[]{this.titleProperty()});
        tooltip.textProperty().bind((ObservableValue)stringBinding);
        this.targetButton.setTooltip(tooltip);
        this.targetButton.setGlyphName("EDIT");
        SliderUtil.setupTargetButton(this.slider, this.enabledCheckbox.selectedProperty(), this.targetButton, d2 -> d2, d2 -> d2);
        this.targetButton.disableProperty().bind((ObservableValue)this.enabledCheckbox.disabledProperty());
    }

    private void setupSlider() {
        SliderUtil.setValueLabelFactory(this.slider, d2 -> d2);
        DoubleBinding doubleBinding = Bindings.createDoubleBinding(() -> {
            double d2 = this.feedbackValue.get();
            if (Double.isNaN(d2)) {
                return 0.0;
            }
            if (d2 > this.slider.getMax()) {
                return this.slider.getMax();
            }
            if (d2 < this.slider.getMin()) {
                return this.slider.getMin();
            }
            return d2;
        }, (Observable[])new Observable[]{this.feedbackValue});
        InvalidationListener invalidationListener = observable -> this.onCommandChange.run();
        Observables.runOnChange(() -> {
            if (this.isEnabled()) {
                this.slider.valueProperty().unbind();
                this.slider.valueProperty().addListener(invalidationListener);
            } else {
                this.slider.valueProperty().removeListener(invalidationListener);
                this.slider.valueProperty().bind((ObservableValue)doubleBinding);
            }
        }, new ObservableValue[]{this.enabledProperty()});
    }

    public boolean isEnabled() {
        return this.enabledProperty().get();
    }

    public BooleanProperty enabledProperty() {
        return this.enabledCheckbox.selectedProperty();
    }

    public void setEnabled(boolean bl2) {
        this.enabledProperty().set(bl2);
    }

    public String getTitle() {
        return (String)this.titleProperty().get();
    }

    public StringProperty titleProperty() {
        return this.enabledCheckbox.textProperty();
    }

    public void setTitle(String string) {
        this.titleProperty().set((Object)string);
    }

    public double getFeedbackValue() {
        return this.feedbackValue.get();
    }

    public DoubleProperty feedbackValueProperty() {
        return this.feedbackValue;
    }

    public void setFeedbackValue(double d2) {
        this.feedbackValue.set(d2);
    }

    public JFXSlider getSlider() {
        return this.slider;
    }

    public void setOnCommandChange(Runnable runnable) {
        this.onCommandChange = runnable;
    }
}

