/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.ikonli.javafx;

import java.util.Objects;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.util.Callback;
import javafx.util.StringConverter;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.javafx.FontIcon;

public class FontIconTableCell<S, T>
extends TableCell<S, T> {
    private static final String ERROR_CONVERTER_NULL = "Argument 'converter' must not be null";
    private Subscription subscription;
    private final FontIcon icon;
    private final ObjectProperty<StringConverter<T>> converter = new SimpleObjectProperty((Object)this, "converter");

    public static <S, T> Callback<TableColumn<S, T>, TableCell<S, T>> forTableColumn() {
        return tableColumn -> new FontIconTableCell();
    }

    public static <S, T> Callback<TableColumn<S, T>, TableCell<S, T>> forTableColumn(StringConverter<T> stringConverter) {
        return tableColumn -> new FontIconTableCell(stringConverter);
    }

    public FontIconTableCell() {
        this(new StringConverter<T>(){

            public String toString(T t2) {
                return t2 != null ? String.valueOf(t2) : "";
            }

            public T fromString(String string) {
                return null;
            }
        });
    }

    public FontIconTableCell(StringConverter<T> stringConverter) {
        this.getStyleClass().add((Object)"font-icon-table-cell");
        this.icon = new FontIcon();
        this.setConverter(Objects.requireNonNull(stringConverter, ERROR_CONVERTER_NULL));
    }

    public final ObjectProperty<StringConverter<T>> converterProperty() {
        return this.converter;
    }

    public final void setConverter(StringConverter<T> stringConverter) {
        this.converterProperty().set(Objects.requireNonNull(stringConverter, ERROR_CONVERTER_NULL));
    }

    public final StringConverter<T> getConverter() {
        return (StringConverter)this.converterProperty().get();
    }

    public void updateItem(T t2, boolean bl2) {
        super.updateItem(t2, bl2);
        if (bl2) {
            this.setGraphic(null);
        } else {
            TableColumn tableColumn;
            ObservableValue observableValue2;
            if (this.subscription != null) {
                this.subscription.unsubscribe();
                this.subscription = null;
            }
            ObservableValue observableValue3 = observableValue2 = (tableColumn = this.getTableColumn()) == null ? null : tableColumn.getCellObservableValue(this.getIndex());
            if (observableValue2 != null) {
                ChangeListener changeListener = (observableValue, object, object2) -> this.setIconCode(object2);
                observableValue2.addListener(changeListener);
                this.subscription = () -> observableValue2.removeListener(changeListener);
                this.setIconCode(observableValue2.getValue());
            } else if (t2 != null) {
                this.setIconCode(t2);
            }
            this.setGraphic((Node)this.icon);
            this.setAlignment(Pos.CENTER);
        }
    }

    private void setIconCode(T t2) {
        if (t2 instanceof Ikon) {
            this.icon.setIconCode((Ikon)t2);
        } else {
            this.icon.setIconLiteral(this.getConverter().toString(t2));
        }
    }

    private static interface Subscription {
        public void unsubscribe();
    }
}

