/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.tools;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.ListView;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.RadioButton;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Slider;
import javafx.scene.control.TableView;
import javafx.scene.control.TextInputControl;
import javafx.scene.control.TreeTableView;
import javafx.scene.control.TreeView;
import javafx.util.Callback;

public class ValueExtractor {
    private static List<ObservableValueExtractor> extractors = FXCollections.observableArrayList();
    private static final List<NodeValueExtractor> valueExtractors;

    public static void addObservableValueExtractor(Predicate<Control> predicate, Callback<Control, ObservableValue<?>> callback) {
        extractors.add(0, new ObservableValueExtractor(predicate, callback));
    }

    public static final Optional<Callback<Control, ObservableValue<?>>> getObservableValueExtractor(Control control) {
        for (ObservableValueExtractor observableValueExtractor : extractors) {
            if (!observableValueExtractor.applicability.test(control)) continue;
            return Optional.of(observableValueExtractor.extraction);
        }
        return Optional.empty();
    }

    private ValueExtractor() {
    }

    public static void addValueExtractor(Predicate<Node> predicate, Callback<Node, Object> callback) {
        valueExtractors.add(0, new NodeValueExtractor(predicate, callback));
    }

    public static Object getValue(Node node) {
        for (NodeValueExtractor nodeValueExtractor : valueExtractors) {
            if (!nodeValueExtractor.applicability.test(node)) continue;
            return nodeValueExtractor.extraction.call((Object)node);
        }
        return null;
    }

    static {
        ValueExtractor.addObservableValueExtractor(control -> control instanceof TextInputControl, control -> ((TextInputControl)control).textProperty());
        ValueExtractor.addObservableValueExtractor(control -> control instanceof ComboBox, control -> ((ComboBox)control).valueProperty());
        ValueExtractor.addObservableValueExtractor(control -> control instanceof ChoiceBox, control -> ((ChoiceBox)control).valueProperty());
        ValueExtractor.addObservableValueExtractor(control -> control instanceof CheckBox, control -> ((CheckBox)control).selectedProperty());
        ValueExtractor.addObservableValueExtractor(control -> control instanceof Slider, control -> ((Slider)control).valueProperty());
        ValueExtractor.addObservableValueExtractor(control -> control instanceof ColorPicker, control -> ((ColorPicker)control).valueProperty());
        ValueExtractor.addObservableValueExtractor(control -> control instanceof DatePicker, control -> ((DatePicker)control).valueProperty());
        ValueExtractor.addObservableValueExtractor(control -> control instanceof ListView, control -> ((ListView)control).itemsProperty());
        ValueExtractor.addObservableValueExtractor(control -> control instanceof TableView, control -> ((TableView)control).itemsProperty());
        valueExtractors = FXCollections.observableArrayList();
        ValueExtractor.addValueExtractor(node -> node instanceof CheckBox, (Callback<Node, Object>)((Callback)node -> ((CheckBox)node).isSelected()));
        ValueExtractor.addValueExtractor(node -> node instanceof ChoiceBox, (Callback<Node, Object>)((Callback)node -> ((ChoiceBox)node).getValue()));
        ValueExtractor.addValueExtractor(node -> node instanceof ComboBox, (Callback<Node, Object>)((Callback)node -> ((ComboBox)node).getValue()));
        ValueExtractor.addValueExtractor(node -> node instanceof DatePicker, (Callback<Node, Object>)((Callback)node -> ((DatePicker)node).getValue()));
        ValueExtractor.addValueExtractor(node -> node instanceof RadioButton, (Callback<Node, Object>)((Callback)node -> ((RadioButton)node).isSelected()));
        ValueExtractor.addValueExtractor(node -> node instanceof Slider, (Callback<Node, Object>)((Callback)node -> ((Slider)node).getValue()));
        ValueExtractor.addValueExtractor(node -> node instanceof TextInputControl, (Callback<Node, Object>)((Callback)node -> ((TextInputControl)node).getText()));
        ValueExtractor.addValueExtractor(node -> node instanceof ListView, (Callback<Node, Object>)((Callback)node -> {
            MultipleSelectionModel multipleSelectionModel = ((ListView)node).getSelectionModel();
            return multipleSelectionModel.getSelectionMode() == SelectionMode.MULTIPLE ? multipleSelectionModel.getSelectedItems() : multipleSelectionModel.getSelectedItem();
        }));
        ValueExtractor.addValueExtractor(node -> node instanceof TreeView, (Callback<Node, Object>)((Callback)node -> {
            MultipleSelectionModel multipleSelectionModel = ((TreeView)node).getSelectionModel();
            return multipleSelectionModel.getSelectionMode() == SelectionMode.MULTIPLE ? multipleSelectionModel.getSelectedItems() : multipleSelectionModel.getSelectedItem();
        }));
        ValueExtractor.addValueExtractor(node -> node instanceof TableView, (Callback<Node, Object>)((Callback)node -> {
            TableView.TableViewSelectionModel tableViewSelectionModel = ((TableView)node).getSelectionModel();
            return tableViewSelectionModel.getSelectionMode() == SelectionMode.MULTIPLE ? tableViewSelectionModel.getSelectedItems() : tableViewSelectionModel.getSelectedItem();
        }));
        ValueExtractor.addValueExtractor(node -> node instanceof TreeTableView, (Callback<Node, Object>)((Callback)node -> {
            TreeTableView.TreeTableViewSelectionModel treeTableViewSelectionModel = ((TreeTableView)node).getSelectionModel();
            return treeTableViewSelectionModel.getSelectionMode() == SelectionMode.MULTIPLE ? treeTableViewSelectionModel.getSelectedItems() : treeTableViewSelectionModel.getSelectedItem();
        }));
    }

    private static class NodeValueExtractor {
        public final Predicate<Node> applicability;
        public final Callback<Node, Object> extraction;

        public NodeValueExtractor(Predicate<Node> predicate, Callback<Node, Object> callback) {
            this.applicability = Objects.requireNonNull(predicate);
            this.extraction = Objects.requireNonNull(callback);
        }
    }

    private static class ObservableValueExtractor {
        public final Predicate<Control> applicability;
        public final Callback<Control, ObservableValue<?>> extraction;

        public ObservableValueExtractor(Predicate<Control> predicate, Callback<Control, ObservableValue<?>> callback) {
            this.applicability = Objects.requireNonNull(predicate);
            this.extraction = Objects.requireNonNull(callback);
        }
    }
}

