/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.property.editor;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Optional;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.util.Callback;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.property.editor.Editors;
import org.controlsfx.property.editor.PropertyEditor;

public class DefaultPropertyEditorFactory
implements Callback<PropertySheet.Item, PropertyEditor<?>> {
    private static Class<?>[] numericTypes = new Class[]{Byte.TYPE, Byte.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Float.TYPE, Float.class, Double.TYPE, Double.class, BigInteger.class, BigDecimal.class};

    public PropertyEditor<?> call(PropertySheet.Item item) {
        Optional<PropertyEditor<?>> optional;
        Class<?> clazz = item.getType();
        if (item.getPropertyEditorClass().isPresent() && (optional = Editors.createCustomEditor(item)).isPresent()) {
            return optional.get();
        }
        if (clazz == String.class) {
            return Editors.createTextEditor(item);
        }
        if (DefaultPropertyEditorFactory.isNumber(clazz)) {
            return Editors.createNumericEditor(item);
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            return Editors.createCheckEditor(item);
        }
        if (clazz == LocalDate.class) {
            return Editors.createDateEditor(item);
        }
        if (clazz == Color.class || clazz == Paint.class) {
            return Editors.createColorEditor(item);
        }
        if (clazz != null && clazz.isEnum()) {
            return Editors.createChoiceEditor(item, Arrays.asList(clazz.getEnumConstants()));
        }
        if (clazz == Font.class) {
            return Editors.createFontEditor(item);
        }
        return null;
    }

    private static boolean isNumber(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        for (Class<?> clazz2 : numericTypes) {
            if (clazz != clazz2) continue;
            return true;
        }
        return false;
    }
}

