/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.property;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.function.Predicate;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.property.BeanProperty;

public final class BeanPropertyUtils {
    private BeanPropertyUtils() {
    }

    public static ObservableList<PropertySheet.Item> getProperties(Object object) {
        return BeanPropertyUtils.getProperties(object, propertyDescriptor -> true);
    }

    public static ObservableList<PropertySheet.Item> getProperties(Object object, Predicate<PropertyDescriptor> predicate) {
        ObservableList observableList = FXCollections.observableArrayList();
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(object.getClass(), Object.class);
            for (PropertyDescriptor propertyDescriptor : beanInfo.getPropertyDescriptors()) {
                if (!predicate.test(propertyDescriptor)) continue;
                observableList.add((Object)new BeanProperty(object, propertyDescriptor));
            }
        }
        catch (IntrospectionException introspectionException) {
            introspectionException.printStackTrace();
        }
        return observableList;
    }
}

