/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.glyphfont;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.controlsfx.glyphfont.GlyphFont;

public final class GlyphFontRegistry {
    private static Map<String, GlyphFont> fontMap = new HashMap<String, GlyphFont>();

    private GlyphFontRegistry() {
    }

    public static void register(String string, String string2, int n2) {
        GlyphFontRegistry.register(new GlyphFont(string, n2, string2));
    }

    public static void register(String string, InputStream inputStream, int n2) {
        GlyphFontRegistry.register(new GlyphFont(string, n2, inputStream));
    }

    public static void register(GlyphFont glyphFont) {
        if (glyphFont != null) {
            fontMap.put(glyphFont.getName(), glyphFont);
        }
    }

    public static GlyphFont font(String string) {
        GlyphFont glyphFont = fontMap.get(string);
        if (glyphFont != null) {
            glyphFont.ensureFontIsLoaded();
        }
        return glyphFont;
    }

    static {
        ServiceLoader<GlyphFont> serviceLoader = ServiceLoader.load(GlyphFont.class);
        for (GlyphFont glyphFont : serviceLoader) {
            GlyphFontRegistry.register(glyphFont);
        }
    }
}

