/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.glyphfont;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javafx.scene.text.Font;
import org.controlsfx.glyphfont.Glyph;
import org.controlsfx.glyphfont.INamedCharacter;

public class GlyphFont {
    private final Map<String, Character> namedGlyphs = new HashMap<String, Character>();
    private final Runnable fontLoader;
    private final String fontName;
    private final double defaultSize;
    private boolean fontLoaded = false;

    public GlyphFont(String string, int n2, InputStream inputStream) {
        this(string, n2, inputStream, false);
    }

    public GlyphFont(String string, int n2, String string2) {
        this(string, n2, string2, false);
    }

    public GlyphFont(String string, int n2, InputStream inputStream, boolean bl2) {
        this(string, n2, () -> Font.loadFont((InputStream)inputStream, (double)-1.0), bl2);
    }

    public GlyphFont(String string, int n2, String string2, boolean bl2) {
        this(string, n2, () -> Font.loadFont((String)string2, (double)-1.0), bl2);
    }

    private GlyphFont(String string, int n2, Runnable runnable, boolean bl2) {
        this.fontName = string;
        this.defaultSize = n2;
        this.fontLoader = runnable;
        if (!bl2) {
            this.ensureFontIsLoaded();
        }
    }

    public String getName() {
        return this.fontName;
    }

    public double getDefaultSize() {
        return this.defaultSize;
    }

    public Glyph create(char c2) {
        return new Glyph(this.fontName, c2);
    }

    public Glyph create(String string) {
        return new Glyph(this.fontName, string);
    }

    public Glyph create(Enum<?> enum_) {
        return new Glyph(this.fontName, enum_);
    }

    public Character getCharacter(String string) {
        return this.namedGlyphs.get(string.toUpperCase());
    }

    public void registerAll(Iterable<? extends INamedCharacter> iterable) {
        for (INamedCharacter iNamedCharacter : iterable) {
            this.register(iNamedCharacter.name(), Character.valueOf(iNamedCharacter.getChar()));
        }
    }

    public void register(String string, Character c2) {
        this.namedGlyphs.put(string.toUpperCase(), c2);
    }

    synchronized void ensureFontIsLoaded() {
        if (!this.fontLoaded) {
            this.fontLoader.run();
            this.fontLoaded = true;
        }
    }
}

