/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.dialog;

import impl.org.controlsfx.ImplUtils;
import impl.org.controlsfx.i18n.Localization;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Stack;
import java.util.function.BooleanSupplier;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.layout.Pane;
import javafx.stage.Screen;
import javafx.stage.Window;
import org.controlsfx.dialog.WizardPane;
import org.controlsfx.tools.ValueExtractor;

public class Wizard {
    private Dialog<ButtonType> dialog;
    private final ObservableMap<String, Object> settings = FXCollections.observableHashMap();
    private final Stack<WizardPane> pageHistory = new Stack();
    private Optional<WizardPane> currentPage = Optional.empty();
    private final BooleanProperty invalidProperty = new SimpleBooleanProperty(false);
    private final BooleanProperty readSettingsProperty = new SimpleBooleanProperty(true);
    private final ButtonType BUTTON_PREVIOUS = new ButtonType(Localization.localize(Localization.asKey("wizard.previous.button")), ButtonBar.ButtonData.BACK_PREVIOUS);
    private final EventHandler<ActionEvent> BUTTON_PREVIOUS_ACTION_HANDLER = actionEvent -> {
        actionEvent.consume();
        Optional<Object> optional = Optional.ofNullable(this.pageHistory.isEmpty() ? null : this.pageHistory.pop());
        this.updatePage(this.dialog, optional, false);
    };
    private final ButtonType BUTTON_NEXT = new ButtonType(Localization.localize(Localization.asKey("wizard.next.button")), ButtonBar.ButtonData.NEXT_FORWARD);
    private final EventHandler<ActionEvent> BUTTON_NEXT_ACTION_HANDLER = actionEvent -> {
        actionEvent.consume();
        this.currentPage.ifPresent(wizardPane -> this.pageHistory.push((WizardPane)((Object)((Object)wizardPane))));
        Optional<WizardPane> optional = this.getFlow().advance(this.currentPage.orElse(null));
        this.updatePage(this.dialog, optional, true);
    };
    private final EventHandler<ActionEvent> BUTTON_FINISH_ACTION_HANDLER = actionEvent -> this.updatePage(this.dialog, Optional.empty(), true);
    private final EventHandler<ActionEvent> BUTTON_CANCEL_ACTION_HANDLER = actionEvent -> this.updatePage(this.dialog, Optional.empty(), false);
    private final StringProperty titleProperty = new SimpleStringProperty();
    private ObjectProperty<Flow> flow = new SimpleObjectProperty<Flow>((Flow)new LinearFlow(new WizardPane[0])){

        protected void invalidated() {
            Wizard.this.updatePage(Wizard.this.dialog, Optional.empty(), false);
        }

        public void set(Flow flow) {
            super.set((Object)flow);
            Wizard.this.pageHistory.clear();
            if (flow != null) {
                Optional<WizardPane> optional = flow.advance(Wizard.this.currentPage.orElse(null));
                Wizard.this.updatePage(Wizard.this.dialog, optional, true);
            }
        }
    };
    private static final Object USER_DATA_KEY = new Object();
    private ObservableMap<Object, Object> properties;
    private int settingCounter;

    public Wizard() {
        this(null);
    }

    public Wizard(Object object) {
        this(object, "");
    }

    public Wizard(Object object, String string) {
        this.invalidProperty.addListener((observableValue, bl2, bl3) -> this.validateActionState());
        this.dialog = new Dialog();
        this.dialog.titleProperty().bind((ObservableValue)this.titleProperty);
        this.setTitle(string);
        Window window = null;
        if (object instanceof Window) {
            window = (Window)object;
        } else if (object instanceof Node) {
            window = ((Node)object).getScene().getWindow();
        }
        this.dialog.initOwner(window);
    }

    public final Optional<ButtonType> showAndWait() {
        return this.dialog.showAndWait();
    }

    public final ObjectProperty<ButtonType> resultProperty() {
        return this.dialog.resultProperty();
    }

    public final ObservableMap<String, Object> getSettings() {
        return this.settings;
    }

    public final StringProperty titleProperty() {
        return this.titleProperty;
    }

    public final String getTitle() {
        return (String)this.titleProperty.get();
    }

    public final void setTitle(String string) {
        this.titleProperty.set((Object)string);
    }

    public final ObjectProperty<Flow> flowProperty() {
        return this.flow;
    }

    public final Flow getFlow() {
        return (Flow)this.flow.get();
    }

    public final void setFlow(Flow flow) {
        this.flow.set((Object)flow);
    }

    public final ObservableMap<Object, Object> getProperties() {
        if (this.properties == null) {
            this.properties = FXCollections.observableMap(new HashMap());
        }
        return this.properties;
    }

    public boolean hasProperties() {
        return this.properties != null && !this.properties.isEmpty();
    }

    public void setUserData(Object object) {
        this.getProperties().put(USER_DATA_KEY, object);
    }

    public Object getUserData() {
        return this.getProperties().get(USER_DATA_KEY);
    }

    public final void setInvalid(boolean bl2) {
        this.invalidProperty.set(bl2);
    }

    public final boolean isInvalid() {
        return this.invalidProperty.get();
    }

    public final BooleanProperty invalidProperty() {
        return this.invalidProperty;
    }

    public final void setReadSettings(boolean bl2) {
        this.readSettingsProperty.set(bl2);
    }

    public final boolean isReadSettings() {
        return this.readSettingsProperty.get();
    }

    public final BooleanProperty readSettingsProperty() {
        return this.readSettingsProperty;
    }

    private void updatePage(Dialog<ButtonType> dialog, Optional<WizardPane> optional, boolean bl2) {
        Flow flow = this.getFlow();
        if (flow == null) {
            return;
        }
        Optional<WizardPane> optional2 = this.currentPage;
        optional2.ifPresent(wizardPane -> {
            if (bl2 && this.isReadSettings()) {
                this.readSettings((WizardPane)((Object)wizardPane));
            }
            wizardPane.onExitingPage(this);
        });
        this.currentPage = optional;
        this.currentPage.ifPresent(wizardPane -> {
            Wizard.addButtonIfMissing(wizardPane, this.BUTTON_PREVIOUS, this.BUTTON_PREVIOUS_ACTION_HANDLER);
            Wizard.addButtonIfMissing(wizardPane, this.BUTTON_NEXT, this.BUTTON_NEXT_ACTION_HANDLER);
            Wizard.addButtonIfMissing(wizardPane, ButtonType.FINISH, this.BUTTON_FINISH_ACTION_HANDLER);
            Wizard.addButtonIfMissing(wizardPane, ButtonType.CANCEL, this.BUTTON_CANCEL_ACTION_HANDLER);
            wizardPane.onEnteringPage(this);
            if (wizardPane.getParent() != null && wizardPane.getParent() instanceof Pane) {
                Pane pane = (Pane)wizardPane.getParent();
                pane.getChildren().remove((Object)wizardPane);
            }
            double d2 = dialog.getX();
            double d3 = dialog.getY();
            double d4 = dialog.getWidth();
            double d5 = dialog.getHeight();
            dialog.setDialogPane((DialogPane)wizardPane);
            Window window = wizardPane.getScene().getWindow();
            window.sizeToScene();
            if (!Double.isNaN(d2) && !Double.isNaN(d3)) {
                double d6 = dialog.getWidth();
                double d7 = dialog.getHeight();
                int n2 = (int)(d2 + d4 / 2.0 - d6 / 2.0);
                int n3 = (int)(d3 + d5 / 2.0 - d7 / 2.0);
                ObservableList observableList = Screen.getScreensForRectangle((double)d2, (double)d3, (double)1.0, (double)1.0);
                Screen screen = observableList.isEmpty() ? Screen.getPrimary() : (Screen)observableList.get(0);
                Rectangle2D rectangle2D = screen.getBounds();
                int n4 = (int)Math.round(rectangle2D.getMinX());
                int n5 = (int)Math.round(rectangle2D.getMaxX());
                int n6 = (int)Math.round(rectangle2D.getMinY());
                int n7 = (int)Math.round(rectangle2D.getMaxY());
                if ((double)n2 + d6 > (double)n5) {
                    n2 = n5 - (int)Math.round(d6);
                }
                if ((double)n3 + d7 > (double)n7) {
                    n3 = n7 - (int)Math.round(d7);
                }
                if (n2 < n4) {
                    n2 = n4;
                }
                if (n3 < n6) {
                    n3 = n6;
                }
                dialog.setX((double)n2);
                dialog.setY((double)n3);
            }
        });
        this.validateActionState();
    }

    private static void addButtonIfMissing(WizardPane wizardPane, ButtonType buttonType, EventHandler<ActionEvent> eventHandler) {
        ObservableList observableList = wizardPane.getButtonTypes();
        if (!observableList.contains(buttonType)) {
            observableList.add(buttonType);
            Button button = (Button)wizardPane.lookupButton(buttonType);
            button.addEventFilter(ActionEvent.ACTION, eventHandler);
        }
    }

    private void validateActionState() {
        ObservableList observableList = this.dialog.getDialogPane().getButtonTypes();
        if (this.getFlow().canAdvance(this.currentPage.orElse(null))) {
            observableList.remove(ButtonType.FINISH);
        } else {
            observableList.remove(this.BUTTON_NEXT);
        }
        this.validateButton(this.BUTTON_PREVIOUS, () -> this.pageHistory.isEmpty());
        this.validateButton(this.BUTTON_NEXT, () -> this.invalidProperty.get());
        this.validateButton(ButtonType.FINISH, () -> this.invalidProperty.get());
    }

    private void validateButton(ButtonType buttonType, BooleanSupplier booleanSupplier) {
        Button button = (Button)this.dialog.getDialogPane().lookupButton(buttonType);
        if (button != null) {
            Node node = button.getScene() != null ? button.getScene().getFocusOwner() : null;
            button.setDisable(booleanSupplier.getAsBoolean());
            if (node != null) {
                node.requestFocus();
            }
        }
    }

    private void readSettings(WizardPane wizardPane) {
        this.settingCounter = 0;
        this.checkNode(wizardPane.getContent());
    }

    private boolean checkNode(Node node) {
        boolean bl2 = this.readSetting(node);
        if (bl2) {
            return true;
        }
        List<Node> list = ImplUtils.getChildren(node, true);
        boolean bl3 = false;
        for (Node node2 : list) {
            bl3 |= this.checkNode(node2);
        }
        return bl3;
    }

    private boolean readSetting(Node node) {
        if (node == null) {
            return false;
        }
        Object object = ValueExtractor.getValue(node);
        if (object != null) {
            Object object2 = node.getId();
            if (object2 == null || ((String)object2).isEmpty()) {
                object2 = "page_.setting_" + this.settingCounter;
            }
            this.getSettings().put(object2, object);
            ++this.settingCounter;
        }
        return object != null;
    }

    Dialog<ButtonType> getDialog() {
        return this.dialog;
    }

    public static class LinearFlow
    implements Flow {
        private final List<WizardPane> pages;

        public LinearFlow(Collection<WizardPane> collection) {
            this.pages = new ArrayList<WizardPane>(collection);
        }

        public LinearFlow(WizardPane ... wizardPaneArray) {
            this(Arrays.asList(wizardPaneArray));
        }

        @Override
        public Optional<WizardPane> advance(WizardPane wizardPane) {
            int n2 = this.pages.indexOf((Object)wizardPane);
            return Optional.ofNullable(this.pages.get(++n2));
        }

        @Override
        public boolean canAdvance(WizardPane wizardPane) {
            int n2 = this.pages.indexOf((Object)wizardPane);
            return this.pages.size() - 1 > n2;
        }
    }

    public static interface Flow {
        public Optional<WizardPane> advance(WizardPane var1);

        public boolean canAdvance(WizardPane var1);
    }
}

