/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.dialog;

import impl.org.controlsfx.i18n.Localization;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Control;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.image.ImageView;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import javafx.util.Pair;
import org.controlsfx.control.textfield.CustomPasswordField;
import org.controlsfx.control.textfield.CustomTextField;
import org.controlsfx.control.textfield.TextFields;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class LoginDialog
extends Dialog<Pair<String, String>> {
    private final ButtonType loginButtonType;
    private final CustomTextField txUserName;
    private final CustomPasswordField txPassword;

    public LoginDialog(Pair<String, String> pair, Callback<Pair<String, String>, Void> callback) {
        DialogPane dialogPane = this.getDialogPane();
        this.setTitle(Localization.getString("login.dlg.title"));
        dialogPane.setHeaderText(Localization.getString("login.dlg.header"));
        dialogPane.getStyleClass().add((Object)"login-dialog");
        dialogPane.getStylesheets().add((Object)LoginDialog.class.getResource("dialogs.css").toExternalForm());
        dialogPane.getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.CANCEL});
        this.txUserName = (CustomTextField)TextFields.createClearableTextField();
        this.txUserName.setLeft((Node)new ImageView(LoginDialog.class.getResource("/org/controlsfx/dialog/user.png").toExternalForm()));
        this.txPassword = (CustomPasswordField)TextFields.createClearablePasswordField();
        this.txPassword.setLeft((Node)new ImageView(LoginDialog.class.getResource("/org/controlsfx/dialog/lock.png").toExternalForm()));
        Label label = new Label("");
        label.getStyleClass().addAll((Object[])new String[]{"message-banner"});
        label.setVisible(false);
        label.setManaged(false);
        VBox vBox = new VBox(10.0);
        vBox.getChildren().add((Object)label);
        vBox.getChildren().add((Object)this.txUserName);
        vBox.getChildren().add((Object)this.txPassword);
        dialogPane.setContent((Node)vBox);
        this.loginButtonType = new ButtonType(Localization.getString("login.dlg.login.button"), ButtonBar.ButtonData.OK_DONE);
        dialogPane.getButtonTypes().addAll((Object[])new ButtonType[]{this.loginButtonType});
        Button button = (Button)dialogPane.lookupButton(this.loginButtonType);
        button.setOnAction(actionEvent -> {
            try {
                if (callback != null) {
                    callback.call((Object)new Pair((Object)this.txUserName.getText(), (Object)this.txPassword.getText()));
                }
                label.setVisible(false);
                label.setManaged(false);
                this.hide();
            }
            catch (Throwable throwable) {
                label.setVisible(true);
                label.setManaged(true);
                label.setText(throwable.getMessage());
                throwable.printStackTrace();
            }
        });
        String string = Localization.getString("login.dlg.user.caption");
        String string2 = Localization.getString("login.dlg.pswd.caption");
        this.txUserName.setPromptText(string);
        this.txUserName.setText(pair == null ? "" : (String)pair.getKey());
        this.txPassword.setPromptText(string2);
        this.txPassword.setText(new String(pair == null ? "" : (String)pair.getValue()));
        ValidationSupport validationSupport = new ValidationSupport();
        Platform.runLater(() -> {
            String string3 = "'%s' is required";
            validationSupport.registerValidator((Control)this.txUserName, Validator.createEmptyValidator(String.format(string3, string)));
            validationSupport.registerValidator((Control)this.txPassword, Validator.createEmptyValidator(String.format(string3, string2)));
            this.txUserName.requestFocus();
        });
        this.setResultConverter(buttonType -> buttonType == this.loginButtonType ? new Pair((Object)this.txUserName.getText(), (Object)this.txPassword.getText()) : null);
    }
}

