/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.textfield;

import impl.org.controlsfx.autocompletion.AutoCompletionTextFieldBinding;
import impl.org.controlsfx.autocompletion.SuggestionProvider;
import java.util.Arrays;
import java.util.Collection;
import javafx.animation.FadeTransition;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.util.Callback;
import javafx.util.Duration;
import javafx.util.StringConverter;
import org.controlsfx.control.textfield.AutoCompletionBinding;
import org.controlsfx.control.textfield.CustomPasswordField;
import org.controlsfx.control.textfield.CustomTextField;

public class TextFields {
    private static final Duration FADE_DURATION = Duration.millis((double)350.0);

    private TextFields() {
    }

    public static TextField createClearableTextField() {
        CustomTextField customTextField = new CustomTextField();
        TextFields.setupClearButtonField(customTextField, customTextField.rightProperty());
        return customTextField;
    }

    public static PasswordField createClearablePasswordField() {
        CustomPasswordField customPasswordField = new CustomPasswordField();
        TextFields.setupClearButtonField((TextField)customPasswordField, customPasswordField.rightProperty());
        return customPasswordField;
    }

    private static void setupClearButtonField(final TextField textField, ObjectProperty<Node> objectProperty) {
        textField.getStyleClass().add((Object)"clearable-field");
        Region region = new Region();
        region.getStyleClass().addAll((Object[])new String[]{"graphic"});
        StackPane stackPane = new StackPane(new Node[]{region});
        stackPane.getStyleClass().addAll((Object[])new String[]{"clear-button"});
        stackPane.setOpacity(0.0);
        stackPane.setCursor(Cursor.DEFAULT);
        stackPane.setOnMouseReleased(mouseEvent -> textField.clear());
        stackPane.managedProperty().bind((ObservableValue)textField.editableProperty());
        stackPane.visibleProperty().bind((ObservableValue)textField.editableProperty());
        objectProperty.set((Object)stackPane);
        final FadeTransition fadeTransition = new FadeTransition(FADE_DURATION, (Node)stackPane);
        fadeTransition.setCycleCount(1);
        textField.textProperty().addListener(new InvalidationListener(){
            private boolean isButtonVisible = false;

            public void invalidated(Observable observable) {
                boolean bl2;
                String string = textField.getText();
                boolean bl3 = bl2 = string == null || string.isEmpty();
                if (bl2 == this.isButtonVisible) {
                    this.isButtonVisible = !bl2;
                    this.fadeTo(this.isButtonVisible);
                }
            }

            private void fadeTo(boolean bl2) {
                fadeTransition.stop();
                fadeTransition.setFromValue(bl2 ? 0.0 : 1.0);
                fadeTransition.setToValue(bl2 ? 1.0 : 0.0);
                fadeTransition.play();
            }
        });
    }

    public static <T> AutoCompletionBinding<T> bindAutoCompletion(TextField textField, Callback<AutoCompletionBinding.ISuggestionRequest, Collection<T>> callback, StringConverter<T> stringConverter) {
        return new AutoCompletionTextFieldBinding<T>(textField, callback, stringConverter);
    }

    public static <T> AutoCompletionBinding<T> bindAutoCompletion(TextField textField, Callback<AutoCompletionBinding.ISuggestionRequest, Collection<T>> callback) {
        return new AutoCompletionTextFieldBinding<T>(textField, callback);
    }

    public static <T> AutoCompletionBinding<T> bindAutoCompletion(TextField textField, T ... TArray) {
        return TextFields.bindAutoCompletion(textField, Arrays.asList(TArray));
    }

    public static <T> AutoCompletionBinding<T> bindAutoCompletion(TextField textField, Collection<T> collection) {
        return new AutoCompletionTextFieldBinding(textField, SuggestionProvider.create(collection));
    }
}

