/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.tableview2;

import impl.org.controlsfx.tableview2.RowHeader;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.css.PseudoClass;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TableView;
import org.controlsfx.control.tableview2.FilteredTableView;
import org.controlsfx.control.tableview2.TableColumn2;

public class FilteredTableColumn<S, T>
extends TableColumn2<S, T> {
    private static final PseudoClass FILTER_ON = PseudoClass.getPseudoClass((String)"filtered");
    private final HashMap<CellIdentity<S>, ChangeListener<T>> trackedCells = new HashMap();
    private final Button filterButton;
    private final ListChangeListener<S> backingListListener = change -> {
        while (change.next()) {
            if (change.wasAdded()) {
                change.getAddedSubList().forEach(object -> this.addBackingItem(object, this.getCellObservableValue(object)));
            }
            if (!change.wasRemoved()) continue;
            change.getRemoved().forEach(object -> this.removeBackingItem(object, this.getCellObservableValue(object)));
        }
    };
    private final WeakListChangeListener<S> weakListChangeListener = new WeakListChangeListener(this.backingListListener);
    private final ChangeListener<T> changeListener = (observableValue, object, object2) -> Platform.runLater(() -> this.runOnFilteredTableView(FilteredTableView::filter));
    private final ChangeListener<Predicate<?>> filterListener = (observableValue, predicate, predicate2) -> this.updateButton(predicate2 != null);
    private final WeakChangeListener<Predicate<?>> weakFilterListener = new WeakChangeListener(this.filterListener);
    private final InvalidationListener tableListener = observable -> this.init();
    private final WeakInvalidationListener weakTableListener = new WeakInvalidationListener(this.tableListener);
    private InvalidationListener itemsPropertyListener;
    private WeakInvalidationListener weakItemsPropertyListener;
    private InvalidationListener parentListener;
    private WeakInvalidationListener weakParentListener;
    private final BooleanProperty filterable = new SimpleBooleanProperty((Object)this, "filterable", true);
    private final ObjectProperty<Predicate<? super T>> predicate = new SimpleObjectProperty<Predicate<? super T>>((Object)this, "predicate", null){

        protected void invalidated() {
            FilteredTableColumn.this.getFilteredTableView().ifPresent(FilteredTableView::filter);
        }
    };
    private final ObjectProperty<EventHandler<ActionEvent>> onFilterAction = new SimpleObjectProperty((Object)this, "onFilterAction", null);

    public FilteredTableColumn() {
        this.tableViewProperty().addListener((InvalidationListener)this.weakTableListener);
        this.filterButton = new Button();
        this.filterButton.getStyleClass().add((Object)"filter");
        this.filterButton.onActionProperty().bind(this.onFilterActionProperty());
        this.filterButton.disableProperty().bind((ObservableValue)this.filterableProperty().not());
        this.setGraphic((Node)this.filterButton);
        this.updateButton(this.getPredicate() != null);
        this.predicateProperty().addListener(this.weakFilterListener);
    }

    public FilteredTableColumn(String string) {
        this();
        this.setText(string);
    }

    public final void setFilterable(boolean bl2) {
        this.filterable.set(bl2);
    }

    public final boolean isFilterable() {
        return this.filterable.get();
    }

    public final BooleanProperty filterableProperty() {
        return this.filterable;
    }

    public final void setPredicate(Predicate<? super T> predicate) {
        this.predicate.set(predicate);
    }

    public final Predicate<? super T> getPredicate() {
        return (Predicate)this.predicate.get();
    }

    public final ObservableValue<Predicate<? super T>> predicateProperty() {
        return this.predicate;
    }

    public final ObjectProperty<EventHandler<ActionEvent>> onFilterActionProperty() {
        return this.onFilterAction;
    }

    public final void setOnFilterAction(EventHandler<ActionEvent> eventHandler) {
        this.onFilterAction.set(eventHandler);
    }

    public final EventHandler<ActionEvent> getOnFilterAction() {
        return (EventHandler)this.onFilterAction.get();
    }

    private void init() {
        this.runOnFilteredTableView(filteredTableView -> {
            this.itemsPropertyListener = observable -> {
                if (filteredTableView.getItems() != null) {
                    ObservableList observableList = filteredTableView.getBackingList();
                    if (observableList != null) {
                        observableList.forEach(object -> this.addBackingItem(object, this.getCellObservableValue(object)));
                        observableList.addListener(this.weakListChangeListener);
                    }
                    filteredTableView.itemsProperty().removeListener((InvalidationListener)this.weakItemsPropertyListener);
                }
            };
            this.weakItemsPropertyListener = new WeakInvalidationListener(this.itemsPropertyListener);
            filteredTableView.itemsProperty().addListener((InvalidationListener)this.weakItemsPropertyListener);
            if (filteredTableView.getParent() != null) {
                this.updateFilterButton((TableView<S>)filteredTableView);
            } else {
                this.parentListener = observable -> {
                    if (filteredTableView.getParent() != null) {
                        this.updateFilterButton((TableView<S>)filteredTableView);
                        filteredTableView.parentProperty().removeListener((InvalidationListener)this.weakParentListener);
                    }
                };
                this.weakParentListener = new WeakInvalidationListener(this.parentListener);
                filteredTableView.parentProperty().addListener((InvalidationListener)this.weakParentListener);
            }
        });
    }

    private void updateButton(boolean bl2) {
        this.filterButton.pseudoClassStateChanged(FILTER_ON, bl2);
    }

    private void updateFilterButton(TableView<S> tableView) {
        if (tableView.getParent() instanceof RowHeader) {
            FilteredTableView filteredTableView = (FilteredTableView)((RowHeader)tableView.getParent()).getParentTableView();
            this.updateButton(filteredTableView.getPredicate() != null);
            filteredTableView.predicateProperty().addListener(this.weakFilterListener);
        }
    }

    private void addBackingItem(S s2, ObservableValue<T> observableValue) {
        if (observableValue == null) {
            return;
        }
        CellIdentity<S> cellIdentity = new CellIdentity<S>(s2);
        WeakChangeListener weakChangeListener = new WeakChangeListener(this.changeListener);
        observableValue.addListener((ChangeListener)weakChangeListener);
        this.trackedCells.put(cellIdentity, (ChangeListener<T>)weakChangeListener);
    }

    private void removeBackingItem(S s2, ObservableValue<T> observableValue) {
        if (observableValue == null) {
            return;
        }
        ChangeListener<T> changeListener = this.trackedCells.remove(new CellIdentity<S>(s2));
        observableValue.removeListener(changeListener);
    }

    private void runOnFilteredTableView(Consumer<FilteredTableView> consumer) {
        this.getFilteredTableView().ifPresent(consumer);
    }

    private Optional<FilteredTableView<S>> getFilteredTableView() {
        TableView tableView = this.getTableView();
        if (tableView != null && tableView instanceof FilteredTableView) {
            return Optional.of((FilteredTableView)tableView);
        }
        return Optional.empty();
    }

    private static final class CellIdentity<S> {
        private final S item;

        CellIdentity(S s2) {
            this.item = s2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            CellIdentity cellIdentity = (CellIdentity)object;
            return Objects.equals(this.item, cellIdentity.item);
        }

        public int hashCode() {
            return System.identityHashCode(this.item);
        }
    }
}

