/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.table;

import java.lang.reflect.Field;
import java.util.function.Consumer;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.TableView;
import javafx.scene.control.TreeTableView;
import javafx.scene.control.skin.TableHeaderRow;
import javafx.scene.control.skin.TableViewSkin;
import javafx.scene.control.skin.TableViewSkinBase;

final class TableViewUtils {
    TableViewUtils() {
    }

    public static void modifyTableMenu(TableView<?> tableView, Consumer<ContextMenu> consumer) {
        TableViewUtils.modifyTableMenu(tableView, consumer);
    }

    public static void modifyTableMenu(TreeTableView<?> treeTableView, Consumer<ContextMenu> consumer) {
        TableViewUtils.modifyTableMenu(treeTableView, consumer);
    }

    private static void modifyTableMenu(final Control control, final Consumer<ContextMenu> consumer) {
        if (control.getScene() == null) {
            control.sceneProperty().addListener(new InvalidationListener(){

                public void invalidated(Observable observable) {
                    control.sceneProperty().removeListener((InvalidationListener)this);
                    TableViewUtils.modifyTableMenu(control, (Consumer<ContextMenu>)consumer);
                }
            });
            return;
        }
        Skin skin = control.getSkin();
        if (skin == null) {
            control.skinProperty().addListener(new InvalidationListener(){

                public void invalidated(Observable observable) {
                    control.skinProperty().removeListener((InvalidationListener)this);
                    TableViewUtils.modifyTableMenu(control, (Consumer<ContextMenu>)consumer);
                }
            });
            return;
        }
        TableViewUtils.doModify(skin, consumer);
    }

    private static void doModify(Skin<?> skin, Consumer<ContextMenu> consumer) {
        if (!(skin instanceof TableViewSkinBase)) {
            return;
        }
        TableViewSkin tableViewSkin = (TableViewSkin)skin;
        TableHeaderRow tableHeaderRow = TableViewUtils.getHeaderRow(tableViewSkin);
        if (tableHeaderRow == null) {
            return;
        }
        ContextMenu contextMenu = TableViewUtils.getContextMenu(tableHeaderRow);
        consumer.accept(contextMenu);
    }

    private static TableHeaderRow getHeaderRow(TableViewSkin<?> tableViewSkin) {
        ObservableList observableList = tableViewSkin.getChildren();
        int n2 = observableList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Node node = (Node)observableList.get(i2);
            if (!(node instanceof TableHeaderRow)) continue;
            return (TableHeaderRow)node;
        }
        return null;
    }

    private static ContextMenu getContextMenu(TableHeaderRow tableHeaderRow) {
        try {
            Field field = TableHeaderRow.class.getDeclaredField("columnPopupMenu");
            field.setAccessible(true);
            ContextMenu contextMenu = (ContextMenu)field.get(tableHeaderRow);
            return contextMenu;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            noSuchFieldException.printStackTrace();
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        return null;
    }
}

