/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.table;

import impl.org.controlsfx.skin.ExpandableTableRowSkin;
import java.util.HashMap;
import java.util.Map;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Skin;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.util.Callback;

public final class TableRowExpanderColumn<S>
extends TableColumn<S, Boolean> {
    private static final String STYLE_CLASS = "expander-column";
    private static final String EXPANDER_BUTTON_STYLE_CLASS = "expander-button";
    private final Map<S, Node> expandedNodeCache = new HashMap<S, Node>();
    private final Map<S, BooleanProperty> expansionState = new HashMap<S, BooleanProperty>();
    private Callback<TableRowDataFeatures<S>, Node> expandedNodeCallback;

    public BooleanProperty getExpandedProperty(S s2) {
        Object object = this.expansionState.get(s2);
        if (object == null) {
            object = new SimpleBooleanProperty(s2, "expanded", false){

                protected void invalidated() {
                    TableRowExpanderColumn.this.getTableView().refresh();
                    if (!this.getValue().booleanValue()) {
                        TableRowExpanderColumn.this.expandedNodeCache.remove(this.getBean());
                    }
                }
            };
            this.expansionState.put(s2, (BooleanProperty)object);
        }
        return object;
    }

    public Node getOrCreateExpandedNode(TableRow<S> tableRow) {
        int n2 = tableRow.getIndex();
        if (n2 > -1 && n2 < this.getTableView().getItems().size()) {
            Object object = this.getTableView().getItems().get(n2);
            Node node = this.expandedNodeCache.get(object);
            if (node == null) {
                node = (Node)this.expandedNodeCallback.call(new TableRowDataFeatures<Object>(tableRow, this, object));
                this.expandedNodeCache.put(object, node);
            }
            return node;
        }
        return null;
    }

    public Node getExpandedNode(S s2) {
        return this.expandedNodeCache.get(s2);
    }

    public TableRowExpanderColumn(Callback<TableRowDataFeatures<S>, Node> callback) {
        this.expandedNodeCallback = callback;
        this.getStyleClass().add((Object)STYLE_CLASS);
        this.setCellValueFactory(cellDataFeatures -> this.getExpandedProperty(cellDataFeatures.getValue()));
        this.setCellFactory(tableColumn -> new ToggleCell());
        this.installRowFactoryOnTableViewAssignment();
    }

    private void installRowFactoryOnTableViewAssignment() {
        this.tableViewProperty().addListener((observableValue, tableView2, tableView3) -> {
            if (tableView3 != null) {
                this.getTableView().setRowFactory(tableView -> new TableRow<S>(){

                    protected Skin<?> createDefaultSkin() {
                        return new ExpandableTableRowSkin(this, TableRowExpanderColumn.this);
                    }
                });
            }
        });
    }

    public void toggleExpanded(int n2) {
        BooleanProperty booleanProperty;
        booleanProperty.setValue(Boolean.valueOf((booleanProperty = (BooleanProperty)this.getCellObservableValue(n2)).getValue() == false));
    }

    public static final class TableRowDataFeatures<S> {
        private TableRow<S> tableRow;
        private TableRowExpanderColumn<S> tableColumn;
        private BooleanProperty expandedProperty;
        private S value;

        public TableRowDataFeatures(TableRow<S> tableRow, TableRowExpanderColumn<S> tableRowExpanderColumn, S s2) {
            this.tableRow = tableRow;
            this.tableColumn = tableRowExpanderColumn;
            this.expandedProperty = (BooleanProperty)tableRowExpanderColumn.getCellObservableValue(tableRow.getIndex());
            this.value = s2;
        }

        public TableRow<S> getTableRow() {
            return this.tableRow;
        }

        public TableRowExpanderColumn<S> getTableColumn() {
            return this.tableColumn;
        }

        public BooleanProperty expandedProperty() {
            return this.expandedProperty;
        }

        public void toggleExpanded() {
            BooleanProperty booleanProperty;
            booleanProperty.setValue(Boolean.valueOf((booleanProperty = this.expandedProperty()).getValue() == false));
        }

        public Boolean isExpanded() {
            return this.expandedProperty().getValue();
        }

        public void setExpanded(Boolean bl2) {
            this.expandedProperty().setValue(bl2);
        }

        public S getValue() {
            return this.value;
        }
    }

    private final class ToggleCell
    extends TableCell<S, Boolean> {
        private Button button = new Button();

        public ToggleCell() {
            this.button.setFocusTraversable(false);
            this.button.getStyleClass().add((Object)TableRowExpanderColumn.EXPANDER_BUTTON_STYLE_CLASS);
            this.button.setPrefSize(16.0, 16.0);
            this.button.setPadding(new Insets(0.0));
            this.button.setOnAction(actionEvent -> TableRowExpanderColumn.this.toggleExpanded(this.getIndex()));
        }

        protected void updateItem(Boolean bl2, boolean bl3) {
            super.updateItem((Object)bl2, bl3);
            if (bl2 == null || bl3) {
                this.setGraphic(null);
            } else {
                this.button.setText(bl2 != false ? "-" : "+");
                this.setGraphic((Node)this.button);
            }
        }
    }
}

