/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.table;

import java.util.Optional;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import org.controlsfx.control.table.ColumnFilter;

public final class FilterValue<T, R>
extends HBox
implements Comparable<FilterValue<T, R>> {
    private final R value;
    private final BooleanProperty isSelected = new SimpleBooleanProperty(true);
    private final BooleanProperty inScope = new SimpleBooleanProperty(true);
    private final ColumnFilter<T, R> columnFilter;
    private final InvalidationListener scopeListener;

    FilterValue(R r2, ColumnFilter<T, R> columnFilter) {
        this.value = r2;
        this.columnFilter = columnFilter;
        CheckBox checkBox = new CheckBox();
        Label label = new Label();
        label.setText((String)Optional.ofNullable(r2).map(Object::toString).orElse(null));
        this.scopeListener = observable -> label.textFillProperty().set((Object)(this.getInScopeProperty().get() ? Color.BLACK : Color.LIGHTGRAY));
        this.inScope.addListener((InvalidationListener)new WeakInvalidationListener(this.scopeListener));
        checkBox.selectedProperty().bindBidirectional((Property)this.selectedProperty());
        this.getChildren().addAll((Object[])new Node[]{checkBox, label});
    }

    public R getValue() {
        return this.value;
    }

    public BooleanProperty selectedProperty() {
        return this.isSelected;
    }

    public BooleanProperty getInScopeProperty() {
        return this.inScope;
    }

    void refreshScope() {
        this.inScope.setValue(Boolean.valueOf(this.columnFilter.wasLastFiltered() || this.columnFilter.valueIsVisible(this.value)));
    }

    public String toString() {
        return Optional.ofNullable(this.value).map(Object::toString).orElse("");
    }

    @Override
    public int compareTo(FilterValue<T, R> filterValue) {
        if (this.value != null && filterValue.value != null && this.value instanceof Comparable && filterValue.value instanceof Comparable) {
            return ((Comparable)this.value).compareTo((Comparable)filterValue.value);
        }
        return Optional.ofNullable(this.value).map(Object::toString).orElse("").compareTo(Optional.ofNullable(filterValue).map(Object::toString).orElse(""));
    }
}

