/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.spreadsheet;

import impl.org.controlsfx.spreadsheet.TableViewSpanSelectionModel;
import java.util.Arrays;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TablePosition;
import javafx.util.Pair;
import org.controlsfx.control.spreadsheet.SpreadsheetCell;
import org.controlsfx.control.spreadsheet.SpreadsheetColumn;
import org.controlsfx.control.spreadsheet.SpreadsheetView;

public class SpreadsheetViewSelectionModel {
    private final TableViewSpanSelectionModel selectionModel;
    private final SpreadsheetView spv;

    SpreadsheetViewSelectionModel(SpreadsheetView spreadsheetView, TableViewSpanSelectionModel tableViewSpanSelectionModel) {
        this.spv = spreadsheetView;
        this.selectionModel = tableViewSpanSelectionModel;
    }

    public final void clearAndSelect(int n2, SpreadsheetColumn spreadsheetColumn) {
        this.selectionModel.clearAndSelect(n2, spreadsheetColumn.column);
    }

    public final void clearAndSelect(SpreadsheetCell spreadsheetCell) {
        if (this.spv.isRowHidden(spreadsheetCell.getRow()) || this.spv.isColumnHidden(spreadsheetCell.getColumn())) {
            return;
        }
        int n2 = this.spv.getViewRow(spreadsheetCell.getRow());
        if (n2 != -1) {
            this.selectionModel.clearAndSelect(n2, ((SpreadsheetColumn)this.spv.getColumns().get((int)spreadsheetCell.getColumn())).column);
        }
    }

    private void clearAndSelectView(int n2, SpreadsheetColumn spreadsheetColumn) {
        this.selectionModel.clearAndSelect(n2, spreadsheetColumn.column);
    }

    public final void select(int n2, SpreadsheetColumn spreadsheetColumn) {
        this.selectionModel.select(this.spv.getFilteredRow(n2), spreadsheetColumn.column);
    }

    public final void clearSelection() {
        this.selectionModel.clearSelection();
    }

    public final ObservableList<TablePosition> getSelectedCells() {
        return this.selectionModel.getSelectedCells();
    }

    public final void selectAll() {
        this.selectionModel.selectAll();
    }

    public final TablePosition getFocusedCell() {
        return this.selectionModel.getTableView().getFocusModel().getFocusedCell();
    }

    public final void focus(int n2, SpreadsheetColumn spreadsheetColumn) {
        this.selectionModel.getTableView().getFocusModel().focus(n2, spreadsheetColumn.column);
    }

    public final void setSelectionMode(SelectionMode selectionMode) {
        this.selectionModel.setSelectionMode(selectionMode);
    }

    public SelectionMode getSelectionMode() {
        return this.selectionModel.getSelectionMode();
    }

    public void selectCells(List<Pair<Integer, Integer>> list) {
        this.selectionModel.verifySelectedCells(list);
    }

    public void selectCells(Pair<Integer, Integer> ... pairArray) {
        this.selectionModel.verifySelectedCells(Arrays.asList(pairArray));
    }

    public void selectRange(int n2, SpreadsheetColumn spreadsheetColumn, int n3, SpreadsheetColumn spreadsheetColumn2) {
        this.selectionModel.selectRange(this.spv.getFilteredRow(n2), (TableColumnBase<ObservableList<SpreadsheetCell>, ?>)spreadsheetColumn.column, this.spv.getFilteredRow(n3), (TableColumnBase<ObservableList<SpreadsheetCell>, ?>)spreadsheetColumn2.column);
    }

    public void clearAndSelectLeftCell() {
        TablePosition tablePosition = this.getFocusedCell();
        int n2 = tablePosition.getRow();
        int n3 = tablePosition.getColumn();
        if (--n3 < 0) {
            if (n2 == 0) {
                ++n3;
            } else {
                n3 = this.selectionModel.getTableView().getVisibleLeafColumns().size() - 1;
                --n2;
                this.selectionModel.direction = new Pair((Object)-1, (Object)-1);
            }
            this.clearAndSelectView(n2, (SpreadsheetColumn)this.spv.getColumns().get(this.spv.getModelColumn(n3)));
        } else {
            this.spv.getCellsViewSkin().getBehavior().selectCell(0, -1);
        }
    }

    public void clearAndSelectRightCell() {
        TablePosition tablePosition = this.getFocusedCell();
        int n2 = tablePosition.getRow();
        int n3 = tablePosition.getColumn();
        if (++n3 >= this.selectionModel.getTableView().getVisibleLeafColumns().size()) {
            if (n2 == this.spv.getGrid().getRowCount() - 1) {
                --n3;
            } else {
                this.selectionModel.direction = new Pair((Object)1, (Object)1);
                n3 = 0;
                ++n2;
            }
            this.clearAndSelectView(n2, (SpreadsheetColumn)this.spv.getColumns().get(this.spv.getModelColumn(n3)));
        } else {
            this.spv.getCellsViewSkin().getBehavior().selectCell(0, 1);
        }
    }
}

