/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.spreadsheet;

import impl.org.controlsfx.i18n.Localization;
import impl.org.controlsfx.spreadsheet.CellView;
import impl.org.controlsfx.spreadsheet.FocusModelListener;
import impl.org.controlsfx.spreadsheet.GridViewSkin;
import impl.org.controlsfx.spreadsheet.RectangleSelection;
import impl.org.controlsfx.spreadsheet.SpreadsheetGridView;
import impl.org.controlsfx.spreadsheet.SpreadsheetHandle;
import impl.org.controlsfx.spreadsheet.TableViewSpanSelectionModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.event.WeakEventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Skin;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DataFormat;
import javafx.scene.input.KeyCharacterCombination;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.transform.Scale;
import javafx.stage.WindowEvent;
import javafx.util.Pair;
import org.controlsfx.control.spreadsheet.CellGraphicFactory;
import org.controlsfx.control.spreadsheet.ClipboardCell;
import org.controlsfx.control.spreadsheet.Grid;
import org.controlsfx.control.spreadsheet.GridBase;
import org.controlsfx.control.spreadsheet.Picker;
import org.controlsfx.control.spreadsheet.SpreadsheetCell;
import org.controlsfx.control.spreadsheet.SpreadsheetCellEditor;
import org.controlsfx.control.spreadsheet.SpreadsheetCellType;
import org.controlsfx.control.spreadsheet.SpreadsheetColumn;
import org.controlsfx.control.spreadsheet.SpreadsheetViewSelectionModel;
import org.controlsfx.tools.Utils;

public class SpreadsheetView
extends Control {
    private static final double DEFAULT_ROW_HEADER_WIDTH = 30.0;
    private final SpreadsheetGridView cellsView;
    private SimpleObjectProperty<Grid> gridProperty = new SimpleObjectProperty();
    private DataFormat fmt;
    private final ObservableList<Integer> fixedRows = FXCollections.observableArrayList();
    private final ObservableList<SpreadsheetColumn> fixedColumns = FXCollections.observableArrayList();
    private final BooleanProperty fixingRowsAllowedProperty = new SimpleBooleanProperty(true);
    private final BooleanProperty fixingColumnsAllowedProperty = new SimpleBooleanProperty(true);
    private final BooleanProperty showColumnHeader = new SimpleBooleanProperty((Object)true, "showColumnHeader", true);
    private final BooleanProperty showRowHeader = new SimpleBooleanProperty((Object)true, "showRowHeader", true);
    private BitSet rowFix;
    private final ObservableMap<Integer, Picker> rowPickers = FXCollections.observableHashMap();
    private final ObservableMap<Integer, Picker> columnPickers = FXCollections.observableHashMap();
    private ObservableList<SpreadsheetColumn> columns = FXCollections.observableArrayList();
    private Map<SpreadsheetCellType<?>, SpreadsheetCellEditor> editors = new IdentityHashMap();
    private final SpreadsheetViewSelectionModel selectionModel;
    private final KeyCombination zoomOutChar = new KeyCharacterCombination("-", new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
    private final KeyCombination zoomOutKeypad = new KeyCodeCombination(KeyCode.SUBTRACT, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
    private final KeyCombination zoomInChar = new KeyCharacterCombination("+", new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
    private final KeyCombination zoomInCharShift = new KeyCharacterCombination("+", new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN, KeyCombination.SHIFT_DOWN});
    private final KeyCombination zoomInKeypadAdd = new KeyCodeCombination(KeyCode.ADD, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
    private final KeyCombination zoomNormalKeypad = new KeyCodeCombination(KeyCode.NUMPAD0, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
    private final KeyCombination zoomNormal = new KeyCodeCombination(KeyCode.DIGIT0, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
    private final KeyCombination zoomNormalShift = new KeyCodeCombination(KeyCode.DIGIT0, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN, KeyCombination.SHIFT_DOWN});
    private final DoubleProperty rowHeaderWidth = new SimpleDoubleProperty(30.0);
    private DoubleProperty zoomFactor = new SimpleDoubleProperty(1.0);
    private static final double MIN_ZOOM = 0.2;
    private static final double MAX_ZOOM = 2.0;
    private static final double STEP_ZOOM = 0.1;
    private final ObjectProperty<BitSet> hiddenRowsProperty = new SimpleObjectProperty();
    private IdentityHashMap<ObservableList<SpreadsheetCell>, Integer> identityMap;
    private final ObjectProperty<BitSet> hiddenColumnsProperty = new SimpleObjectProperty();
    private HashMap<Integer, Integer> rowMap;
    private HashMap<Integer, Integer> columnMap = new HashMap();
    private Integer filteredRow;
    private FilteredList<ObservableList<SpreadsheetCell>> filteredList;
    private SortedList<ObservableList<SpreadsheetCell>> sortedList;
    private CellGraphicFactory cellGraphicFactory;
    private String stylesheet;
    private final BitSet columnWidthSet = new BitSet();
    final SpreadsheetHandle handle = new SpreadsheetHandle(){

        @Override
        protected SpreadsheetView getView() {
            return SpreadsheetView.this;
        }

        @Override
        protected GridViewSkin getCellsViewSkin() {
            return SpreadsheetView.this.getCellsViewSkin();
        }

        @Override
        protected SpreadsheetGridView getGridView() {
            return SpreadsheetView.this.getCellsView();
        }

        @Override
        protected boolean isColumnWidthSet(int n2) {
            return SpreadsheetView.this.columnWidthSet.get(n2);
        }
    };
    private final ListChangeListener<Integer> fixedRowsListener = new ListChangeListener<Integer>(){

        public void onChanged(ListChangeListener.Change<? extends Integer> change) {
            while (change.next()) {
                if (change.wasAdded()) {
                    List list = change.getAddedSubList();
                    if (!SpreadsheetView.this.areRowsFixable(list)) {
                        throw new IllegalArgumentException(SpreadsheetView.this.computeReason(list));
                    }
                    FXCollections.sort(SpreadsheetView.this.fixedRows);
                }
                if (!change.wasRemoved()) continue;
            }
        }
    };
    private final ListChangeListener<SpreadsheetColumn> fixedColumnsListener = new ListChangeListener<SpreadsheetColumn>(){

        public void onChanged(ListChangeListener.Change<? extends SpreadsheetColumn> change) {
            while (change.next()) {
                List list;
                if (!change.wasAdded() || SpreadsheetView.this.areSpreadsheetColumnsFixable(list = change.getAddedSubList())) continue;
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                for (SpreadsheetColumn spreadsheetColumn : list) {
                    if (spreadsheetColumn == null) continue;
                    arrayList.add(SpreadsheetView.this.columns.indexOf((Object)spreadsheetColumn));
                }
                throw new IllegalArgumentException(this.computeReason(arrayList));
            }
        }

        private String computeReason(List<Integer> list) {
            Object object = "\n This column cannot be frozen.";
            ObservableList<ObservableList<SpreadsheetCell>> observableList = SpreadsheetView.this.getGrid().getRows();
            for (Integer n2 : list) {
                if (SpreadsheetView.this.isColumnFixable(n2)) continue;
                int n3 = 1;
                for (List list2 : observableList) {
                    SpreadsheetCell spreadsheetCell = (SpreadsheetCell)list2.get(n2);
                    if (!list.contains(spreadsheetCell.getColumn())) {
                        object = (String)object + "The column " + n2 + " is inside a column span and the starting column " + spreadsheetCell.getColumn() + " is not frozen.\n";
                    }
                    if (spreadsheetCell.getColumnSpan() <= n3 || spreadsheetCell.getColumn() != n2.intValue()) continue;
                    n3 = spreadsheetCell.getColumnSpan();
                }
                int n4 = n2 + n3 - 1;
                for (int i2 = n2 + 1; i2 < n4; ++i2) {
                    if (list.contains(i2)) continue;
                    object = (String)object + "One cell on the column " + n2 + " has a column span of " + n3 + ". But the column " + i2 + " contained within that span is not frozen.\n";
                }
            }
            return object;
        }
    };
    private final ChangeListener<ContextMenu> contextMenuChangeListener = new ChangeListener<ContextMenu>(){

        public void changed(ObservableValue<? extends ContextMenu> observableValue, ContextMenu contextMenu, ContextMenu contextMenu2) {
            if (contextMenu != null) {
                contextMenu.setOnShowing(null);
            }
            if (contextMenu2 != null) {
                contextMenu2.setOnShowing((EventHandler)new WeakEventHandler(SpreadsheetView.this.hideContextMenuEventHandler));
            }
        }
    };
    private final EventHandler<WindowEvent> hideContextMenuEventHandler = new EventHandler<WindowEvent>(){

        public void handle(WindowEvent windowEvent) {
            if (SpreadsheetView.this.getEditingCell() != null) {
                Platform.runLater(() -> SpreadsheetView.this.getContextMenu().hide());
            }
        }
    };
    private final EventHandler<KeyEvent> keyPressedHandler = keyEvent -> {
        TablePosition tablePosition = this.getSelectionModel().getFocusedCell();
        if (this.getEditingCell() == null && KeyCode.ENTER.equals((Object)keyEvent.getCode())) {
            if (tablePosition != null) {
                if (keyEvent.isShiftDown()) {
                    this.getCellsViewSkin().getBehavior().selectCell(-1, 0);
                } else {
                    this.getCellsViewSkin().getBehavior().selectCell(1, 0);
                }
                keyEvent.consume();
            }
            this.getCellsViewSkin().scrollHorizontally();
        } else if (this.getEditingCell() == null && KeyCode.TAB.equals((Object)keyEvent.getCode()) && !keyEvent.isShortcutDown()) {
            if (tablePosition != null) {
                if (keyEvent.isShiftDown()) {
                    this.getSelectionModel().clearAndSelectLeftCell();
                } else {
                    this.getSelectionModel().clearAndSelectRightCell();
                }
            }
            keyEvent.consume();
            this.getCellsViewSkin().scrollHorizontally();
        } else if (KeyCode.DELETE.equals((Object)keyEvent.getCode())) {
            this.deleteSelectedCells();
        } else if (this.isEditionKey((KeyEvent)keyEvent)) {
            this.getCellsView().edit(tablePosition.getRow(), tablePosition.getTableColumn());
        } else if (this.zoomNormalKeypad.match(keyEvent) || this.zoomNormal.match(keyEvent) || this.zoomNormalShift.match(keyEvent)) {
            this.setZoomFactor(1.0);
        } else if (this.zoomInChar.match(keyEvent) || this.zoomInKeypadAdd.match(keyEvent) || this.zoomInCharShift.match(keyEvent)) {
            this.incrementZoom();
        } else if (this.zoomOutChar.match(keyEvent) || this.zoomOutKeypad.match(keyEvent)) {
            this.decrementZoom();
        }
    };

    final GridViewSkin getCellsViewSkin() {
        return (GridViewSkin)this.cellsView.getSkin();
    }

    final SpreadsheetGridView getCellsView() {
        return this.cellsView;
    }

    public String getUserAgentStylesheet() {
        if (this.stylesheet == null) {
            this.stylesheet = SpreadsheetView.class.getResource("spreadsheet.css").toExternalForm();
        }
        return this.stylesheet;
    }

    void columnWidthSet(int n2) {
        this.columnWidthSet.set(n2);
    }

    public SpreadsheetView() {
        this(SpreadsheetView.getSampleGrid());
        for (SpreadsheetColumn spreadsheetColumn : this.getColumns()) {
            spreadsheetColumn.setPrefWidth(100.0);
        }
    }

    public void setCellGraphicFactory(CellGraphicFactory cellGraphicFactory) {
        this.cellGraphicFactory = cellGraphicFactory;
    }

    public CellGraphicFactory getCellGraphicFactory() {
        return this.cellGraphicFactory;
    }

    public SpreadsheetView(Grid grid) {
        this.addEventHandler(RowHeightEvent.ROW_HEIGHT_CHANGE, rowHeightEvent -> {
            if (this.getFixedRows().contains((Object)this.getModelRow(rowHeightEvent.getRow())) && this.getCellsViewSkin() != null) {
                this.getCellsViewSkin().computeFixedRowHeight();
            }
        });
        this.hiddenRowsProperty.addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                SpreadsheetView.this.computeRowMap();
                SpreadsheetView.this.initRowFix(SpreadsheetView.this.getGrid());
            }
        });
        this.hiddenColumnsProperty.addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                SpreadsheetView.this.computeColumnMap();
                SpreadsheetView.this.initRowFix(SpreadsheetView.this.getGrid());
            }
        });
        this.getStyleClass().add((Object)"SpreadsheetView");
        this.setSkin((Skin)new Skin<SpreadsheetView>(){

            public Node getNode() {
                return SpreadsheetView.this.getCellsView();
            }

            public SpreadsheetView getSkinnable() {
                return SpreadsheetView.this;
            }

            public void dispose() {
            }
        });
        this.cellsView = new SpreadsheetGridView(this.handle);
        this.getChildren().add((Object)this.cellsView);
        TableViewSpanSelectionModel tableViewSpanSelectionModel = new TableViewSpanSelectionModel(this, this.cellsView);
        this.cellsView.setSelectionModel(tableViewSpanSelectionModel);
        tableViewSpanSelectionModel.setCellSelectionEnabled(true);
        tableViewSpanSelectionModel.setSelectionMode(SelectionMode.MULTIPLE);
        this.selectionModel = new SpreadsheetViewSelectionModel(this, tableViewSpanSelectionModel);
        this.cellsView.getFocusModel().focusedCellProperty().addListener((ChangeListener)new FocusModelListener(this, this.cellsView));
        this.cellsView.addEventFilter(KeyEvent.KEY_PRESSED, this.keyPressedHandler);
        this.contextMenuProperty().addListener((ChangeListener)new WeakChangeListener(this.contextMenuChangeListener));
        CellView.getValue(() -> this.setContextMenu(this.getSpreadsheetViewContextMenu()));
        this.setGrid(grid);
        this.setEditable(true);
        this.fixedRows.addListener(this.fixedRowsListener);
        this.fixedColumns.addListener(this.fixedColumnsListener);
        final Scale scale = new Scale(1.0, 1.0);
        this.getTransforms().add((Object)scale);
        this.zoomFactor.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
                scale.setX(number2.doubleValue());
                scale.setY(number2.doubleValue());
                SpreadsheetView.this.requestLayout();
            }
        });
        this.addEventFilter(ScrollEvent.ANY, scrollEvent -> {
            if (scrollEvent.isShortcutDown()) {
                if (scrollEvent.getTextDeltaY() > 0.0) {
                    this.incrementZoom();
                } else {
                    this.decrementZoom();
                }
                scrollEvent.consume();
            }
        });
    }

    protected void layoutChildren() {
        super.layoutChildren();
        Pos pos = Pos.TOP_LEFT;
        double d2 = this.getWidth();
        double d3 = this.getHeight();
        double d4 = this.getInsets().getTop();
        double d5 = this.getInsets().getRight();
        double d6 = this.getInsets().getLeft();
        double d7 = this.getInsets().getBottom();
        double d8 = (d2 - d6 - d5) / this.zoomFactor.get();
        double d9 = (d3 - d4 - d7) / this.zoomFactor.get();
        this.layoutInArea((Node)this.getChildren().get(0), d6, d4, d8, d9, 0.0, null, pos.getHpos(), pos.getVpos());
    }

    public boolean isRowHidden(int n2) {
        return ((BitSet)this.hiddenRowsProperty.get()).get(n2);
    }

    public BitSet getHiddenRows() {
        return (BitSet)this.hiddenRowsProperty.get();
    }

    public final ObjectProperty<BitSet> hiddenRowsProperty() {
        return this.hiddenRowsProperty;
    }

    public void setHiddenRows(BitSet bitSet) {
        BitSet bitSet2 = new BitSet(bitSet.size());
        bitSet2.or(bitSet);
        this.hiddenRowsProperty.setValue((Object)bitSet2);
        this.requestLayout();
    }

    public void setHiddenColumns(BitSet bitSet) {
        BitSet bitSet2 = new BitSet(bitSet.size());
        bitSet2.or(bitSet);
        this.hiddenColumnsProperty.setValue((Object)bitSet2);
        this.requestLayout();
    }

    public boolean isColumnHidden(int n2) {
        return ((BitSet)this.hiddenColumnsProperty.get()).get(n2);
    }

    public BitSet getHiddenColumns() {
        return (BitSet)this.hiddenColumnsProperty.get();
    }

    public final ObjectProperty<BitSet> hiddenColumnsProperty() {
        return this.hiddenColumnsProperty;
    }

    public int getFilteredRow() {
        return this.filteredRow == null ? -1 : this.filteredRow;
    }

    public void setFilteredRow(Integer n2) {
        this.filteredRow = n2 == null || n2 > this.getGrid().getRowCount() ? null : n2;
    }

    public void hideRow(int n2) {
        if (this.getHiddenRows().get(n2)) {
            return;
        }
        this.getHiddenRows().set(n2, true);
        BitSet bitSet = new BitSet(this.getHiddenRows().size());
        bitSet.or(this.getHiddenRows());
        this.setHiddenRows(bitSet);
    }

    public void hideColumn(SpreadsheetColumn spreadsheetColumn) {
        int n2 = this.getColumns().indexOf((Object)spreadsheetColumn);
        if (this.getHiddenColumns().get(n2)) {
            return;
        }
        this.getHiddenColumns().set(n2, true);
        BitSet bitSet = new BitSet(this.getHiddenColumns().size());
        bitSet.or(this.getHiddenColumns());
        this.setHiddenColumns(bitSet);
    }

    private void computeRowMap() {
        if (this.getHiddenRows().isEmpty()) {
            this.filteredList.setPredicate(null);
        } else {
            this.filteredList.setPredicate((Predicate)new Predicate<ObservableList<SpreadsheetCell>>(){

                @Override
                public boolean test(ObservableList<SpreadsheetCell> observableList) {
                    int n2 = SpreadsheetView.this.identityMap.get(observableList);
                    return !SpreadsheetView.this.getHiddenRows().get(n2) || n2 == SpreadsheetView.this.getFilteredRow();
                }
            });
        }
        int n2 = this.getGrid().getRowCount();
        this.rowMap = new HashMap(n2);
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!this.getHiddenRows().get(i2)) {
                this.rowMap.put(i2, n3++);
                continue;
            }
            this.rowMap.put(i2, n3);
        }
    }

    private void computeColumnMap() {
        int n2 = this.getGrid().getColumnCount();
        this.columnMap = new HashMap(n2);
        CellView.getValue(() -> {
            int n2 = this.getColumns().size();
            int n3 = this.getGrid().getColumnCount();
            int n4 = 0;
            for (int i2 = 0; i2 < n3; ++i2) {
                if (!this.getHiddenColumns().get(i2)) {
                    if (i2 < n2) {
                        ((SpreadsheetColumn)this.getColumns().get((int)i2)).column.setVisible(true);
                    }
                    this.columnMap.put(i2, n4++);
                    continue;
                }
                if (i2 < n2) {
                    ((SpreadsheetColumn)this.getColumns().get((int)i2)).column.setVisible(false);
                }
                this.columnMap.put(i2, n4);
            }
        });
    }

    public void showRow(int n2) {
        if (!this.getHiddenRows().get(n2)) {
            return;
        }
        this.getHiddenRows().set(n2, false);
        BitSet bitSet = new BitSet(this.getHiddenRows().size());
        bitSet.or(this.getHiddenRows());
        this.setHiddenRows(bitSet);
    }

    public void showColumn(SpreadsheetColumn spreadsheetColumn) {
        int n2 = this.getColumns().indexOf((Object)spreadsheetColumn);
        if (!this.getHiddenColumns().get(n2)) {
            return;
        }
        this.getHiddenColumns().set(n2, false);
        BitSet bitSet = new BitSet(this.getHiddenColumns().size());
        bitSet.or(this.getHiddenColumns());
        this.setHiddenColumns(bitSet);
    }

    public int getFilteredRow(int n2) {
        try {
            return this.rowMap.get(n2);
        }
        catch (NullPointerException nullPointerException) {
            return n2;
        }
    }

    public int getViewColumn(int n2) {
        try {
            return this.columnMap.get(n2);
        }
        catch (NullPointerException nullPointerException) {
            return n2;
        }
    }

    public int getModelColumn(int n2) {
        try {
            return this.cellsView.getColumns().indexOf((Object)this.cellsView.getVisibleLeafColumn(n2));
        }
        catch (NullPointerException nullPointerException) {
            return n2;
        }
    }

    public int getViewRow(int n2) {
        n2 = this.getFilteredRow(n2);
        if (this.getComparator() != null) {
            n2 = this.getViewIndex(n2);
        }
        return n2;
    }

    private int getViewIndex(int n2) {
        return this.sortedList.getViewIndex(n2);
    }

    public int getModelRow(int n2) {
        if (n2 < 0 || n2 >= this.sortedList.size()) {
            return n2;
        }
        try {
            return this.getFilteredSourceIndex(this.sortedList.getSourceIndex(n2));
        }
        catch (IndexOutOfBoundsException | NullPointerException runtimeException) {
            return n2;
        }
    }

    public int getFilteredSourceIndex(int n2) {
        if (n2 < 0 || n2 >= this.filteredList.size()) {
            return n2;
        }
        try {
            return this.filteredList.getSourceIndex(n2);
        }
        catch (IndexOutOfBoundsException | NullPointerException runtimeException) {
            return n2;
        }
    }

    public int getRowSpan(SpreadsheetCell spreadsheetCell, int n2) {
        int n3 = 0;
        do {
            ++n3;
        } while (++n2 < this.sortedList.size() && spreadsheetCell.getColumn() < this.getGrid().getColumnCount() && ((ObservableList)this.sortedList.get(n2)).get(spreadsheetCell.getColumn()) == spreadsheetCell);
        return n3;
    }

    public int getReverseRowSpan(SpreadsheetCell spreadsheetCell, int n2) {
        int n3 = 0;
        do {
            ++n3;
        } while (--n2 >= 0 && spreadsheetCell.getColumn() < this.getGrid().getColumnCount() && ((ObservableList)this.sortedList.get(n2)).get(spreadsheetCell.getColumn()) == spreadsheetCell);
        return n3;
    }

    public int getRowSpanFilter(SpreadsheetCell spreadsheetCell) {
        int n2 = spreadsheetCell.getRowSpan();
        for (int i2 = spreadsheetCell.getRow(); i2 < spreadsheetCell.getRow() + spreadsheetCell.getRowSpan(); ++i2) {
            n2 -= this.getHiddenRows().get(i2) ? 1 : 0;
        }
        return n2;
    }

    public ObservableList<ObservableList<SpreadsheetCell>> getItems() {
        return this.cellsView.getItems();
    }

    public int getColumnSpan(SpreadsheetCell spreadsheetCell) {
        int n2 = spreadsheetCell.getColumnSpan();
        for (int i2 = spreadsheetCell.getColumn(); i2 < spreadsheetCell.getColumn() + spreadsheetCell.getColumnSpan(); ++i2) {
            n2 -= this.getHiddenColumns().get(i2) ? 1 : 0;
        }
        return n2;
    }

    public final Double getZoomFactor() {
        return this.zoomFactor.get();
    }

    public final void setZoomFactor(Double d2) {
        this.zoomFactor.set(d2.doubleValue());
    }

    public final DoubleProperty zoomFactorProperty() {
        return this.zoomFactor;
    }

    public void incrementZoom() {
        double d2 = this.zoomFactor.getValue() + 0.1;
        d2 *= 10.0;
        d2 = Math.floor((float)d2);
        this.zoomFactor.setValue((Number)((d2 /= 10.0) > 2.0 ? 2.0 : d2));
    }

    public void decrementZoom() {
        double d2 = this.zoomFactor.getValue() - 0.1;
        d2 *= 10.0;
        d2 = Math.ceil((float)d2);
        this.zoomFactor.setValue((Number)((d2 /= 10.0) < 0.2 ? 0.2 : d2));
    }

    public void edit(int n2, SpreadsheetColumn spreadsheetColumn) {
        this.cellsView.edit(n2, spreadsheetColumn == null ? null : spreadsheetColumn.column);
    }

    public Comparator getComparator() {
        return this.sortedList == null ? null : this.sortedList.getComparator();
    }

    public ObjectProperty<Comparator<? super ObservableList<SpreadsheetCell>>> comparatorProperty() {
        return this.sortedList.comparatorProperty();
    }

    public void setComparator(Comparator<ObservableList<SpreadsheetCell>> comparator) {
        this.sortedList.setComparator(comparator);
        this.computeRowMap();
        this.requestLayout();
    }

    public final void setGrid(Grid grid) {
        Object object4;
        SpreadsheetColumn spreadsheetColumn2;
        Object object22;
        Serializable serializable2;
        if (grid == null) {
            return;
        }
        this.filteredList = new FilteredList(grid.getRows());
        this.sortedList = new SortedList(this.filteredList);
        this.gridProperty.set((Object)grid);
        this.setHiddenRows(new BitSet(this.filteredList.getSource().size()));
        this.setHiddenColumns(new BitSet(grid.getColumnCount()));
        this.initRowFix(grid);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (Serializable serializable2 : this.getFixedRows()) {
            if (!this.isRowFixable((Integer)serializable2)) continue;
            arrayList.add((Integer)serializable2);
        }
        this.getFixedRows().setAll(arrayList);
        ArrayList arrayList2 = new ArrayList();
        for (Object object22 : this.getFixedColumns()) {
            arrayList2.add(this.getColumns().indexOf(object22));
        }
        this.getFixedColumns().clear();
        serializable2 = new ArrayList<Double>();
        for (SpreadsheetColumn spreadsheetColumn2 : this.columns) {
            serializable2.add(spreadsheetColumn2.getWidth());
        }
        object22 = null;
        spreadsheetColumn2 = this.cellsView.getFocusModel().getFocusedCell();
        if (spreadsheetColumn2 != null && spreadsheetColumn2.getRow() != -1 && spreadsheetColumn2.getColumn() != -1) {
            object22 = new Pair((Object)spreadsheetColumn2.getRow(), (Object)spreadsheetColumn2.getColumn());
        }
        Object object3 = object22;
        if (grid.getRows() != null) {
            this.cellsView.setItems((ObservableList)this.sortedList);
            this.computeRowMap();
            int n2 = grid.getColumnCount();
            this.columns.clear();
            for (int i2 = 0; i2 < n2; ++i2) {
                object4 = new SpreadsheetColumn(this.getTableColumn(grid, i2), this, i2, grid);
                if (serializable2.size() > i2) {
                    ((SpreadsheetColumn)object4).setPrefWidth((Double)serializable2.get(i2));
                }
                this.columns.add(object4);
                if (!arrayList2.contains(i2) || !((SpreadsheetColumn)object4).isColumnFixable()) continue;
                ((SpreadsheetColumn)object4).setFixed(true);
            }
        }
        ArrayList<Pair> arrayList3 = new ArrayList<Pair>();
        for (Object object4 : this.getSelectionModel().getSelectedCells()) {
            arrayList3.add(new Pair((Object)object4.getRow(), (Object)object4.getColumn()));
        }
        Runnable runnable = () -> this.lambda$setGrid$4(grid, arrayList3, (Pair)object3);
        if (Platform.isFxApplicationThread()) {
            runnable.run();
        } else {
            try {
                object4 = new FutureTask<Object>(runnable, null);
                Platform.runLater((Runnable)object4);
                ((FutureTask)object4).get();
            }
            catch (InterruptedException | ExecutionException exception) {
                Logger.getLogger(SpreadsheetView.class.getName()).log(Level.SEVERE, null, exception);
            }
        }
    }

    public TablePosition<ObservableList<SpreadsheetCell>, ?> getEditingCell() {
        return this.cellsView.getEditingCell();
    }

    public ReadOnlyObjectProperty<TablePosition<ObservableList<SpreadsheetCell>, ?>> editingCellProperty() {
        return this.cellsView.editingCellProperty();
    }

    public final ObservableList<SpreadsheetColumn> getColumns() {
        return this.columns;
    }

    public final Grid getGrid() {
        return (Grid)this.gridProperty.get();
    }

    public final ReadOnlyObjectProperty<Grid> gridProperty() {
        return this.gridProperty;
    }

    public ObservableList<Integer> getFixedRows() {
        return this.fixedRows;
    }

    public boolean isRowFixable(int n2) {
        return n2 >= 0 && n2 < this.rowFix.size() && this.isFixingRowsAllowed() ? this.rowFix.get(n2) : false;
    }

    public boolean areRowsFixable(List<? extends Integer> list) {
        if (list == null || list.isEmpty() || !this.isFixingRowsAllowed()) {
            return false;
        }
        Grid grid = this.getGrid();
        int n2 = grid.getRowCount();
        ObservableList<ObservableList<SpreadsheetCell>> observableList = grid.getRows();
        for (Integer n3 : list) {
            if (n3 == null || n3 < 0 || n3 >= n2) {
                return false;
            }
            if (this.isRowFixable(n3)) continue;
            int n4 = 1;
            List list2 = (List)observableList.get(n3.intValue());
            for (SpreadsheetCell spreadsheetCell : list2) {
                if (!list.contains(spreadsheetCell.getRow())) {
                    return false;
                }
                if (this.getRowSpan(spreadsheetCell, n3) <= n4 || spreadsheetCell.getRow() != n3.intValue()) continue;
                n4 = spreadsheetCell.getRowSpan();
            }
            int n5 = n3 + n4 - 1;
            for (int i2 = n3 + 1; i2 <= n5; ++i2) {
                if (list.contains(i2)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isFixingRowsAllowed() {
        return this.fixingRowsAllowedProperty.get();
    }

    public void setFixingRowsAllowed(boolean bl2) {
        this.fixingRowsAllowedProperty.set(bl2);
    }

    public ReadOnlyBooleanProperty fixingRowsAllowedProperty() {
        return this.fixingRowsAllowedProperty;
    }

    public ObservableList<SpreadsheetColumn> getFixedColumns() {
        return this.fixedColumns;
    }

    public boolean isColumnFixable(int n2) {
        return n2 >= 0 && n2 < this.getColumns().size() && this.isFixingColumnsAllowed() ? ((SpreadsheetColumn)this.getColumns().get(n2)).isColumnFixable() : false;
    }

    public boolean areSpreadsheetColumnsFixable(List<? extends SpreadsheetColumn> list) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (SpreadsheetColumn spreadsheetColumn : list) {
            if (spreadsheetColumn == null) continue;
            arrayList.add(this.columns.indexOf((Object)spreadsheetColumn));
        }
        return this.areColumnsFixable(arrayList);
    }

    public boolean areColumnsFixable(List<? extends Integer> list) {
        if (list == null || list.isEmpty() || !this.isFixingRowsAllowed()) {
            return false;
        }
        Grid grid = this.getGrid();
        int n2 = grid.getColumnCount();
        ObservableList<ObservableList<SpreadsheetCell>> observableList = grid.getRows();
        for (Integer n3 : list) {
            if (n3 == null || n3 < 0 || n3 >= n2) {
                return false;
            }
            if (this.isColumnFixable(n3)) continue;
            int n4 = 1;
            for (List list2 : observableList) {
                SpreadsheetCell spreadsheetCell = (SpreadsheetCell)list2.get(n3);
                if (!list.contains(spreadsheetCell.getColumn())) {
                    return false;
                }
                if (spreadsheetCell.getColumnSpan() <= n4 || spreadsheetCell.getColumn() != n3.intValue()) continue;
                n4 = spreadsheetCell.getColumnSpan();
            }
            int n5 = n3 + n4 - 1;
            for (int i2 = n3 + 1; i2 <= n5; ++i2) {
                if (list.contains(i2)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isFixingColumnsAllowed() {
        return this.fixingColumnsAllowedProperty.get();
    }

    public void setFixingColumnsAllowed(boolean bl2) {
        this.fixingColumnsAllowedProperty.set(bl2);
    }

    public ReadOnlyBooleanProperty fixingColumnsAllowedProperty() {
        return this.fixingColumnsAllowedProperty;
    }

    public final void setShowColumnHeader(boolean bl2) {
        this.showColumnHeader.setValue(Boolean.valueOf(bl2));
    }

    public final boolean isShowColumnHeader() {
        return this.showColumnHeader.get();
    }

    public final BooleanProperty showColumnHeaderProperty() {
        return this.showColumnHeader;
    }

    public final void setShowRowHeader(boolean bl2) {
        this.showRowHeader.setValue(Boolean.valueOf(bl2));
    }

    public final boolean isShowRowHeader() {
        return this.showRowHeader.get();
    }

    public final BooleanProperty showRowHeaderProperty() {
        return this.showRowHeader;
    }

    public final DoubleProperty rowHeaderWidthProperty() {
        return this.rowHeaderWidth;
    }

    public final void setRowHeaderWidth(double d2) {
        this.rowHeaderWidth.setValue((Number)d2);
    }

    public final double getRowHeaderWidth() {
        return this.rowHeaderWidth.get();
    }

    public ObservableMap<Integer, Picker> getRowPickers() {
        return this.rowPickers;
    }

    public ObservableMap<Integer, Picker> getColumnPickers() {
        return this.columnPickers;
    }

    public void resizeRowsToFitContent() {
        if (this.getCellsViewSkin() != null) {
            this.getCellsViewSkin().resizeRowsToFitContent();
        }
    }

    public void resizeRowsToMaximum() {
        if (this.getCellsViewSkin() != null) {
            this.getCellsViewSkin().resizeRowsToMaximum();
        }
    }

    public void resizeRowsToDefault() {
        if (this.getCellsViewSkin() != null) {
            this.getCellsViewSkin().resizeRowsToDefault();
        }
    }

    public double getRowHeight(int n2) {
        if (this.getCellsViewSkin() == null) {
            return this.getGrid().getRowHeight(n2);
        }
        return this.getCellsViewSkin().getRowHeight(n2);
    }

    public SpreadsheetViewSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void scrollToRow(int n2) {
        this.cellsView.scrollTo(n2);
    }

    public void setVBarValue(double d2) {
        if (this.getCellsViewSkin() == null) {
            Platform.runLater(() -> this.setVBarValue(d2));
            return;
        }
        this.getCellsViewSkin().getVBar().setValue(d2);
    }

    public void setHBarValue(double d2) {
        this.setHBarValue(d2, 0);
    }

    private void setHBarValue(double d2, int n2) {
        if (n2 > 10) {
            return;
        }
        if (this.getCellsViewSkin() == null) {
            int n3 = ++n2;
            Platform.runLater(() -> this.setHBarValue(d2, n3));
            return;
        }
        this.getCellsViewSkin().setHbarValue(d2);
    }

    public double getVBarValue() {
        if (this.getCellsViewSkin() != null && this.getCellsViewSkin().getVBar() != null) {
            return this.getCellsViewSkin().getVBar().getValue();
        }
        return 0.0;
    }

    public double getHBarValue() {
        if (this.getCellsViewSkin() != null && this.getCellsViewSkin().getHBar() != null) {
            return this.getCellsViewSkin().getHBar().getValue();
        }
        return 0.0;
    }

    public void scrollToColumn(SpreadsheetColumn spreadsheetColumn) {
        this.cellsView.scrollToColumn(spreadsheetColumn.column);
    }

    public void scrollToColumnIndex(int n2) {
        this.cellsView.scrollToColumnIndex(n2);
    }

    public final Optional<SpreadsheetCellEditor> getEditor(SpreadsheetCellType<?> spreadsheetCellType) {
        if (spreadsheetCellType == null) {
            return Optional.empty();
        }
        SpreadsheetCellEditor spreadsheetCellEditor = this.editors.get(spreadsheetCellType);
        if (spreadsheetCellEditor == null) {
            spreadsheetCellEditor = spreadsheetCellType.createEditor(this);
            if (spreadsheetCellEditor == null) {
                return Optional.empty();
            }
            this.editors.put(spreadsheetCellType, spreadsheetCellEditor);
        }
        return Optional.of(spreadsheetCellEditor);
    }

    public final void setEditable(boolean bl2) {
        this.cellsView.setEditable(bl2);
    }

    public final boolean isEditable() {
        return this.cellsView.isEditable();
    }

    public final BooleanProperty editableProperty() {
        return this.cellsView.editableProperty();
    }

    public final ObjectProperty<Node> placeholderProperty() {
        return this.cellsView.placeholderProperty();
    }

    public final void setPlaceholder(Node node) {
        this.cellsView.setPlaceholder(node);
    }

    public final Node getPlaceholder() {
        return this.cellsView.getPlaceholder();
    }

    public void copyClipboard() {
        this.checkFormat();
        ArrayList<ClipboardCell> arrayList = new ArrayList<ClipboardCell>();
        ObservableList<TablePosition> observableList = this.getSelectionModel().getSelectedCells();
        HashSet<SpreadsheetCell> hashSet = new HashSet<SpreadsheetCell>();
        for (TablePosition tablePosition : observableList) {
            SpreadsheetCell spreadsheetCell = (SpreadsheetCell)((ObservableList)this.getGrid().getRows().get(this.getModelRow(tablePosition.getRow()))).get(this.getModelColumn(tablePosition.getColumn()));
            if (hashSet.contains(spreadsheetCell)) continue;
            hashSet.add(spreadsheetCell);
            for (int i2 = 0; i2 < this.getRowSpan(spreadsheetCell, tablePosition.getRow()); ++i2) {
                for (int i3 = 0; i3 < this.getColumnSpan(spreadsheetCell); ++i3) {
                    arrayList.add(new ClipboardCell(tablePosition.getRow() + i2, tablePosition.getColumn() + i3, spreadsheetCell));
                }
            }
        }
        Iterator iterator = new ClipboardContent();
        iterator.put(this.fmt, arrayList);
        Clipboard.getSystemClipboard().setContent((Map)((Object)iterator));
    }

    private void pasteOneValue(ClipboardCell clipboardCell) {
        for (TablePosition tablePosition : this.getSelectionModel().getSelectedCells()) {
            this.tryPasteCell(this.getModelRow(tablePosition.getRow()), this.getModelColumn(tablePosition.getColumn()), clipboardCell);
        }
    }

    private void tryPasteCell(int n2, int n3, ClipboardCell clipboardCell) {
        SpanType spanType = this.getSpanType(n2, n3);
        if (spanType == SpanType.NORMAL_CELL || spanType == SpanType.ROW_VISIBLE) {
            SpreadsheetCell spreadsheetCell = (SpreadsheetCell)((ObservableList)this.getGrid().getRows().get(n2)).get(n3);
            Object object = clipboardCell.getHtmlVersion() == null ? clipboardCell.getValue() : clipboardCell.getHtmlVersion();
            object = spreadsheetCell.isCellGraphic() ? object : clipboardCell.getValue();
            boolean bl2 = spreadsheetCell.getCellType().match(object, spreadsheetCell.getOptionsForEditor());
            if (bl2) {
                this.getGrid().setCellValue(spreadsheetCell.getRow(), spreadsheetCell.getColumn(), spreadsheetCell.getCellType().convertValue(object));
            }
        }
    }

    private void pasteMixedValues(ArrayList<ClipboardCell> arrayList) {
        block8: {
            RectangleSelection.SelectionRange selectionRange = new RectangleSelection.SelectionRange();
            selectionRange.fillClipboardRange(arrayList);
            if (selectionRange.getRange() == null) break block8;
            RectangleSelection.SelectionRange selectionRange2 = new RectangleSelection.SelectionRange();
            selectionRange2.fill((List<TablePosition>)this.cellsView.getSelectionModel().getSelectedCells());
            if (selectionRange2.getRange() != null) {
                RectangleSelection.GridRange gridRange = selectionRange.getRange();
                RectangleSelection.GridRange gridRange2 = selectionRange2.getRange();
                int n2 = gridRange.getBottom() - gridRange.getTop() + 1;
                int n3 = gridRange2.getBottom() - gridRange2.getTop() + 1;
                int n4 = gridRange.getRight() - gridRange.getLeft() + 1;
                int n5 = gridRange2.getRight() - gridRange2.getLeft() + 1;
                int n6 = gridRange2.getTop() - gridRange.getTop();
                int n7 = gridRange2.getLeft() - gridRange.getLeft();
                if ((n2 == n3 || n3 == 1) && n5 % n4 == 0) {
                    for (ClipboardCell clipboardCell : arrayList) {
                        int n8 = this.getModelRow(clipboardCell.getRow() + n6);
                        int n9 = clipboardCell.getColumn() + n7;
                        do {
                            int n10 = this.getModelColumn(n9);
                            if (n8 >= this.getGrid().getRowCount() || n10 >= this.getGrid().getColumnCount() || n8 < 0 || n9 < 0) continue;
                            this.tryPasteCell(n8, n10, clipboardCell);
                        } while ((n9 += n4) <= gridRange2.getRight());
                    }
                } else if ((n4 == n5 || n5 == 1) && n3 % n2 == 0) {
                    for (ClipboardCell clipboardCell : arrayList) {
                        int n11 = clipboardCell.getRow() + n6;
                        int n12 = this.getModelColumn(clipboardCell.getColumn() + n7);
                        do {
                            int n13;
                            if ((n13 = this.getModelRow(n11)) >= this.getGrid().getRowCount() || n12 >= this.getGrid().getColumnCount() || n11 < 0 || n12 < 0) continue;
                            this.tryPasteCell(n13, n12, clipboardCell);
                        } while ((n11 += n2) <= gridRange2.getBottom());
                    }
                }
            }
        }
    }

    private void pasteSeveralValues(ArrayList<ClipboardCell> arrayList) {
        int n2;
        int n3;
        int n4 = this.getGrid().getRowCount();
        int n5 = this.getGrid().getColumnCount();
        int n6 = 0;
        int n7 = 0;
        for (ClipboardCell clipboardCell : arrayList) {
            n3 = clipboardCell.getColumn();
            n2 = clipboardCell.getRow();
            if (n3 < n5) {
                n5 = n3;
            }
            if (n3 > n7) {
                n7 = n3;
            }
            if (n2 < n4) {
                n4 = n2;
            }
            if (n2 <= n6) continue;
            n6 = n2;
        }
        TablePosition tablePosition = this.cellsView.getFocusModel().getFocusedCell();
        int n8 = tablePosition.getRow() - n4;
        n3 = tablePosition.getColumn() - n5;
        n2 = this.getGrid().getRowCount();
        int n9 = this.getGrid().getColumnCount();
        for (ClipboardCell clipboardCell : arrayList) {
            int n10 = this.getModelRow(clipboardCell.getRow() + n8);
            int n11 = this.getModelColumn(clipboardCell.getColumn() + n3);
            if (n10 >= n2 || n11 >= n9 || n10 < 0 || n11 < 0) continue;
            this.tryPasteCell(n10, n11, clipboardCell);
        }
    }

    public void pasteClipboard() {
        ObservableList observableList = this.cellsView.getSelectionModel().getSelectedCells();
        if (!this.isEditable() || observableList.isEmpty()) {
            return;
        }
        this.checkFormat();
        Clipboard clipboard = Clipboard.getSystemClipboard();
        if (clipboard.getContent(this.fmt) != null) {
            ArrayList arrayList = (ArrayList)clipboard.getContent(this.fmt);
            if (arrayList.size() == 1) {
                this.pasteOneValue((ClipboardCell)arrayList.get(0));
            } else if (observableList.size() > 1) {
                this.pasteMixedValues(arrayList);
            } else {
                this.pasteSeveralValues(arrayList);
            }
        } else if (clipboard.hasString()) {
            // empty if block
        }
    }

    public ContextMenu getSpreadsheetViewContextMenu() {
        ContextMenu contextMenu = new ContextMenu();
        MenuItem menuItem = new MenuItem(Localization.localize(Localization.asKey("spreadsheet.view.menu.copy")));
        menuItem.setGraphic((Node)new ImageView(new Image(SpreadsheetView.class.getResourceAsStream("copySpreadsheetView.png"))));
        menuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        menuItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                SpreadsheetView.this.copyClipboard();
            }
        });
        MenuItem menuItem2 = new MenuItem(Localization.localize(Localization.asKey("spreadsheet.view.menu.paste")));
        menuItem2.setGraphic((Node)new ImageView(new Image(SpreadsheetView.class.getResourceAsStream("pasteSpreadsheetView.png"))));
        menuItem2.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.V, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        menuItem2.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                SpreadsheetView.this.pasteClipboard();
            }
        });
        Menu menu = new Menu(Localization.localize(Localization.asKey("spreadsheet.view.menu.comment")));
        menu.setGraphic((Node)new ImageView(new Image(SpreadsheetView.class.getResourceAsStream("comment.png"))));
        MenuItem menuItem3 = new MenuItem(Localization.localize(Localization.asKey("spreadsheet.view.menu.comment.top-left")));
        menuItem3.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                TablePosition tablePosition = SpreadsheetView.this.cellsView.getFocusModel().getFocusedCell();
                SpreadsheetCell spreadsheetCell = (SpreadsheetCell)((ObservableList)SpreadsheetView.this.getGrid().getRows().get(SpreadsheetView.this.getModelRow(tablePosition.getRow()))).get(SpreadsheetView.this.getModelColumn(tablePosition.getColumn()));
                spreadsheetCell.activateCorner(SpreadsheetCell.CornerPosition.TOP_LEFT);
            }
        });
        MenuItem menuItem4 = new MenuItem(Localization.localize(Localization.asKey("spreadsheet.view.menu.comment.top-right")));
        menuItem4.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                TablePosition tablePosition = SpreadsheetView.this.cellsView.getFocusModel().getFocusedCell();
                SpreadsheetCell spreadsheetCell = (SpreadsheetCell)((ObservableList)SpreadsheetView.this.getGrid().getRows().get(SpreadsheetView.this.getModelRow(tablePosition.getRow()))).get(SpreadsheetView.this.getModelColumn(tablePosition.getColumn()));
                spreadsheetCell.activateCorner(SpreadsheetCell.CornerPosition.TOP_RIGHT);
            }
        });
        MenuItem menuItem5 = new MenuItem(Localization.localize(Localization.asKey("spreadsheet.view.menu.comment.bottom-right")));
        menuItem5.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                TablePosition tablePosition = SpreadsheetView.this.cellsView.getFocusModel().getFocusedCell();
                SpreadsheetCell spreadsheetCell = (SpreadsheetCell)((ObservableList)SpreadsheetView.this.getGrid().getRows().get(SpreadsheetView.this.getModelRow(tablePosition.getRow()))).get(SpreadsheetView.this.getModelColumn(tablePosition.getColumn()));
                spreadsheetCell.activateCorner(SpreadsheetCell.CornerPosition.BOTTOM_RIGHT);
            }
        });
        MenuItem menuItem6 = new MenuItem(Localization.localize(Localization.asKey("spreadsheet.view.menu.comment.bottom-left")));
        menuItem6.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                TablePosition tablePosition = SpreadsheetView.this.cellsView.getFocusModel().getFocusedCell();
                SpreadsheetCell spreadsheetCell = (SpreadsheetCell)((ObservableList)SpreadsheetView.this.getGrid().getRows().get(SpreadsheetView.this.getModelRow(tablePosition.getRow()))).get(SpreadsheetView.this.getModelColumn(tablePosition.getColumn()));
                spreadsheetCell.activateCorner(SpreadsheetCell.CornerPosition.BOTTOM_LEFT);
            }
        });
        menu.getItems().addAll((Object[])new MenuItem[]{menuItem3, menuItem4, menuItem5, menuItem6});
        contextMenu.getItems().addAll((Object[])new MenuItem[]{menuItem, menuItem2, menu});
        return contextMenu;
    }

    public void deleteSelectedCells() {
        for (TablePosition tablePosition : this.getSelectionModel().getSelectedCells()) {
            this.getGrid().setCellValue(this.getModelRow(tablePosition.getRow()), this.getModelColumn(tablePosition.getColumn()), null);
        }
    }

    public SpanType getSpanType(int n2, int n3) {
        boolean bl2;
        boolean bl3;
        if (this.getGrid() == null) {
            return SpanType.NORMAL_CELL;
        }
        if (n2 < 0 || n3 < 0 || n2 >= this.getItems().size() || n3 >= this.getGrid().getColumnCount()) {
            return SpanType.NORMAL_CELL;
        }
        SpreadsheetCell spreadsheetCell = (SpreadsheetCell)((ObservableList)this.getCellsView().getItems().get(n2)).get(n3);
        int n4 = this.getHiddenColumns().nextClearBit(spreadsheetCell.getColumn());
        int n5 = this.getRowSpanFilter(spreadsheetCell);
        if (n4 == n3 && n5 == 1) {
            return SpanType.NORMAL_CELL;
        }
        int n6 = this.getColumnSpan(spreadsheetCell);
        GridViewSkin gridViewSkin = this.getCellsViewSkin();
        boolean bl4 = bl3 = gridViewSkin == null ? true : gridViewSkin.containsRow(n2 - 1);
        boolean bl5 = n2 > 0 ? ((ObservableList)this.getCellsView().getItems().get(n2 - 1)).get(n3) == spreadsheetCell : (bl2 = false);
        if (bl3 && n6 > 1 && n4 != n3 && n5 > 1 && bl2) {
            return SpanType.BOTH_INVISIBLE;
        }
        if (n5 > 1 && n4 == n3) {
            if (!bl2 || !bl3) {
                return SpanType.ROW_VISIBLE;
            }
            return SpanType.ROW_SPAN_INVISIBLE;
        }
        if (!(n6 <= 1 || bl2 && bl3)) {
            if (n4 == n3) {
                return SpanType.NORMAL_CELL;
            }
            return SpanType.COLUMN_SPAN_INVISIBLE;
        }
        return SpanType.NORMAL_CELL;
    }

    private TableColumn<ObservableList<SpreadsheetCell>, SpreadsheetCell> getTableColumn(Grid grid, int n2) {
        TableColumn tableColumn2;
        String string;
        String string2 = string = grid.getColumnHeaders().size() > n2 ? (String)grid.getColumnHeaders().get(n2) : Utils.getExcelLetterFromNumber(n2);
        if (n2 < this.cellsView.getColumns().size()) {
            tableColumn2 = (TableColumn)this.cellsView.getColumns().get(n2);
            tableColumn2.setText(string);
        } else {
            tableColumn2 = new TableColumn(string);
            tableColumn2.setEditable(true);
            tableColumn2.setSortable(false);
            tableColumn2.setReorderable(false);
            tableColumn2.setCellValueFactory(cellDataFeatures -> {
                if (n2 >= ((ObservableList)cellDataFeatures.getValue()).size()) {
                    return null;
                }
                return new ReadOnlyObjectWrapper((Object)((SpreadsheetCell)((ObservableList)cellDataFeatures.getValue()).get(n2)));
            });
            tableColumn2.setCellFactory(tableColumn -> new CellView(this.handle));
        }
        return tableColumn2;
    }

    private static Grid getSampleGrid() {
        GridBase gridBase = new GridBase(100, 15);
        ObservableList observableList = FXCollections.observableArrayList();
        for (int i2 = 0; i2 < gridBase.getRowCount(); ++i2) {
            ObservableList observableList2 = FXCollections.observableArrayList();
            for (int i3 = 0; i3 < gridBase.getColumnCount(); ++i3) {
                observableList2.add((Object)SpreadsheetCellType.STRING.createCell(i2, i3, 1, 1, "toto"));
            }
            observableList.add((Object)observableList2);
        }
        gridBase.setRows((Collection<ObservableList<SpreadsheetCell>>)observableList);
        return gridBase;
    }

    private void initRowFix(Grid grid) {
        ObservableList<ObservableList<SpreadsheetCell>> observableList = grid.getRows();
        int n2 = observableList.size();
        this.rowFix = new BitSet(n2);
        this.identityMap = new IdentityHashMap(n2);
        block0: for (int i2 = 0; i2 < n2; ++i2) {
            ObservableList observableList2 = (ObservableList)observableList.get(i2);
            this.identityMap.put((ObservableList<SpreadsheetCell>)observableList2, i2);
            for (SpreadsheetCell spreadsheetCell : observableList2) {
                if (this.getRowSpanFilter(spreadsheetCell) <= 1) continue;
                continue block0;
            }
            this.rowFix.set(i2);
        }
    }

    private void verifyGrid(Grid grid) {
        this.verifyColumnSpan(grid);
    }

    private void verifyColumnSpan(Grid grid) {
        for (int i2 = 0; i2 < grid.getRows().size(); ++i2) {
            ObservableList observableList = (ObservableList)grid.getRows().get(i2);
            int n2 = 0;
            for (int i3 = 0; i3 < observableList.size(); ++i3) {
                if (((SpreadsheetCell)observableList.get(i3)).getColumnSpan() == 1) {
                    ++n2;
                    continue;
                }
                if (((SpreadsheetCell)observableList.get(i3)).getColumnSpan() > 1) {
                    ++n2;
                    SpreadsheetCell spreadsheetCell = (SpreadsheetCell)observableList.get(i3);
                    for (int i4 = i3 + 1; i4 < spreadsheetCell.getColumn() + spreadsheetCell.getColumnSpan(); ++i4) {
                        if (!((SpreadsheetCell)observableList.get(i4)).equals(spreadsheetCell)) {
                            throw new IllegalStateException("\n At row " + i2 + " and column " + i3 + ": this cell is in the range of a columnSpan but is different. \nEvery cell in a range of a ColumnSpan must be of the same instance.");
                        }
                        ++n2;
                        ++i3;
                    }
                    continue;
                }
                throw new IllegalStateException("\n At row " + i2 + " and column " + i3 + ": this cell has a negative columnSpan");
            }
            if (n2 == grid.getColumnCount()) continue;
            throw new IllegalStateException("The row" + i2 + " has a number of cells different of the columnCount declared in the grid.");
        }
    }

    private void checkFormat() {
        this.fmt = DataFormat.lookupMimeType((String)"SpreadsheetView");
        if (this.fmt == null) {
            this.fmt = new DataFormat(new String[]{"SpreadsheetView"});
        }
    }

    private String computeReason(List<? extends Integer> list) {
        Object object = "\n A row cannot be frozen. \n";
        for (Integer n2 : list) {
            if (this.isRowFixable(n2)) continue;
            int n3 = 1;
            List list2 = (List)this.getGrid().getRows().get(n2.intValue());
            for (SpreadsheetCell spreadsheetCell : list2) {
                if (!list.contains(spreadsheetCell.getRow())) {
                    object = (String)object + "The row " + n2 + " is inside a row span and the starting row " + spreadsheetCell.getRow() + " is not frozen.\n";
                }
                if (spreadsheetCell.getRowSpan() <= n3 || spreadsheetCell.getRow() != n2.intValue()) continue;
                n3 = spreadsheetCell.getRowSpan();
            }
            int n4 = n2 + n3 - 1;
            for (int i2 = n2 + 1; i2 < n4; ++i2) {
                if (list.contains(i2)) continue;
                object = (String)object + "One cell on the row " + n2 + " has a row span of " + n3 + ". But the row " + i2 + " contained within that span is not frozen.\n";
            }
        }
        return object;
    }

    private boolean isEditionKey(KeyEvent keyEvent) {
        return !keyEvent.isShortcutDown() && !keyEvent.getCode().isNavigationKey() && !keyEvent.getCode().isFunctionKey() && !keyEvent.getCode().isModifierKey() && !keyEvent.getCode().isMediaKey() && keyEvent.getCode() != KeyCode.ESCAPE;
    }

    private /* synthetic */ void lambda$setGrid$4(Grid grid, List list, Pair pair) {
        if (this.cellsView.getColumns().size() > grid.getColumnCount()) {
            this.cellsView.getColumns().remove(grid.getColumnCount(), this.cellsView.getColumns().size());
        } else if (this.cellsView.getColumns().size() < grid.getColumnCount()) {
            for (int i2 = this.cellsView.getColumns().size(); i2 < grid.getColumnCount(); ++i2) {
                this.cellsView.getColumns().add(((SpreadsheetColumn)this.columns.get((int)i2)).column);
            }
        }
        ((TableViewSpanSelectionModel)this.cellsView.getSelectionModel()).verifySelectedCells(list);
        if (pair != null && (Integer)pair.getKey() < this.getGrid().getRowCount() && (Integer)pair.getValue() < this.getGrid().getColumnCount()) {
            this.cellsView.getFocusModel().focus(((Integer)pair.getKey()).intValue(), (TableColumn)this.cellsView.getColumns().get(((Integer)pair.getValue()).intValue()));
        }
    }

    public static class ColumnWidthEvent
    extends Event {
        public static final EventType<ColumnWidthEvent> COLUMN_WIDTH_CHANGE = new EventType(Event.ANY, "ColumnWidthChange" + UUID.randomUUID().toString());
        private final int column;
        private final double width;

        public ColumnWidthEvent(int n2, double d2) {
            super(COLUMN_WIDTH_CHANGE);
            this.column = n2;
            this.width = d2;
        }

        public int getColumn() {
            return this.column;
        }

        public double getWidth() {
            return this.width;
        }
    }

    public static class RowHeightEvent
    extends Event {
        public static final EventType<RowHeightEvent> ROW_HEIGHT_CHANGE = new EventType(Event.ANY, "RowHeightChange" + UUID.randomUUID().toString());
        private final int modelRow;
        private final double height;

        public RowHeightEvent(int n2, double d2) {
            super(ROW_HEIGHT_CHANGE);
            this.modelRow = n2;
            this.height = d2;
        }

        public int getRow() {
            return this.modelRow;
        }

        public double getHeight() {
            return this.height;
        }
    }

    public static enum SpanType {
        NORMAL_CELL,
        COLUMN_SPAN_INVISIBLE,
        ROW_SPAN_INVISIBLE,
        ROW_VISIBLE,
        BOTH_INVISIBLE;

    }
}

