/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.spreadsheet;

import com.sun.javafx.event.EventHandlerManager;
import impl.org.controlsfx.spreadsheet.RectangleSelection;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventDispatchChain;
import javafx.event.EventDispatcher;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.util.Callback;
import org.controlsfx.control.spreadsheet.Grid;
import org.controlsfx.control.spreadsheet.GridChange;
import org.controlsfx.control.spreadsheet.SpreadsheetCell;

public class GridBase
implements Grid,
EventTarget {
    private ObservableList<ObservableList<SpreadsheetCell>> rows;
    private int rowCount;
    private int columnCount;
    private Callback<Integer, Double> rowHeightFactory;
    private final BooleanProperty locked;
    private final EventHandlerManager eventHandlerManager = new EventHandlerManager((Object)this);
    private final ObservableList<String> rowsHeader;
    private final ObservableList<String> columnsHeader;
    private BitSet resizableRow;
    private final TreeSet<Long> displaySelectionCells = new TreeSet();
    private final TreeSet<Long> noDisplaySelectionCells = new TreeSet();
    private final BooleanProperty displaySelection = new SimpleBooleanProperty(true);

    public GridBase(int n2, int n3) {
        this.rowCount = n2;
        this.columnCount = n3;
        this.rowsHeader = FXCollections.observableArrayList();
        this.columnsHeader = FXCollections.observableArrayList();
        this.locked = new SimpleBooleanProperty(false);
        this.rowHeightFactory = new MapBasedRowHeightFactory(new HashMap<Integer, Double>());
        this.rows = FXCollections.observableArrayList();
        this.rows.addListener(observable -> this.setRowCount(this.rows.size()));
        this.resizableRow = new BitSet(n2);
        this.resizableRow.set(0, n2, true);
    }

    @Override
    public ObservableList<ObservableList<SpreadsheetCell>> getRows() {
        return this.rows;
    }

    @Override
    public void setCellValue(int n2, int n3, Object object) {
        if (n2 < this.getRowCount() && n3 < this.columnCount && !this.isLocked()) {
            SpreadsheetCell spreadsheetCell = (SpreadsheetCell)((ObservableList)this.getRows().get(n2)).get(n3);
            Object object2 = spreadsheetCell.getItem();
            Object t2 = spreadsheetCell.getCellType().convertValue(object);
            spreadsheetCell.setItem(t2);
            if (!Objects.equals(object2, spreadsheetCell.getItem())) {
                GridChange gridChange = new GridChange(spreadsheetCell.getRow(), spreadsheetCell.getColumn(), object2, t2);
                Event.fireEvent((EventTarget)this, (Event)gridChange);
            }
        }
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public double getRowHeight(int n2) {
        return (Double)this.rowHeightFactory.call((Object)n2);
    }

    public void setRowHeightCallback(Callback<Integer, Double> callback) {
        this.rowHeightFactory = callback;
    }

    @Override
    public ObservableList<String> getRowHeaders() {
        return this.rowsHeader;
    }

    @Override
    public ObservableList<String> getColumnHeaders() {
        return this.columnsHeader;
    }

    public BooleanProperty lockedProperty() {
        return this.locked;
    }

    public boolean isLocked() {
        return this.locked.get();
    }

    public void setLocked(Boolean bl2) {
        this.locked.setValue(bl2);
    }

    @Override
    public void spanRow(int n2, int n3, int n4) {
        if (n2 <= 0 || n2 > this.getRowCount() || n3 >= this.getRowCount() || n4 >= this.columnCount) {
            return;
        }
        SpreadsheetCell spreadsheetCell = (SpreadsheetCell)((ObservableList)this.rows.get(n3)).get(n4);
        int n5 = spreadsheetCell.getColumnSpan();
        int n6 = n2;
        spreadsheetCell.setRowSpan(n6);
        for (int i2 = n3; i2 < n3 + n6 && i2 < this.getRowCount(); ++i2) {
            for (int i3 = n4; i3 < n4 + n5 && i3 < this.columnCount; ++i3) {
                if (i2 == n3 && i3 == n4) continue;
                ((ObservableList)this.rows.get(i2)).set(i3, (Object)spreadsheetCell);
            }
        }
    }

    @Override
    public void spanColumn(int n2, int n3, int n4) {
        if (n2 <= 0 || n2 > this.columnCount || n3 >= this.getRowCount() || n4 >= this.columnCount) {
            return;
        }
        SpreadsheetCell spreadsheetCell = (SpreadsheetCell)((ObservableList)this.rows.get(n3)).get(n4);
        int n5 = n2;
        int n6 = spreadsheetCell.getRowSpan();
        spreadsheetCell.setColumnSpan(n5);
        for (int i2 = n3; i2 < n3 + n6 && i2 < this.getRowCount(); ++i2) {
            for (int i3 = n4; i3 < n4 + n5 && i3 < this.columnCount; ++i3) {
                if (i2 == n3 && i3 == n4) continue;
                ((ObservableList)this.rows.get(i2)).set(i3, (Object)spreadsheetCell);
            }
        }
    }

    @Override
    public void setRows(Collection<ObservableList<SpreadsheetCell>> collection) {
        this.rows.clear();
        this.rows.addAll(collection);
        this.setRowCount(collection.size());
        this.setColumnCount(this.rowCount == 0 ? 0 : ((ObservableList)this.rows.get(0)).size());
    }

    public void setResizableRows(BitSet bitSet) {
        this.resizableRow = bitSet;
    }

    @Override
    public boolean isRowResizable(int n2) {
        return this.resizableRow.get(n2);
    }

    @Override
    public boolean isDisplaySelection() {
        return this.displaySelection.get();
    }

    @Override
    public void setDisplaySelection(boolean bl2) {
        this.displaySelection.setValue(Boolean.valueOf(bl2));
    }

    @Override
    public BooleanProperty displaySelectionProperty() {
        return this.displaySelection;
    }

    @Override
    public void setCellDisplaySelection(int n2, int n3, boolean bl2) {
        Long l2 = RectangleSelection.SelectionRange.key(n2, n3);
        if (bl2) {
            this.displaySelectionCells.add(l2);
            this.noDisplaySelectionCells.remove(l2);
        } else {
            this.displaySelectionCells.remove(l2);
            this.noDisplaySelectionCells.add(l2);
        }
    }

    @Override
    public boolean isCellDisplaySelection(int n2, int n3) {
        Long l2 = RectangleSelection.SelectionRange.key(n2, n3);
        if (this.displaySelectionCells.contains(l2)) {
            return true;
        }
        if (this.noDisplaySelectionCells.contains(l2)) {
            return false;
        }
        return this.isDisplaySelection();
    }

    @Override
    public <E extends GridChange> void addEventHandler(EventType<E> eventType, EventHandler<E> eventHandler) {
        this.eventHandlerManager.addEventHandler(eventType, eventHandler);
    }

    @Override
    public <E extends GridChange> void removeEventHandler(EventType<E> eventType, EventHandler<E> eventHandler) {
        this.eventHandlerManager.removeEventHandler(eventType, eventHandler);
    }

    public EventDispatchChain buildEventDispatchChain(EventDispatchChain eventDispatchChain) {
        return eventDispatchChain.append((EventDispatcher)this.eventHandlerManager);
    }

    private void setRowCount(int n2) {
        this.rowCount = n2;
    }

    private void setColumnCount(int n2) {
        this.columnCount = n2;
    }

    public static class MapBasedRowHeightFactory
    implements Callback<Integer, Double> {
        private final Map<Integer, Double> rowHeightMap;

        public MapBasedRowHeightFactory(Map<Integer, Double> map) {
            this.rowHeightMap = map;
        }

        public Double call(Integer n2) {
            Double d2 = this.rowHeightMap.get(n2);
            return d2 == null ? -1.0 : d2;
        }
    }
}

