/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.decoration;

import javafx.collections.ObservableList;
import javafx.scene.Node;
import org.controlsfx.control.decoration.Decoration;

public class StyleClassDecoration
extends Decoration {
    private final String[] styleClasses;

    public StyleClassDecoration(String ... stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("var-arg style class array must not be null or empty");
        }
        this.styleClasses = stringArray;
    }

    @Override
    public Node applyDecoration(Node node) {
        ObservableList observableList = node.getStyleClass();
        for (String string : this.styleClasses) {
            if (observableList.contains(string)) continue;
            observableList.add(string);
        }
        return null;
    }

    @Override
    public void removeDecoration(Node node) {
        node.getStyleClass().removeAll((Object[])this.styleClasses);
    }
}

