/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.cell;

import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;
import javafx.scene.media.MediaView;
import org.controlsfx.control.GridCell;

public class MediaImageCell
extends GridCell<Media> {
    private MediaPlayer mediaPlayer;
    private final MediaView mediaView;

    public MediaImageCell() {
        this.getStyleClass().add((Object)"media-grid-cell");
        this.mediaView = new MediaView();
        this.mediaView.setMediaPlayer(this.mediaPlayer);
        this.mediaView.fitHeightProperty().bind((ObservableValue)this.heightProperty());
        this.mediaView.fitWidthProperty().bind((ObservableValue)this.widthProperty());
        this.mediaView.setMediaPlayer(this.mediaPlayer);
    }

    public void pause() {
        if (this.mediaPlayer != null) {
            this.mediaPlayer.pause();
        }
    }

    public void play() {
        if (this.mediaPlayer != null) {
            this.mediaPlayer.play();
        }
    }

    public void stop() {
        if (this.mediaPlayer != null) {
            this.mediaPlayer.stop();
        }
    }

    protected void updateItem(Media media, boolean bl2) {
        super.updateItem((Object)media, bl2);
        this.getChildren().clear();
        if (this.mediaPlayer != null) {
            this.mediaPlayer.stop();
        }
        if (bl2) {
            this.setGraphic(null);
        } else {
            this.mediaPlayer = new MediaPlayer(media);
            this.mediaView.setMediaPlayer(this.mediaPlayer);
            this.setGraphic((Node)this.mediaView);
        }
    }
}

