/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.action;

import java.lang.reflect.Method;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCombination;
import org.controlsfx.control.action.ActionCheck;
import org.controlsfx.control.action.ActionProxy;
import org.controlsfx.control.action.AnnotatedAction;
import org.controlsfx.control.action.AnnotatedActionFactory;
import org.controlsfx.control.action.AnnotatedCheckAction;
import org.controlsfx.glyphfont.Glyph;

public class DefaultActionFactory
implements AnnotatedActionFactory {
    @Override
    public AnnotatedAction createAction(ActionProxy actionProxy, Method method, Object object) {
        AnnotatedAction annotatedAction = method.isAnnotationPresent(ActionCheck.class) ? new AnnotatedCheckAction(actionProxy.text(), method, object) : new AnnotatedAction(actionProxy.text(), method, object);
        this.configureAction(actionProxy, annotatedAction);
        return annotatedAction;
    }

    protected void configureAction(ActionProxy actionProxy, AnnotatedAction annotatedAction) {
        String string;
        Node node = this.resolveGraphic(actionProxy);
        annotatedAction.setGraphic(node);
        String string2 = actionProxy.longText().trim();
        if (node != null) {
            annotatedAction.setLongText(string2);
        }
        if (!(string = actionProxy.accelerator().trim()).isEmpty()) {
            annotatedAction.setAccelerator(KeyCombination.keyCombination((String)string));
        }
    }

    protected Node resolveGraphic(ActionProxy actionProxy) {
        String string = actionProxy.graphic().trim();
        if (!string.isEmpty()) {
            String[] stringArray = string.split("\\>");
            if (stringArray.length == 1) {
                return new ImageView(new Image(stringArray[0]));
            }
            switch (stringArray[0]) {
                case "font": {
                    return Glyph.create(stringArray[1]);
                }
                case "image": {
                    return new ImageView(new Image(stringArray[1]));
                }
            }
            throw new IllegalArgumentException(String.format("Unknown ActionProxy graphic protocol: %s", stringArray[0]));
        }
        return null;
    }
}

