/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control;

import impl.org.controlsfx.skin.TaskProgressViewSkin;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Skin;
import javafx.util.Callback;
import org.controlsfx.control.ControlsFXControl;

public class TaskProgressView<T extends Task<?>>
extends ControlsFXControl {
    private final BooleanProperty retainTasks = new SimpleBooleanProperty((Object)this, "retainTasks", false);
    private final ObservableList<T> tasks = FXCollections.observableArrayList();
    private ObjectProperty<Callback<T, Node>> graphicFactory;

    public TaskProgressView() {
        this.getStyleClass().add((Object)"task-progress-view");
        final EventHandler eventHandler = workerStateEvent -> {
            if (!this.isRetainTasks() && (workerStateEvent.getEventType().equals(WorkerStateEvent.WORKER_STATE_SUCCEEDED) || workerStateEvent.getEventType().equals(WorkerStateEvent.WORKER_STATE_CANCELLED) || workerStateEvent.getEventType().equals(WorkerStateEvent.WORKER_STATE_FAILED))) {
                this.getTasks().remove((Object)workerStateEvent.getSource());
            }
        };
        this.getTasks().addListener(new ListChangeListener<Task<?>>(){

            public void onChanged(ListChangeListener.Change<? extends Task<?>> change) {
                while (change.next()) {
                    if (change.wasAdded()) {
                        for (Task task : change.getAddedSubList()) {
                            task.addEventHandler(WorkerStateEvent.ANY, eventHandler);
                        }
                        continue;
                    }
                    if (!change.wasRemoved()) continue;
                    for (Task task : change.getRemoved()) {
                        task.removeEventHandler(WorkerStateEvent.ANY, eventHandler);
                    }
                }
            }
        });
    }

    public String getUserAgentStylesheet() {
        return this.getUserAgentStylesheet(TaskProgressView.class, "taskprogressview.css");
    }

    protected Skin<?> createDefaultSkin() {
        return new TaskProgressViewSkin(this);
    }

    public final ObservableList<T> getTasks() {
        return this.tasks;
    }

    public final ObjectProperty<Callback<T, Node>> graphicFactoryProperty() {
        if (this.graphicFactory == null) {
            this.graphicFactory = new SimpleObjectProperty((Object)this, "graphicFactory");
        }
        return this.graphicFactory;
    }

    public final Callback<T, Node> getGraphicFactory() {
        return this.graphicFactory == null ? null : (Callback)this.graphicFactory.get();
    }

    public final void setGraphicFactory(Callback<T, Node> callback) {
        this.graphicFactoryProperty().set(callback);
    }

    public final boolean isRetainTasks() {
        return this.retainTasks.get();
    }

    public final BooleanProperty retainTasksProperty() {
        return this.retainTasks;
    }

    public final void setRetainTasks(boolean bl2) {
        this.retainTasks.set(bl2);
    }
}

