/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control;

import impl.org.controlsfx.skin.SnapshotViewSkin;
import impl.org.controlsfx.tools.rectangle.Rectangles2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableMap;
import javafx.css.CssMetaData;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.controlsfx.control.ControlsFXControl;

public class SnapshotView
extends ControlsFXControl {
    public static final double MAX_SELECTION_RATIO_DIVERGENCE = 1.0E-6;
    public static final String SELECTION_CHANGING_PROPERTY_KEY = SnapshotView.class.getCanonicalName() + ".selection_changing";
    private final ObjectProperty<Node> node;
    private final ObjectProperty<Rectangle2D> selection;
    private final BooleanProperty hasSelection;
    private final BooleanProperty selectionActive;
    private final BooleanProperty selectionChanging;
    private final BooleanProperty selectionRatioFixed;
    private final DoubleProperty fixedSelectionRatio;
    private final ObjectProperty<Boundary> selectionAreaBoundary;
    private final BooleanProperty selectionActivityManaged;
    private final BooleanProperty selectionMouseTransparent;
    private final ObjectProperty<Boundary> unselectedAreaBoundary;
    private final ObjectProperty<Paint> selectionBorderPaint;
    private final DoubleProperty selectionBorderWidth;
    private final ObjectProperty<Paint> selectionAreaFill;
    private final ObjectProperty<Paint> unselectedAreaFill;
    private static final String DEFAULT_STYLE_CLASS = "snapshot-view";

    public SnapshotView() {
        this.getStyleClass().setAll((Object[])new String[]{DEFAULT_STYLE_CLASS});
        this.node = new SimpleObjectProperty((Object)this, "node");
        this.selection = new SimpleObjectProperty<Rectangle2D>((Object)this, "selection"){

            public void set(Rectangle2D rectangle2D) {
                if (!SnapshotView.this.isSelectionValid(rectangle2D)) {
                    throw new IllegalArgumentException("The selection \"" + rectangle2D + "\" is invalid. Check the comment on 'SnapshotView.selectionProperty()' for all criteria a selection must fulfill.");
                }
                super.set((Object)rectangle2D);
            }
        };
        this.hasSelection = new SimpleBooleanProperty((Object)this, "hasSelection", false);
        this.hasSelection.bind((ObservableValue)Bindings.and((ObservableBooleanValue)Bindings.isNotNull(this.selection), (ObservableBooleanValue)Bindings.notEqual((Object)Rectangle2D.EMPTY, this.selection)));
        this.selectionActive = new SimpleBooleanProperty((Object)this, "selectionActive", false);
        this.selectionChanging = new SimpleBooleanProperty((Object)this, "selectionChanging", false);
        this.selectionRatioFixed = new SimpleBooleanProperty((Object)this, "selectionRatioFixed", false);
        this.fixedSelectionRatio = new SimpleDoubleProperty((Object)this, "fixedSelectionRatio", 1.0){

            public void set(double d2) {
                if (d2 <= 0.0) {
                    throw new IllegalArgumentException("The fixed selection ratio must be positive.");
                }
                super.set(d2);
            }
        };
        this.selectionAreaBoundary = SnapshotView.createStylableObjectProperty((Object)this, "selectionAreaBoundary", Boundary.CONTROL, Css.SELECTION_AREA_BOUNDARY);
        this.selectionActivityManaged = new SimpleBooleanProperty((Object)this, "selectionActivityManaged", true);
        this.selectionMouseTransparent = new SimpleBooleanProperty((Object)this, "selectionMouseTransparent", false);
        this.unselectedAreaBoundary = SnapshotView.createStylableObjectProperty((Object)this, "unselectedAreaBoundary", Boundary.CONTROL, Css.UNSELECTED_AREA_BOUNDARY);
        this.selectionBorderPaint = SnapshotView.createStylableObjectProperty((Object)this, "selectionBorderPaint", Color.WHITESMOKE, Css.SELECTION_BORDER_PAINT);
        this.selectionBorderWidth = SnapshotView.createStylableDoubleProperty((Object)this, "selectionBorderWidth", 2.5, Css.SELECTION_BORDER_WIDTH);
        this.selectionAreaFill = SnapshotView.createStylableObjectProperty((Object)this, "selectionAreaFill", Color.TRANSPARENT, Css.SELECTION_AREA_FILL);
        this.unselectedAreaFill = SnapshotView.createStylableObjectProperty((Object)this, "unselectedAreaFill", new Color(0.0, 0.0, 0.0, 0.5), Css.UNSELECTED_AREA_FILL);
        this.addStateUpdatingListeners();
        new SelectionSizeUpdater().enableResizing();
    }

    private void addStateUpdatingListeners() {
        this.selection.addListener((observableValue, rectangle2D, rectangle2D2) -> this.updateSelectionActivityState());
        this.selectionRatioFixed.addListener((observableValue, bl2, bl3) -> {
            boolean bl4;
            boolean bl5 = bl4 = bl2 == false && bl3 != false;
            if (bl4) {
                this.fixSelectionRatio();
            }
        });
        this.fixedSelectionRatio.addListener((observableValue, number, number2) -> {
            if (this.isSelectionRatioFixed()) {
                this.fixSelectionRatio();
            }
        });
        SnapshotView.listenToProperty((ObservableMap<Object, Object>)this.getProperties(), SELECTION_CHANGING_PROPERTY_KEY, bl2 -> this.selectionChanging.set(bl2.booleanValue()));
    }

    private static <T> void listenToProperty(ObservableMap<Object, Object> observableMap, Object object, Consumer<T> consumer) {
        Objects.requireNonNull(observableMap, "The argument 'properties' must not be null.");
        Objects.requireNonNull(object, "The argument 'key' must not be null.");
        Objects.requireNonNull(consumer, "The argument 'processValue' must not be null.");
        MapChangeListener mapChangeListener = change -> {
            boolean bl2;
            boolean bl3 = bl2 = change.wasAdded() && Objects.equals(object, change.getKey());
            if (bl2) {
                try {
                    Object object2 = change.getValueAdded();
                    consumer.accept(object2);
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
                observableMap.remove(object);
            }
        };
        observableMap.addListener(mapChangeListener);
    }

    public SnapshotView(Node node) {
        this();
        this.setNode(node);
    }

    public Rectangle2D transformSelectionToNodeCoordinates() {
        if (!this.hasSelection()) {
            throw new IllegalStateException("The selection can not be transformed if it does not exist (check 'hasSelection()').");
        }
        return this.transformToNodeCoordinates(this.getSelection());
    }

    public Rectangle2D transformToNodeCoordinates(Rectangle2D rectangle2D) throws IllegalStateException {
        Objects.requireNonNull(rectangle2D, "The argument 'area' must not be null.");
        if (this.getNode() == null) {
            throw new IllegalStateException("The selection can not be transformed if the node is null (check 'getNode()').");
        }
        Bounds bounds = this.getNode().getBoundsInParent();
        double d2 = bounds.getMinX();
        double d3 = bounds.getMinY();
        double d4 = rectangle2D.getMinX() - d2;
        double d5 = rectangle2D.getMinY() - d3;
        return new Rectangle2D(d4, d5, rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public WritableImage createSnapshot() throws IllegalStateException {
        if (this.getNode() == null) {
            throw new IllegalStateException("No snapshot can be created if the node is null (check 'getNode()').");
        }
        if (!this.hasSelection()) {
            throw new IllegalStateException("No snapshot can be created if there is no selection (check 'hasSelection()').");
        }
        SnapshotParameters snapshotParameters = new SnapshotParameters();
        snapshotParameters.setViewport(this.getSelection());
        return this.createSnapshot(snapshotParameters);
    }

    public WritableImage createSnapshot(SnapshotParameters snapshotParameters) throws IllegalStateException {
        Objects.requireNonNull(snapshotParameters, "The argument 'parameters' must not be null.");
        if (this.getNode() == null) {
            throw new IllegalStateException("No snapshot can be created if the node is null (check 'getNode()').");
        }
        return this.getNode().snapshot(snapshotParameters, null);
    }

    private void updateSelectionActivityState() {
        boolean bl2;
        boolean bl3 = bl2 = !this.isSelectionActivityManaged();
        if (bl2) {
            return;
        }
        boolean bl4 = this.getSelection() != null && this.getSelection() != Rectangle2D.EMPTY;
        this.setSelectionActive(bl4);
    }

    private void fixSelectionRatio() {
        boolean bl2;
        boolean bl3 = bl2 = this.getNode() == null || !this.hasSelection();
        if (bl2) {
            return;
        }
        Rectangle2D rectangle2D = this.getSelectionBounds();
        Rectangle2D rectangle2D2 = Rectangles2D.fixRatioWithinBounds(this.getSelection(), this.getFixedSelectionRatio(), rectangle2D);
        this.selection.set((Object)rectangle2D2);
    }

    private Rectangle2D getSelectionBounds() {
        Boundary boundary = this.getSelectionAreaBoundary();
        switch (boundary) {
            case CONTROL: {
                return new Rectangle2D(0.0, 0.0, this.getWidth(), this.getHeight());
            }
            case NODE: {
                return Rectangles2D.fromBounds(this.getNode().getBoundsInParent());
            }
        }
        throw new IllegalArgumentException("The boundary '" + boundary + "' is not fully implemented yet.");
    }

    private boolean isSelectionValid(Rectangle2D rectangle2D) {
        boolean bl2;
        boolean bl3 = bl2 = rectangle2D == null || rectangle2D == Rectangle2D.EMPTY;
        if (bl2) {
            return true;
        }
        if (!SnapshotView.valuesFinite(rectangle2D)) {
            return false;
        }
        if (!this.inBounds(rectangle2D)) {
            return false;
        }
        return this.hasCorrectRatio(rectangle2D);
    }

    private static boolean valuesFinite(Rectangle2D rectangle2D) {
        return Double.isFinite(rectangle2D.getMinX()) && Double.isFinite(rectangle2D.getMinY()) && Double.isFinite(rectangle2D.getWidth()) && Double.isFinite(rectangle2D.getHeight());
    }

    private boolean inBounds(Rectangle2D rectangle2D) {
        Boundary boundary = this.getSelectionAreaBoundary();
        switch (boundary) {
            case CONTROL: {
                return SnapshotView.inBounds(rectangle2D, this.getBoundsInLocal());
            }
            case NODE: {
                if (this.getNode() == null) {
                    return false;
                }
                return SnapshotView.inBounds(rectangle2D, this.getNode().getBoundsInParent());
            }
        }
        throw new IllegalArgumentException("The boundary '" + boundary + "' is not fully implemented yet.");
    }

    private static boolean inBounds(Rectangle2D rectangle2D, Bounds bounds) {
        return bounds.getMinX() <= rectangle2D.getMinX() && bounds.getMinY() <= rectangle2D.getMinY() && rectangle2D.getMaxX() <= bounds.getMaxX() && rectangle2D.getMaxY() <= bounds.getMaxY();
    }

    private boolean hasCorrectRatio(Rectangle2D rectangle2D) {
        if (!this.isSelectionRatioFixed()) {
            return true;
        }
        double d2 = rectangle2D.getWidth() / rectangle2D.getHeight();
        double d3 = Math.abs(1.0 - d2 / this.getFixedSelectionRatio());
        return d3 <= 1.0E-6;
    }

    public String getUserAgentStylesheet() {
        return this.getUserAgentStylesheet(SnapshotView.class, "snapshot-view.css");
    }

    private static StyleableDoubleProperty createStylableDoubleProperty(final Object object, final String string, double d2, final CssMetaData<? extends Styleable, Number> cssMetaData) {
        return new StyleableDoubleProperty(d2){

            public Object getBean() {
                return object;
            }

            public String getName() {
                return string;
            }

            public CssMetaData<? extends Styleable, Number> getCssMetaData() {
                return cssMetaData;
            }
        };
    }

    private static <T> StyleableObjectProperty<T> createStylableObjectProperty(final Object object, final String string, T t2, final CssMetaData<? extends Styleable, T> cssMetaData) {
        return new StyleableObjectProperty<T>(t2){

            public Object getBean() {
                return object;
            }

            public String getName() {
                return string;
            }

            public CssMetaData<? extends Styleable, T> getCssMetaData() {
                return cssMetaData;
            }
        };
    }

    private static <S extends Styleable, T> CssMetaData<S, T> createCssMetaData(final Function<S, Property<T>> function, String string, StyleConverter<?, T> styleConverter) {
        return new CssMetaData<S, T>(string, styleConverter){

            public boolean isSettable(S s2) {
                Property property = (Property)function.apply(s2);
                return property != null && !property.isBound();
            }

            public StyleableProperty<T> getStyleableProperty(S s2) {
                return (StyleableProperty)function.apply(s2);
            }
        };
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return Css.CSS_META_DATA;
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return SnapshotView.getClassCssMetaData();
    }

    protected Skin<?> createDefaultSkin() {
        return new SnapshotViewSkin(this);
    }

    public final ObjectProperty<Node> nodeProperty() {
        return this.node;
    }

    public final Node getNode() {
        return (Node)this.nodeProperty().get();
    }

    public final void setNode(Node node) {
        this.nodeProperty().set((Object)node);
    }

    public final ObjectProperty<Rectangle2D> selectionProperty() {
        return this.selection;
    }

    public final Rectangle2D getSelection() {
        return (Rectangle2D)this.selectionProperty().get();
    }

    public final void setSelection(Rectangle2D rectangle2D) {
        this.selectionProperty().set((Object)rectangle2D);
    }

    public final void setSelection(double d2, double d3, double d4, double d5) {
        this.selectionProperty().set((Object)new Rectangle2D(d2, d3, d4, d5));
    }

    public final ReadOnlyBooleanProperty hasSelectionProperty() {
        return this.hasSelection;
    }

    public final boolean hasSelection() {
        return this.hasSelectionProperty().get();
    }

    public final BooleanProperty selectionActiveProperty() {
        return this.selectionActive;
    }

    public final boolean isSelectionActive() {
        return this.selectionActiveProperty().get();
    }

    public final void setSelectionActive(boolean bl2) {
        this.selectionActiveProperty().set(bl2);
    }

    public final ReadOnlyBooleanProperty selectionChangingProperty() {
        return this.selectionChanging;
    }

    public final boolean isSelectionChanging() {
        return this.selectionChangingProperty().get();
    }

    public final BooleanProperty selectionRatioFixedProperty() {
        return this.selectionRatioFixed;
    }

    public final boolean isSelectionRatioFixed() {
        return this.selectionRatioFixedProperty().get();
    }

    public final void setSelectionRatioFixed(boolean bl2) {
        this.selectionRatioFixedProperty().set(bl2);
    }

    public final DoubleProperty fixedSelectionRatioProperty() {
        return this.fixedSelectionRatio;
    }

    public final double getFixedSelectionRatio() {
        return this.fixedSelectionRatioProperty().get();
    }

    public final void setFixedSelectionRatio(double d2) {
        this.fixedSelectionRatioProperty().set(d2);
    }

    public final ObjectProperty<Boundary> selectionAreaBoundaryProperty() {
        return this.selectionAreaBoundary;
    }

    public final Boundary getSelectionAreaBoundary() {
        return (Boundary)((Object)this.selectionAreaBoundaryProperty().get());
    }

    public final void setSelectionAreaBoundary(Boundary boundary) {
        this.selectionAreaBoundaryProperty().set((Object)boundary);
    }

    public final BooleanProperty selectionActivityManagedProperty() {
        return this.selectionActivityManaged;
    }

    public final boolean isSelectionActivityManaged() {
        return this.selectionActivityManagedProperty().get();
    }

    public final void setSelectionActivityManaged(boolean bl2) {
        this.selectionActivityManagedProperty().set(bl2);
    }

    public final BooleanProperty selectionMouseTransparentProperty() {
        return this.selectionMouseTransparent;
    }

    public final boolean isSelectionMouseTransparent() {
        return this.selectionMouseTransparentProperty().get();
    }

    public final void setSelectionMouseTransparent(boolean bl2) {
        this.selectionMouseTransparentProperty().set(bl2);
    }

    public final ObjectProperty<Boundary> unselectedAreaBoundaryProperty() {
        return this.unselectedAreaBoundary;
    }

    public final Boundary getUnselectedAreaBoundary() {
        return (Boundary)((Object)this.unselectedAreaBoundaryProperty().get());
    }

    public final void setUnselectedAreaBoundary(Boundary boundary) {
        this.unselectedAreaBoundaryProperty().set((Object)boundary);
    }

    public final ObjectProperty<Paint> selectionBorderPaintProperty() {
        return this.selectionBorderPaint;
    }

    public final Paint getSelectionBorderPaint() {
        return (Paint)this.selectionBorderPaintProperty().get();
    }

    public final void setSelectionBorderPaint(Paint paint) {
        this.selectionBorderPaintProperty().set((Object)paint);
    }

    public final DoubleProperty selectionBorderWidthProperty() {
        return this.selectionBorderWidth;
    }

    public final double getSelectionBorderWidth() {
        return this.selectionBorderWidthProperty().get();
    }

    public final void setSelectionBorderWidth(double d2) {
        this.selectionBorderWidthProperty().set(d2);
    }

    public final ObjectProperty<Paint> selectionAreaFillProperty() {
        return this.selectionAreaFill;
    }

    public final Paint getSelectionAreaFill() {
        return (Paint)this.selectionAreaFillProperty().get();
    }

    public final void setSelectionAreaFill(Paint paint) {
        this.selectionAreaFillProperty().set((Object)paint);
    }

    public final ObjectProperty<Paint> unselectedAreaFillProperty() {
        return this.unselectedAreaFill;
    }

    public final Paint getUnselectedAreaFill() {
        return (Paint)this.unselectedAreaFillProperty().get();
    }

    public final void setUnselectedAreaFill(Paint paint) {
        this.unselectedAreaFillProperty().set((Object)paint);
    }

    private class SelectionSizeUpdater {
        private final ChangeListener<Number> resizeSelectionToNewControlWidthListener = this::resizeSelectionToNewControlWidth;
        private final ChangeListener<Number> resizeSelectionToNewControlHeightListener = this::resizeSelectionToNewControlHeight;
        private final ChangeListener<Node> updateSelectionToNodeListener = this::updateSelectionToNewNode;
        private final ChangeListener<Bounds> resizeSelectionToNewNodeBoundsListener = this::resizeSelectionToNewNodeBounds;

        public void enableResizing() {
            this.enableResizingForBoundary(SnapshotView.this.getSelectionAreaBoundary());
            SnapshotView.this.selectionAreaBoundary.addListener((observableValue, boundary, boundary2) -> this.enableResizingForBoundary((Boundary)((Object)boundary2)));
        }

        private void enableResizingForBoundary(Boundary boundary) {
            switch (boundary) {
                case CONTROL: {
                    this.enableResizingForControl();
                    break;
                }
                case NODE: {
                    this.enableResizingForNode();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("The boundary '" + boundary + "' is not fully implemented yet.");
                }
            }
        }

        private void enableResizingForControl() {
            SnapshotView.this.node.removeListener(this.updateSelectionToNodeListener);
            if (SnapshotView.this.getNode() != null) {
                SnapshotView.this.getNode().boundsInParentProperty().removeListener(this.resizeSelectionToNewNodeBoundsListener);
            }
            SnapshotView.this.widthProperty().addListener(this.resizeSelectionToNewControlWidthListener);
            SnapshotView.this.heightProperty().addListener(this.resizeSelectionToNewControlHeightListener);
            this.resizeSelectionFromNodeToControl();
        }

        private void enableResizingForNode() {
            SnapshotView.this.widthProperty().removeListener(this.resizeSelectionToNewControlWidthListener);
            SnapshotView.this.heightProperty().removeListener(this.resizeSelectionToNewControlHeightListener);
            if (SnapshotView.this.getNode() != null) {
                SnapshotView.this.getNode().boundsInParentProperty().addListener(this.resizeSelectionToNewNodeBoundsListener);
            }
            SnapshotView.this.node.addListener(this.updateSelectionToNodeListener);
            this.resizeSelectionFromControlToNode();
        }

        private void resizeSelectionFromNodeToControl() {
            if (SnapshotView.this.getNode() == null) {
                SnapshotView.this.setSelection(null);
            } else {
                Rectangle2D rectangle2D = new Rectangle2D(0.0, 0.0, SnapshotView.this.getWidth(), SnapshotView.this.getHeight());
                Rectangle2D rectangle2D2 = Rectangles2D.fromBounds(SnapshotView.this.getNode().getBoundsInParent());
                this.resizeSelectionToNewBounds(rectangle2D2, rectangle2D);
            }
        }

        private void resizeSelectionToNewControlWidth(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
            Rectangle2D rectangle2D = new Rectangle2D(0.0, 0.0, number.doubleValue(), SnapshotView.this.getHeight());
            Rectangle2D rectangle2D2 = new Rectangle2D(0.0, 0.0, number2.doubleValue(), SnapshotView.this.getHeight());
            this.resizeSelectionToNewBounds(rectangle2D, rectangle2D2);
        }

        private void resizeSelectionToNewControlHeight(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
            Rectangle2D rectangle2D = new Rectangle2D(0.0, 0.0, SnapshotView.this.getWidth(), number.doubleValue());
            Rectangle2D rectangle2D2 = new Rectangle2D(0.0, 0.0, SnapshotView.this.getWidth(), number2.doubleValue());
            this.resizeSelectionToNewBounds(rectangle2D, rectangle2D2);
        }

        private void resizeSelectionFromControlToNode() {
            if (SnapshotView.this.getNode() == null) {
                SnapshotView.this.setSelection(null);
            } else {
                Rectangle2D rectangle2D = new Rectangle2D(0.0, 0.0, SnapshotView.this.getWidth(), SnapshotView.this.getHeight());
                Rectangle2D rectangle2D2 = Rectangles2D.fromBounds(SnapshotView.this.getNode().getBoundsInParent());
                this.resizeSelectionToNewBounds(rectangle2D, rectangle2D2);
            }
        }

        private void updateSelectionToNewNode(ObservableValue<? extends Node> observableValue, Node node, Node node2) {
            if (node != null) {
                node.boundsInParentProperty().removeListener(this.resizeSelectionToNewNodeBoundsListener);
            }
            if (node2 != null) {
                node2.boundsInParentProperty().addListener(this.resizeSelectionToNewNodeBoundsListener);
            }
            if (node == null || node2 == null) {
                SnapshotView.this.setSelection(null);
            } else {
                this.resizeSelectionToNewNodeBounds(null, node.getBoundsInParent(), node2.getBoundsInParent());
            }
        }

        private void resizeSelectionToNewNodeBounds(ObservableValue<? extends Bounds> observableValue, Bounds bounds, Bounds bounds2) {
            this.resizeSelectionToNewBounds(Rectangles2D.fromBounds(bounds), Rectangles2D.fromBounds(bounds2));
        }

        private void resizeSelectionToNewBounds(Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
            if (!SnapshotView.this.hasSelection()) {
                return;
            }
            Rectangle2D rectangle2D3 = this.transformSelectionToNewBounds(SnapshotView.this.getSelection(), rectangle2D, rectangle2D2);
            if (SnapshotView.this.isSelectionValid(rectangle2D3)) {
                SnapshotView.this.setSelection(rectangle2D3);
            } else {
                SnapshotView.this.setSelection(null);
            }
        }

        private Rectangle2D transformSelectionToNewBounds(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, Rectangle2D rectangle2D3) {
            Point2D point2D = this.computeNewSelectionCenter(rectangle2D, rectangle2D2, rectangle2D3);
            double d2 = rectangle2D3.getWidth() / rectangle2D2.getWidth();
            double d3 = rectangle2D3.getHeight() / rectangle2D2.getHeight();
            if (SnapshotView.this.isSelectionRatioFixed()) {
                double d4 = rectangle2D.getWidth() * d2 * (rectangle2D.getHeight() * d3);
                double d5 = SnapshotView.this.getFixedSelectionRatio();
                return Rectangles2D.forCenterAndAreaAndRatioWithinBounds(point2D, d4, d5, rectangle2D3);
            }
            double d6 = rectangle2D.getWidth() * d2;
            double d7 = rectangle2D.getHeight() * d3;
            return Rectangles2D.forCenterAndSize(point2D, d6, d7);
        }

        private Point2D computeNewSelectionCenter(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, Rectangle2D rectangle2D3) {
            Point2D point2D = Rectangles2D.getCenterPoint(rectangle2D);
            Point2D point2D2 = Rectangles2D.getCenterPoint(rectangle2D2);
            Point2D point2D3 = point2D.subtract(point2D2);
            double d2 = rectangle2D3.getWidth() / rectangle2D2.getWidth();
            double d3 = rectangle2D3.getHeight() / rectangle2D2.getHeight();
            Point2D point2D4 = new Point2D(point2D3.getX() * d2, point2D3.getY() * d3);
            Point2D point2D5 = Rectangles2D.getCenterPoint(rectangle2D3);
            Point2D point2D6 = point2D5.add(point2D4);
            return point2D6;
        }
    }

    public static enum Boundary {
        CONTROL,
        NODE;

    }

    private static class Css {
        public static final CssMetaData<SnapshotView, Boundary> SELECTION_AREA_BOUNDARY = SnapshotView.createCssMetaData(snapshotView -> snapshotView.selectionAreaBoundary, "-fx-selection-area-boundary", StyleConverter.getEnumConverter(Boundary.class));
        public static final CssMetaData<SnapshotView, Boundary> UNSELECTED_AREA_BOUNDARY = SnapshotView.createCssMetaData(snapshotView -> snapshotView.unselectedAreaBoundary, "-fx-unselected-area-boundary", StyleConverter.getEnumConverter(Boundary.class));
        public static final CssMetaData<SnapshotView, Paint> SELECTION_BORDER_PAINT = SnapshotView.createCssMetaData(snapshotView -> snapshotView.selectionBorderPaint, "-fx-selection-border-paint", StyleConverter.getPaintConverter());
        public static final CssMetaData<SnapshotView, Number> SELECTION_BORDER_WIDTH = SnapshotView.createCssMetaData(snapshotView -> snapshotView.selectionBorderWidth, "-fx-selection-border-width", StyleConverter.getSizeConverter());
        public static final CssMetaData<SnapshotView, Paint> SELECTION_AREA_FILL = SnapshotView.createCssMetaData(snapshotView -> snapshotView.selectionAreaFill, "-fx-selection-area-fill", StyleConverter.getPaintConverter());
        public static final CssMetaData<SnapshotView, Paint> UNSELECTED_AREA_FILL = SnapshotView.createCssMetaData(snapshotView -> snapshotView.unselectedAreaFill, "-fx-unselected-area-fill", StyleConverter.getPaintConverter());
        public static final List<CssMetaData<? extends Styleable, ?>> CSS_META_DATA;

        private Css() {
        }

        static {
            ArrayList<Object> arrayList = new ArrayList<Object>(Control.getClassCssMetaData());
            arrayList.add(SELECTION_AREA_BOUNDARY);
            arrayList.add(UNSELECTED_AREA_BOUNDARY);
            arrayList.add(SELECTION_BORDER_PAINT);
            arrayList.add(SELECTION_BORDER_WIDTH);
            arrayList.add(SELECTION_AREA_FILL);
            arrayList.add(UNSELECTED_AREA_FILL);
            CSS_META_DATA = Collections.unmodifiableList(arrayList);
        }
    }
}

