/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.nio;

import java.nio.channels.SelectionKey;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.function.ToIntFunction;

public class NioSelectedKeySet
extends AbstractSet<SelectionKey> {
    private static final int INITIAL_CAPACITY = 10;
    private SelectionKey[] keys;
    private int size = 0;

    public NioSelectedKeySet() {
        this.keys = new SelectionKey[10];
    }

    public NioSelectedKeySet(int n2) {
        if (n2 < 0 || n2 > 0x7FFFFFF7) {
            throw new IllegalArgumentException("invalid initial capacity: " + n2);
        }
        this.keys = new SelectionKey[Math.max(n2, 10)];
    }

    @Override
    public int size() {
        return this.size;
    }

    public int capacity() {
        return this.keys.length;
    }

    @Override
    public boolean isEmpty() {
        return 0 == this.size;
    }

    @Override
    public boolean add(SelectionKey selectionKey) {
        if (null == selectionKey) {
            return false;
        }
        this.ensureCapacity(this.size + 1);
        this.keys[this.size++] = selectionKey;
        return true;
    }

    @Override
    public boolean remove(Object object) {
        for (int i2 = 0; i2 < this.size; ++i2) {
            SelectionKey selectionKey = this.keys[i2];
            if (!selectionKey.equals(object)) continue;
            this.keys[i2] = this.keys[--this.size];
            this.keys[this.size] = null;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Object object) {
        for (int i2 = 0; i2 < this.size; ++i2) {
            SelectionKey selectionKey = this.keys[i2];
            if (!selectionKey.equals(object)) continue;
            return true;
        }
        return false;
    }

    public SelectionKey[] keys() {
        return this.keys;
    }

    public void reset() {
        this.size = 0;
    }

    @Override
    public void clear() {
        Arrays.fill(this.keys, null);
        this.size = 0;
    }

    public void reset(int n2) {
        if (n2 > this.size) {
            throw new IllegalArgumentException("skipCount " + n2 + " > size " + this.size);
        }
        if (0 != this.size) {
            SelectionKey[] selectionKeyArray = this.keys;
            int n3 = this.size - n2;
            System.arraycopy(selectionKeyArray, n2, selectionKeyArray, 0, n3);
            this.size = n3;
        }
    }

    public int forEach(ToIntFunction<SelectionKey> toIntFunction) {
        int n2 = 0;
        SelectionKey[] selectionKeyArray = this.keys;
        for (int i2 = this.size - 1; i2 >= 0; --i2) {
            n2 += toIntFunction.applyAsInt(selectionKeyArray[i2]);
        }
        this.size = 0;
        return n2;
    }

    @Override
    public Iterator<SelectionKey> iterator() {
        throw new UnsupportedOperationException();
    }

    private void ensureCapacity(int n2) {
        if (n2 < 0) {
            throw new IllegalStateException("insufficient capacity: length=" + this.keys.length + " required=" + n2);
        }
        int n3 = this.keys.length;
        if (n2 > n3) {
            int n4 = n3 + (n3 >> 1);
            if (n4 < 0 || n4 > 0x7FFFFFF7) {
                if (n3 == 0x7FFFFFF7) {
                    throw new IllegalStateException("max capacity reached: 2147483639");
                }
                n4 = 0x7FFFFFF7;
            }
            this.keys = Arrays.copyOf(this.keys, n4);
        }
    }
}

