/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.io;

import java.io.InputStream;
import org.agrona.DirectBuffer;

public class DirectBufferInputStream
extends InputStream {
    private DirectBuffer buffer;
    private int offset;
    private int length;
    private int position;

    public DirectBufferInputStream() {
    }

    public DirectBufferInputStream(DirectBuffer directBuffer) {
        this.wrap(directBuffer, 0, directBuffer.capacity());
    }

    public DirectBufferInputStream(DirectBuffer directBuffer, int n2, int n3) {
        this.wrap(directBuffer, n2, n3);
    }

    public void wrap(DirectBuffer directBuffer) {
        this.wrap(directBuffer, 0, directBuffer.capacity());
    }

    public void wrap(DirectBuffer directBuffer, int n2, int n3) {
        if (null == directBuffer) {
            throw new NullPointerException("buffer cannot be null");
        }
        this.buffer = directBuffer;
        this.offset = n2;
        this.length = n3;
        this.position = 0;
    }

    public int offset() {
        return this.offset;
    }

    public int length() {
        return this.length;
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int available() {
        return this.length - this.position;
    }

    @Override
    public long skip(long l2) {
        int n2 = (int)Math.min(l2, (long)this.available());
        this.position += n2;
        return n2;
    }

    @Override
    public int read() {
        int n2 = -1;
        if (this.position < this.length) {
            n2 = this.buffer.getByte(this.offset + this.position) & 0xFF;
            ++this.position;
        }
        return n2;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        int n4 = -1;
        if (this.position < this.length) {
            n4 = Math.min(n3, this.available());
            this.buffer.getBytes(this.offset + this.position, byArray, n2, n4);
            this.position += n4;
        }
        return n4;
    }

    @Override
    public void close() {
    }
}

