/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent.status;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.collections.IntObjConsumer;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class CountersReader {
    public static final int DEFAULT_TYPE_ID = 0;
    public static final long DEFAULT_REGISTRATION_ID = 0L;
    public static final long DEFAULT_OWNER_ID = 0L;
    public static final long DEFAULT_REFERENCE_ID = 0L;
    public static final int NULL_COUNTER_ID = -1;
    public static final int RECORD_UNUSED = 0;
    public static final int RECORD_ALLOCATED = 1;
    public static final int RECORD_RECLAIMED = -1;
    public static final long NOT_FREE_TO_REUSE = Long.MAX_VALUE;
    public static final int REGISTRATION_ID_OFFSET = 8;
    public static final int OWNER_ID_OFFSET = 16;
    public static final int REFERENCE_ID_OFFSET = 24;
    public static final int TYPE_ID_OFFSET = 4;
    public static final int FREE_FOR_REUSE_DEADLINE_OFFSET = 8;
    public static final int KEY_OFFSET = 16;
    public static final int LABEL_OFFSET = 128;
    public static final int FULL_LABEL_LENGTH = 384;
    public static final int MAX_LABEL_LENGTH = 380;
    public static final int MAX_KEY_LENGTH = 112;
    public static final int METADATA_LENGTH = 512;
    public static final int COUNTER_LENGTH = 128;
    protected final int maxCounterId;
    protected final AtomicBuffer metaDataBuffer;
    protected final AtomicBuffer valuesBuffer;
    protected final Charset labelCharset;

    public CountersReader(AtomicBuffer atomicBuffer, AtomicBuffer atomicBuffer2) {
        this(atomicBuffer, atomicBuffer2, StandardCharsets.UTF_8);
    }

    public CountersReader(AtomicBuffer atomicBuffer, AtomicBuffer atomicBuffer2, Charset charset) {
        this.maxCounterId = atomicBuffer2.capacity() / 128 - 1;
        this.valuesBuffer = atomicBuffer2;
        this.metaDataBuffer = atomicBuffer;
        this.labelCharset = charset;
    }

    public int maxCounterId() {
        return this.maxCounterId;
    }

    public AtomicBuffer metaDataBuffer() {
        return this.metaDataBuffer;
    }

    public AtomicBuffer valuesBuffer() {
        return this.valuesBuffer;
    }

    public Charset labelCharset() {
        return this.labelCharset;
    }

    public static int counterOffset(int n2) {
        return n2 * 128;
    }

    public static int metaDataOffset(int n2) {
        return n2 * 512;
    }

    public void forEach(IntObjConsumer<String> intObjConsumer) {
        int n2 = 0;
        AtomicBuffer atomicBuffer = this.metaDataBuffer;
        int n3 = atomicBuffer.capacity();
        for (int i2 = 0; i2 < n3; i2 += 512) {
            int n4 = atomicBuffer.getIntVolatile(i2);
            if (1 == n4) {
                intObjConsumer.accept(n2, this.labelValue(atomicBuffer, i2));
            } else if (0 == n4) break;
            ++n2;
        }
    }

    public void forEach(CounterConsumer counterConsumer) {
        int n2 = 0;
        AtomicBuffer atomicBuffer = this.metaDataBuffer;
        AtomicBuffer atomicBuffer2 = this.valuesBuffer;
        int n3 = atomicBuffer.capacity();
        for (int i2 = 0; i2 < n3; i2 += 512) {
            int n4 = atomicBuffer.getIntVolatile(i2);
            if (1 == n4) {
                String string = this.labelValue(atomicBuffer, i2);
                long l2 = atomicBuffer2.getLongVolatile(CountersReader.counterOffset(n2));
                counterConsumer.accept(l2, n2, string);
            } else if (0 == n4) break;
            ++n2;
        }
    }

    public void forEach(MetaData metaData) {
        int n2 = 0;
        AtomicBuffer atomicBuffer = this.metaDataBuffer;
        int n3 = atomicBuffer.capacity();
        for (int i2 = 0; i2 < n3; i2 += 512) {
            int n4 = atomicBuffer.getIntVolatile(i2);
            if (1 == n4) {
                int n5 = atomicBuffer.getInt(i2 + 4);
                String string = this.labelValue(atomicBuffer, i2);
                UnsafeBuffer unsafeBuffer = new UnsafeBuffer(atomicBuffer, i2 + 16, 112);
                metaData.accept(n2, n5, unsafeBuffer, string);
            } else if (0 == n4) break;
            ++n2;
        }
    }

    public int findByRegistrationId(long l2) {
        int n2 = -1;
        AtomicBuffer atomicBuffer = this.metaDataBuffer;
        int n3 = atomicBuffer.capacity();
        int n4 = 0;
        int n5 = 0;
        while (n4 < n3) {
            int n6 = atomicBuffer.getIntVolatile(n4);
            if (1 == n6) {
                if (l2 == this.valuesBuffer.getLongVolatile(CountersReader.counterOffset(n5) + 8)) {
                    n2 = n5;
                    break;
                }
            } else if (0 == n6) break;
            n4 += 512;
            ++n5;
        }
        return n2;
    }

    public int findByTypeIdAndRegistrationId(int n2, long l2) {
        int n3 = -1;
        AtomicBuffer atomicBuffer = this.metaDataBuffer;
        int n4 = atomicBuffer.capacity();
        int n5 = 0;
        int n6 = 0;
        while (n5 < n4) {
            int n7 = atomicBuffer.getIntVolatile(n5);
            if (1 == n7) {
                if (n2 == atomicBuffer.getInt(n5 + 4) && l2 == this.valuesBuffer.getLongVolatile(CountersReader.counterOffset(n6) + 8)) {
                    n3 = n6;
                    break;
                }
            } else if (0 == n7) break;
            n5 += 512;
            ++n6;
        }
        return n3;
    }

    public long getCounterValue(int n2) {
        this.validateCounterId(n2);
        return this.valuesBuffer.getLongVolatile(CountersReader.counterOffset(n2));
    }

    public long getCounterRegistrationId(int n2) {
        this.validateCounterId(n2);
        return this.valuesBuffer.getLongVolatile(CountersReader.counterOffset(n2) + 8);
    }

    public long getCounterOwnerId(int n2) {
        this.validateCounterId(n2);
        return this.valuesBuffer.getLong(CountersReader.counterOffset(n2) + 16);
    }

    public long getCounterReferenceId(int n2) {
        this.validateCounterId(n2);
        return this.valuesBuffer.getLong(CountersReader.counterOffset(n2) + 24);
    }

    public int getCounterState(int n2) {
        this.validateCounterId(n2);
        return this.metaDataBuffer.getIntVolatile(CountersReader.metaDataOffset(n2));
    }

    public int getCounterTypeId(int n2) {
        this.validateCounterId(n2);
        return this.metaDataBuffer.getInt(CountersReader.metaDataOffset(n2) + 4);
    }

    public long getFreeForReuseDeadline(int n2) {
        this.validateCounterId(n2);
        return this.metaDataBuffer.getLongVolatile(CountersReader.metaDataOffset(n2) + 8);
    }

    public String getCounterLabel(int n2) {
        this.validateCounterId(n2);
        return this.labelValue(this.metaDataBuffer, CountersReader.metaDataOffset(n2));
    }

    protected void validateCounterId(int n2) {
        if (n2 < 0 || n2 > this.maxCounterId) {
            throw new IllegalArgumentException("counter id " + n2 + " out of range: 0 - maxCounterId=" + this.maxCounterId);
        }
    }

    private String labelValue(AtomicBuffer atomicBuffer, int n2) {
        int n3 = atomicBuffer.getIntVolatile(n2 + 128);
        byte[] byArray = new byte[n3];
        atomicBuffer.getBytes(n2 + 128 + 4, byArray);
        return new String(byArray, this.labelCharset);
    }

    @FunctionalInterface
    public static interface CounterConsumer {
        public void accept(long var1, int var3, String var4);
    }

    @FunctionalInterface
    public static interface MetaData {
        public void accept(int var1, int var2, DirectBuffer var3, String var4);
    }
}

