/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent.status;

import java.util.concurrent.atomic.AtomicLong;
import org.agrona.concurrent.status.Position;

public class AtomicLongPosition
extends Position {
    private boolean isClosed = false;
    private final int id;
    private final AtomicLong value;

    public AtomicLongPosition() {
        this(0, 0L);
    }

    public AtomicLongPosition(int n2) {
        this(n2, 0L);
    }

    public AtomicLongPosition(int n2, long l2) {
        this.id = n2;
        this.value = new AtomicLong(l2);
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public long get() {
        return this.value.get();
    }

    @Override
    public long getVolatile() {
        return this.value.get();
    }

    @Override
    public void set(long l2) {
        this.value.lazySet(l2);
    }

    @Override
    public void setOrdered(long l2) {
        this.value.lazySet(l2);
    }

    @Override
    public void setVolatile(long l2) {
        this.value.set(l2);
    }

    @Override
    public boolean proposeMax(long l2) {
        return this.proposeMaxOrdered(l2);
    }

    @Override
    public boolean proposeMaxOrdered(long l2) {
        boolean bl2 = false;
        if (this.get() < l2) {
            this.setOrdered(l2);
            bl2 = true;
        }
        return bl2;
    }

    @Override
    public void close() {
        this.isClosed = true;
    }

    public String toString() {
        return "AtomicLongPosition{isClosed=" + this.isClosed() + ", id=" + this.id + ", value=" + (this.isClosed() ? Integer.valueOf(-1) : this.value) + '}';
    }
}

