/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent.ringbuffer;

import org.agrona.BitUtil;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.ControlledMessageHandler;
import org.agrona.concurrent.MemoryAccess;
import org.agrona.concurrent.MessageHandler;
import org.agrona.concurrent.ringbuffer.RecordDescriptor;
import org.agrona.concurrent.ringbuffer.RingBuffer;
import org.agrona.concurrent.ringbuffer.RingBufferDescriptor;

public final class ManyToOneRingBuffer
implements RingBuffer {
    public static final int MIN_CAPACITY = 8;
    private final int capacity;
    private final int maxMsgLength;
    private final int tailPositionIndex;
    private final int headCachePositionIndex;
    private final int headPositionIndex;
    private final int correlationIdCounterIndex;
    private final int consumerHeartbeatIndex;
    private final AtomicBuffer buffer;

    public ManyToOneRingBuffer(AtomicBuffer atomicBuffer) {
        this.capacity = RingBufferDescriptor.checkCapacity(atomicBuffer.capacity(), 8);
        atomicBuffer.verifyAlignment();
        this.buffer = atomicBuffer;
        this.maxMsgLength = 8 == this.capacity ? 0 : Math.max(8, this.capacity >> 3);
        this.tailPositionIndex = this.capacity + RingBufferDescriptor.TAIL_POSITION_OFFSET;
        this.headCachePositionIndex = this.capacity + RingBufferDescriptor.HEAD_CACHE_POSITION_OFFSET;
        this.headPositionIndex = this.capacity + RingBufferDescriptor.HEAD_POSITION_OFFSET;
        this.correlationIdCounterIndex = this.capacity + RingBufferDescriptor.CORRELATION_COUNTER_OFFSET;
        this.consumerHeartbeatIndex = this.capacity + RingBufferDescriptor.CONSUMER_HEARTBEAT_OFFSET;
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public boolean write(int n2, DirectBuffer directBuffer, int n3, int n4) {
        RecordDescriptor.checkTypeId(n2);
        this.checkMsgLength(n4);
        AtomicBuffer atomicBuffer = this.buffer;
        int n5 = n4 + 8;
        int n6 = this.claimCapacity(atomicBuffer, n5);
        if (-2 == n6) {
            return false;
        }
        atomicBuffer.putIntOrdered(RecordDescriptor.lengthOffset(n6), -n5);
        MemoryAccess.releaseFence();
        atomicBuffer.putBytes(RecordDescriptor.encodedMsgOffset(n6), directBuffer, n3, n4);
        atomicBuffer.putInt(RecordDescriptor.typeOffset(n6), n2);
        atomicBuffer.putIntOrdered(RecordDescriptor.lengthOffset(n6), n5);
        return true;
    }

    @Override
    public int tryClaim(int n2, int n3) {
        RecordDescriptor.checkTypeId(n2);
        this.checkMsgLength(n3);
        AtomicBuffer atomicBuffer = this.buffer;
        int n4 = n3 + 8;
        int n5 = this.claimCapacity(atomicBuffer, n4);
        if (-2 == n5) {
            return n5;
        }
        atomicBuffer.putIntOrdered(RecordDescriptor.lengthOffset(n5), -n4);
        MemoryAccess.releaseFence();
        atomicBuffer.putInt(RecordDescriptor.typeOffset(n5), n2);
        return RecordDescriptor.encodedMsgOffset(n5);
    }

    @Override
    public void commit(int n2) {
        int n3 = this.computeRecordIndex(n2);
        AtomicBuffer atomicBuffer = this.buffer;
        int n4 = this.verifyClaimedSpaceNotReleased(atomicBuffer, n3);
        atomicBuffer.putIntOrdered(RecordDescriptor.lengthOffset(n3), -n4);
    }

    @Override
    public void abort(int n2) {
        int n3 = this.computeRecordIndex(n2);
        AtomicBuffer atomicBuffer = this.buffer;
        int n4 = this.verifyClaimedSpaceNotReleased(atomicBuffer, n3);
        atomicBuffer.putInt(RecordDescriptor.typeOffset(n3), -1);
        atomicBuffer.putIntOrdered(RecordDescriptor.lengthOffset(n3), -n4);
    }

    @Override
    public int read(MessageHandler messageHandler) {
        return this.read(messageHandler, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(MessageHandler messageHandler, int n2) {
        int n3;
        int n4 = 0;
        AtomicBuffer atomicBuffer = this.buffer;
        int n5 = this.headPositionIndex;
        long l2 = atomicBuffer.getLong(n5);
        int n6 = this.capacity;
        int n7 = (int)l2 & n6 - 1;
        int n8 = n6 - n7;
        try {
            int n9;
            for (n3 = 0; n3 < n8 && n4 < n2; n3 += BitUtil.align(n9, 8)) {
                int n10 = n7 + n3;
                n9 = atomicBuffer.getIntVolatile(RecordDescriptor.lengthOffset(n10));
                if (n9 > 0) continue;
                break;
            }
        }
        finally {
            if (n3 > 0) {
                atomicBuffer.setMemory(n7, n3, (byte)0);
                atomicBuffer.putLongOrdered(n5, l2 + (long)n3);
            }
        }
        return n4;
    }

    @Override
    public int controlledRead(ControlledMessageHandler controlledMessageHandler) {
        return this.controlledRead(controlledMessageHandler, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int controlledRead(ControlledMessageHandler controlledMessageHandler, int n2) {
        int n3 = 0;
        AtomicBuffer atomicBuffer = this.buffer;
        int n4 = this.headPositionIndex;
        long l2 = atomicBuffer.getLong(n4);
        int n5 = this.capacity;
        int n6 = (int)l2 & n5 - 1;
        int n7 = n5 - n6;
        int n8 = 0;
        try {
            while (n8 < n7 && n3 < n2) {
                int n9 = n6 + n8;
                int n10 = atomicBuffer.getIntVolatile(RecordDescriptor.lengthOffset(n9));
                if (n10 <= 0) {
                    break;
                }
                int n11 = BitUtil.align(n10, 8);
                n8 += n11;
                int n12 = atomicBuffer.getInt(RecordDescriptor.typeOffset(n9));
                if (-1 == n12) continue;
                ControlledMessageHandler.Action action = controlledMessageHandler.onMessage(n12, atomicBuffer, n9 + 8, n10 - 8);
                if (ControlledMessageHandler.Action.ABORT == action) {
                    n8 -= n11;
                    break;
                }
                ++n3;
                if (ControlledMessageHandler.Action.BREAK == action) {
                    break;
                }
                if (ControlledMessageHandler.Action.COMMIT != action) continue;
                atomicBuffer.setMemory(n6, n8, (byte)0);
                atomicBuffer.putLongOrdered(n4, l2 + (long)n8);
                n6 += n8;
                l2 += (long)n8;
                n8 = 0;
            }
        }
        finally {
            if (n8 > 0) {
                atomicBuffer.setMemory(n6, n8, (byte)0);
                atomicBuffer.putLongOrdered(n4, l2 + (long)n8);
            }
        }
        return n3;
    }

    @Override
    public int maxMsgLength() {
        return this.maxMsgLength;
    }

    @Override
    public long nextCorrelationId() {
        return this.buffer.getAndAddLong(this.correlationIdCounterIndex, 1L);
    }

    @Override
    public AtomicBuffer buffer() {
        return this.buffer;
    }

    @Override
    public void consumerHeartbeatTime(long l2) {
        this.buffer.putLongOrdered(this.consumerHeartbeatIndex, l2);
    }

    @Override
    public long consumerHeartbeatTime() {
        return this.buffer.getLongVolatile(this.consumerHeartbeatIndex);
    }

    @Override
    public long producerPosition() {
        return this.buffer.getLongVolatile(this.tailPositionIndex);
    }

    @Override
    public long consumerPosition() {
        return this.buffer.getLongVolatile(this.headPositionIndex);
    }

    @Override
    public int size() {
        long l2;
        long l3;
        AtomicBuffer atomicBuffer = this.buffer;
        int n2 = this.headPositionIndex;
        int n3 = this.tailPositionIndex;
        long l4 = atomicBuffer.getLongVolatile(n2);
        do {
            l3 = l4;
            l2 = atomicBuffer.getLongVolatile(n3);
        } while ((l4 = atomicBuffer.getLongVolatile(n2)) != l3);
        long l5 = l2 - l4;
        if (l5 < 0L) {
            return 0;
        }
        if (l5 > (long)this.capacity) {
            return this.capacity;
        }
        return (int)l5;
    }

    @Override
    public boolean unblock() {
        long l2;
        AtomicBuffer atomicBuffer = this.buffer;
        long l3 = atomicBuffer.getLongVolatile(this.headPositionIndex);
        if (l3 == (l2 = atomicBuffer.getLongVolatile(this.tailPositionIndex))) {
            return false;
        }
        int n2 = this.capacity - 1;
        int n3 = (int)(l3 & (long)n2);
        int n4 = (int)(l2 & (long)n2);
        boolean bl2 = false;
        int n5 = atomicBuffer.getIntVolatile(n3);
        if (n5 < 0) {
            atomicBuffer.putInt(RecordDescriptor.typeOffset(n3), -1);
            atomicBuffer.putIntOrdered(RecordDescriptor.lengthOffset(n3), -n5);
            bl2 = true;
        } else if (0 == n5) {
            int n6 = n4 > n3 ? n4 : this.capacity;
            int n7 = n3 + 8;
            do {
                if (0 == (n5 = atomicBuffer.getIntVolatile(n7))) continue;
                if (!ManyToOneRingBuffer.scanBackToConfirmStillZeroed(atomicBuffer, n7, n3)) break;
                atomicBuffer.putInt(RecordDescriptor.typeOffset(n3), -1);
                atomicBuffer.putIntOrdered(RecordDescriptor.lengthOffset(n3), n7 - n3);
                bl2 = true;
                break;
            } while ((n7 += 8) < n6);
        }
        return bl2;
    }

    private static boolean scanBackToConfirmStillZeroed(AtomicBuffer atomicBuffer, int n2, int n3) {
        boolean bl2 = true;
        for (int i2 = n2 - 8; i2 >= n3; i2 -= 8) {
            if (0 == atomicBuffer.getIntVolatile(i2)) continue;
            bl2 = false;
            break;
        }
        return bl2;
    }

    private void checkMsgLength(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("invalid message length=" + n2);
        }
        if (n2 > this.maxMsgLength) {
            throw new IllegalArgumentException("encoded message exceeds maxMsgLength=" + this.maxMsgLength + ", length=" + n2);
        }
    }

    private int claimCapacity(AtomicBuffer atomicBuffer, int n2) {
        int n3;
        int n4;
        int n5;
        long l2;
        long l3;
        int n6 = BitUtil.align(n2, 8);
        int n7 = this.capacity;
        int n8 = this.tailPositionIndex;
        int n9 = this.headCachePositionIndex;
        int n10 = n7 - 1;
        long l4 = atomicBuffer.getLongVolatile(n9);
        do {
            int n11;
            if (n6 > (n11 = n7 - (int)((l3 = atomicBuffer.getLongVolatile(n8)) - l4))) {
                l4 = atomicBuffer.getLongVolatile(this.headPositionIndex);
                if (n6 > n7 - (int)(l3 - l4)) {
                    return -2;
                }
                atomicBuffer.putLongOrdered(n9, l4);
            }
            l2 = l3 + (long)n6;
            n5 = 0;
            n3 = n4 = (int)l3 & n10;
            int n12 = n7 - n4;
            if (n6 <= n12) continue;
            int n13 = (int)l4 & n10;
            n3 = 0;
            if (n6 > n13) {
                l4 = atomicBuffer.getLongVolatile(this.headPositionIndex);
                n13 = (int)l4 & n10;
                if (n6 > n13) {
                    n3 = -2;
                    l2 = l3;
                }
                atomicBuffer.putLongOrdered(n9, l4);
            }
            n5 = n12;
            l2 += (long)n5;
        } while (!atomicBuffer.compareAndSetLong(n8, l3, l2));
        if (0 != n5) {
            atomicBuffer.putIntOrdered(RecordDescriptor.lengthOffset(n4), -n5);
            MemoryAccess.releaseFence();
            atomicBuffer.putInt(RecordDescriptor.typeOffset(n4), -1);
            atomicBuffer.putIntOrdered(RecordDescriptor.lengthOffset(n4), n5);
        }
        return n3;
    }

    private int computeRecordIndex(int n2) {
        int n3 = n2 - 8;
        if (n3 < 0 || n3 > this.capacity - 8) {
            throw new IllegalArgumentException("invalid message index " + n2);
        }
        return n3;
    }

    private int verifyClaimedSpaceNotReleased(AtomicBuffer atomicBuffer, int n2) {
        int n3 = atomicBuffer.getInt(RecordDescriptor.lengthOffset(n2));
        if (n3 < 0) {
            return n3;
        }
        throw new IllegalStateException("claimed space previously " + (-1 == atomicBuffer.getInt(RecordDescriptor.typeOffset(n2)) ? "aborted" : "committed"));
    }
}

