/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent.errors;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.agrona.BitUtil;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.EpochClock;

public class DistinctErrorLog {
    public static final int LENGTH_OFFSET = 0;
    public static final int OBSERVATION_COUNT_OFFSET = 4;
    public static final int LAST_OBSERVATION_TIMESTAMP_OFFSET = 8;
    public static final int FIRST_OBSERVATION_TIMESTAMP_OFFSET = 16;
    public static final int ENCODED_ERROR_OFFSET = 24;
    public static final int RECORD_ALIGNMENT = 8;
    private static final DistinctObservation INSUFFICIENT_SPACE = new DistinctObservation(null, 0);
    private int nextOffset = 0;
    private final EpochClock clock;
    private final AtomicBuffer buffer;
    private final Charset charset;
    private DistinctObservation[] distinctObservations = new DistinctObservation[0];

    public DistinctErrorLog(AtomicBuffer atomicBuffer, EpochClock epochClock) {
        this(atomicBuffer, epochClock, StandardCharsets.UTF_8);
    }

    public DistinctErrorLog(AtomicBuffer atomicBuffer, EpochClock epochClock, Charset charset) {
        atomicBuffer.verifyAlignment();
        this.clock = epochClock;
        this.buffer = atomicBuffer;
        this.charset = charset;
    }

    public AtomicBuffer buffer() {
        return this.buffer;
    }

    public Charset charset() {
        return this.charset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean record(Throwable throwable) {
        DistinctObservation distinctObservation;
        long l2 = this.clock.time();
        DistinctErrorLog distinctErrorLog = this;
        synchronized (distinctErrorLog) {
            distinctObservation = DistinctErrorLog.find(this.distinctObservations, throwable);
            if (null == distinctObservation && INSUFFICIENT_SPACE == (distinctObservation = this.newObservation(l2, throwable))) {
                return false;
            }
        }
        int n2 = distinctObservation.offset;
        this.buffer.getAndAddInt(n2 + 4, 1);
        this.buffer.putLongOrdered(n2 + 8, l2);
        return true;
    }

    private static DistinctObservation find(DistinctObservation[] distinctObservationArray, Throwable throwable) {
        DistinctObservation distinctObservation = null;
        for (DistinctObservation distinctObservation2 : distinctObservationArray) {
            if (!DistinctErrorLog.equals(distinctObservation2.throwable, throwable)) continue;
            distinctObservation = distinctObservation2;
            break;
        }
        return distinctObservation;
    }

    private static boolean equals(Throwable throwable, Throwable throwable2) {
        do {
            if (throwable == throwable2) {
                return true;
            }
            if (throwable.getClass() != throwable2.getClass() || !Objects.equals(throwable.getMessage(), throwable2.getMessage()) || !DistinctErrorLog.equals(throwable.getStackTrace(), throwable2.getStackTrace())) break;
            throwable = throwable.getCause();
            throwable2 = throwable2.getCause();
            if (null != throwable || null != throwable2) continue;
            return true;
        } while (null != throwable && null != throwable2);
        return false;
    }

    private static boolean equals(StackTraceElement[] stackTraceElementArray, StackTraceElement[] stackTraceElementArray2) {
        if (stackTraceElementArray.length != stackTraceElementArray2.length) {
            return false;
        }
        int n2 = stackTraceElementArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            StackTraceElement stackTraceElement = stackTraceElementArray[i2];
            StackTraceElement stackTraceElement2 = stackTraceElementArray2[i2];
            if (stackTraceElement.getLineNumber() == stackTraceElement2.getLineNumber() && stackTraceElement.getClassName().equals(stackTraceElement2.getClassName()) && Objects.equals(stackTraceElement.getMethodName(), stackTraceElement2.getMethodName()) && Objects.equals(stackTraceElement.getFileName(), stackTraceElement2.getFileName())) continue;
            return false;
        }
        return true;
    }

    private DistinctObservation newObservation(long l2, Throwable throwable) {
        int n2 = this.nextOffset;
        if (n2 + 24 >= this.buffer.capacity()) {
            return INSUFFICIENT_SPACE;
        }
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        byte[] byArray = stringWriter.toString().getBytes(this.charset);
        int n3 = 24 + byArray.length;
        if (n2 + n3 > this.buffer.capacity()) {
            return INSUFFICIENT_SPACE;
        }
        this.buffer.putBytes(n2 + 24, byArray);
        this.buffer.putLong(n2 + 16, l2);
        this.nextOffset = BitUtil.align(n2 + n3, 8);
        DistinctObservation distinctObservation = new DistinctObservation(throwable, n2);
        this.distinctObservations = DistinctErrorLog.prepend(this.distinctObservations, distinctObservation);
        this.buffer.putIntOrdered(n2 + 0, n3);
        return distinctObservation;
    }

    private static DistinctObservation[] prepend(DistinctObservation[] distinctObservationArray, DistinctObservation distinctObservation) {
        int n2 = distinctObservationArray.length;
        DistinctObservation[] distinctObservationArray2 = new DistinctObservation[n2 + 1];
        distinctObservationArray2[0] = distinctObservation;
        System.arraycopy(distinctObservationArray, 0, distinctObservationArray2, 1, n2);
        return distinctObservationArray2;
    }

    static final class DistinctObservation {
        final Throwable throwable;
        final int offset;

        DistinctObservation(Throwable throwable, int n2) {
            this.throwable = throwable;
            this.offset = n2;
        }
    }
}

