/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.collections;

import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.LongPredicate;
import java.util.function.ToLongFunction;
import org.agrona.BitUtil;
import org.agrona.collections.CollectionUtil;
import org.agrona.collections.Hashing;
import org.agrona.collections.LongLongFunction;
import org.agrona.collections.ObjLongConsumer;
import org.agrona.collections.ObjLongPredicate;
import org.agrona.collections.ObjectLongToLongFunction;

public class Object2LongHashMap<K>
implements Map<K, Long> {
    static final int MIN_CAPACITY = 8;
    private final float loadFactor;
    private final long missingValue;
    private int resizeThreshold;
    private int size;
    private final boolean shouldAvoidAllocation;
    private K[] keys;
    private long[] values;
    private ValueCollection valueCollection;
    private KeySet keySet;
    private EntrySet entrySet;

    public Object2LongHashMap(long l2) {
        this(8, 0.65f, l2);
    }

    public Object2LongHashMap(int n2, float f2, long l2) {
        this(n2, f2, l2, true);
    }

    public Object2LongHashMap(int n2, float f2, long l2, boolean bl2) {
        CollectionUtil.validateLoadFactor(f2);
        this.loadFactor = f2;
        int n3 = BitUtil.findNextPositivePowerOfTwo(Math.max(8, n2));
        this.resizeThreshold = (int)((float)n3 * f2);
        this.missingValue = l2;
        this.shouldAvoidAllocation = bl2;
        this.keys = new Object[n3];
        this.values = new long[n3];
        Arrays.fill(this.values, l2);
    }

    public Object2LongHashMap(Object2LongHashMap<K> object2LongHashMap) {
        this.loadFactor = object2LongHashMap.loadFactor;
        this.resizeThreshold = object2LongHashMap.resizeThreshold;
        this.size = object2LongHashMap.size;
        this.missingValue = object2LongHashMap.missingValue;
        this.shouldAvoidAllocation = object2LongHashMap.shouldAvoidAllocation;
        this.keys = (Object[])object2LongHashMap.keys.clone();
        this.values = (long[])object2LongHashMap.values.clone();
    }

    public long missingValue() {
        return this.missingValue;
    }

    public float loadFactor() {
        return this.loadFactor;
    }

    public int capacity() {
        return this.values.length;
    }

    public int resizeThreshold() {
        return this.resizeThreshold;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return 0 == this.size;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.missingValue != this.getValue(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.containsValue((Long)object);
    }

    public boolean containsValue(long l2) {
        long[] lArray;
        if (this.missingValue == l2) {
            return false;
        }
        boolean bl2 = false;
        for (long l3 : lArray = this.values) {
            if (l2 != l3) continue;
            bl2 = true;
            break;
        }
        return bl2;
    }

    @Override
    public long getOrDefault(Object object, long l2) {
        long l3 = this.getValue(object);
        return this.missingValue != l3 ? l3 : l2;
    }

    @Override
    public Long get(Object object) {
        return this.valueOrNull(this.getValue(object));
    }

    public long getValue(K k2) {
        long l2;
        Objects.requireNonNull(k2);
        long l3 = this.missingValue;
        K[] KArray = this.keys;
        long[] lArray = this.values;
        int n2 = lArray.length - 1;
        int n3 = Hashing.hash(k2, n2);
        while (l3 != (l2 = lArray[n3]) && !Objects.equals(KArray[n3], k2)) {
            ++n3;
            n3 &= n2;
        }
        return l2;
    }

    public long computeIfAbsent(K k2, ToLongFunction<? super K> toLongFunction) {
        long l2;
        Objects.requireNonNull(k2);
        long l3 = this.missingValue;
        K[] KArray = this.keys;
        long[] lArray = this.values;
        int n2 = lArray.length - 1;
        int n3 = Hashing.hash(k2, n2);
        while (l3 != (l2 = lArray[n3])) {
            if (Objects.equals(KArray[n3], k2)) {
                return l2;
            }
            ++n3;
            n3 &= n2;
        }
        long l4 = toLongFunction.applyAsLong(k2);
        if (l3 != l4) {
            KArray[n3] = k2;
            lArray[n3] = l4;
            if (++this.size > this.resizeThreshold) {
                this.increaseCapacity();
            }
        }
        return l4;
    }

    public long computeIfPresent(K k2, ObjectLongToLongFunction<? super K> objectLongToLongFunction) {
        long l2;
        Objects.requireNonNull(k2);
        long l3 = this.missingValue;
        K[] KArray = this.keys;
        long[] lArray = this.values;
        int n2 = lArray.length - 1;
        int n3 = Hashing.hash(k2, n2);
        while (l3 != (l2 = lArray[n3])) {
            if (Objects.equals(KArray[n3], k2)) {
                long l4;
                lArray[n3] = l4 = objectLongToLongFunction.apply(k2, l2);
                if (l3 == l4) {
                    KArray[n3] = null;
                    --this.size;
                    this.compactChain(n3);
                }
                return l4;
            }
            ++n3;
            n3 &= n2;
        }
        return l3;
    }

    public long compute(K k2, ObjectLongToLongFunction<? super K> objectLongToLongFunction) {
        long l2;
        Objects.requireNonNull(k2);
        long l3 = this.missingValue;
        K[] KArray = this.keys;
        long[] lArray = this.values;
        int n2 = lArray.length - 1;
        int n3 = Hashing.hash(k2, n2);
        while (l3 != (l2 = lArray[n3]) && !Objects.equals(KArray[n3], k2)) {
            ++n3;
            n3 &= n2;
        }
        long l4 = objectLongToLongFunction.apply(k2, l2);
        if (l3 != l4) {
            lArray[n3] = l4;
            if (l3 == l2) {
                KArray[n3] = k2;
                if (++this.size > this.resizeThreshold) {
                    this.increaseCapacity();
                }
            }
        } else if (l3 != l2) {
            KArray[n3] = null;
            lArray[n3] = l3;
            --this.size;
            this.compactChain(n3);
        }
        return l4;
    }

    public long merge(K k2, long l2, LongLongFunction longLongFunction) {
        long l3;
        long l4;
        Objects.requireNonNull(k2);
        Objects.requireNonNull(longLongFunction);
        long l5 = this.missingValue;
        if (l5 == l2) {
            throw new IllegalArgumentException("cannot accept missingValue");
        }
        K[] KArray = this.keys;
        long[] lArray = this.values;
        int n2 = lArray.length - 1;
        int n3 = Hashing.hash(k2, n2);
        while (l5 != (l4 = lArray[n3]) && !Objects.equals(KArray[n3], k2)) {
            ++n3;
            n3 &= n2;
        }
        long l6 = l3 = l5 == l4 ? l2 : longLongFunction.apply(l4, l2);
        if (l5 != l3) {
            KArray[n3] = k2;
            lArray[n3] = l3;
            if (++this.size > this.resizeThreshold) {
                this.increaseCapacity();
            }
        } else {
            KArray[n3] = null;
            lArray[n3] = l5;
            --this.size;
            this.compactChain(n3);
        }
        return l3;
    }

    @Override
    public Long put(K k2, Long l2) {
        return this.valueOrNull(this.put(k2, (long)l2));
    }

    @Override
    public long put(K k2, long l2) {
        long l3;
        Objects.requireNonNull(k2);
        long l4 = this.missingValue;
        if (l4 == l2) {
            throw new IllegalArgumentException("cannot accept missingValue");
        }
        K[] KArray = this.keys;
        long[] lArray = this.values;
        int n2 = lArray.length - 1;
        int n3 = Hashing.hash(k2, n2);
        while (l4 != (l3 = lArray[n3]) && !Objects.equals(KArray[n3], k2)) {
            ++n3;
            n3 &= n2;
        }
        if (l4 == l3) {
            ++this.size;
            KArray[n3] = k2;
        }
        lArray[n3] = l2;
        if (this.size > this.resizeThreshold) {
            this.increaseCapacity();
        }
        return l3;
    }

    @Override
    public Long putIfAbsent(K k2, Long l2) {
        return this.valueOrNull(this.putIfAbsent(k2, (long)l2));
    }

    @Override
    public long putIfAbsent(K k2, long l2) {
        long l3;
        Objects.requireNonNull(k2);
        long l4 = this.missingValue;
        if (l4 == l2) {
            throw new IllegalArgumentException("cannot accept missingValue");
        }
        K[] KArray = this.keys;
        long[] lArray = this.values;
        int n2 = lArray.length - 1;
        int n3 = Hashing.hash(k2, n2);
        while (l4 != (l3 = lArray[n3])) {
            if (Objects.equals(KArray[n3], k2)) {
                return l3;
            }
            ++n3;
            n3 &= n2;
        }
        KArray[n3] = k2;
        lArray[n3] = l2;
        if (++this.size > this.resizeThreshold) {
            this.increaseCapacity();
        }
        return l4;
    }

    @Override
    public boolean remove(Object object, Object object2) {
        return this.remove(object, (Long)object2);
    }

    public boolean remove(Object object, long l2) {
        long l3;
        long l4 = this.missingValue;
        K[] KArray = this.keys;
        long[] lArray = this.values;
        int n2 = lArray.length - 1;
        int n3 = Hashing.hash(object, n2);
        while (l4 != (l3 = lArray[n3])) {
            if (Objects.equals(KArray[n3], object)) {
                if (l2 != l3) break;
                KArray[n3] = null;
                lArray[n3] = l4;
                --this.size;
                this.compactChain(n3);
                return true;
            }
            ++n3;
            n3 &= n2;
        }
        return false;
    }

    @Override
    public Long remove(Object object) {
        return this.valueOrNull(this.removeKey(object));
    }

    public long removeKey(K k2) {
        long l2;
        Objects.requireNonNull(k2);
        long l3 = this.missingValue;
        K[] KArray = this.keys;
        long[] lArray = this.values;
        int n2 = lArray.length - 1;
        int n3 = Hashing.hash(k2, n2);
        while (l3 != (l2 = lArray[n3])) {
            if (Objects.equals(KArray[n3], k2)) {
                KArray[n3] = null;
                lArray[n3] = l3;
                --this.size;
                this.compactChain(n3);
                break;
            }
            ++n3;
            n3 &= n2;
        }
        return l2;
    }

    @Override
    public void clear() {
        if (this.size > 0) {
            Arrays.fill(this.keys, null);
            Arrays.fill(this.values, this.missingValue);
            this.size = 0;
        }
    }

    public void compact() {
        int n2 = (int)Math.round((double)this.size() * (1.0 / (double)this.loadFactor));
        this.rehash(BitUtil.findNextPositivePowerOfTwo(Math.max(8, n2)));
    }

    @Override
    public void putAll(Map<? extends K, ? extends Long> map) {
        for (Map.Entry<K, Long> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void putAll(Object2LongHashMap<? extends K> object2LongHashMap) {
        long l2 = object2LongHashMap.missingValue;
        K[] KArray = object2LongHashMap.keys;
        long[] lArray = object2LongHashMap.values;
        int n2 = lArray.length;
        int n3 = object2LongHashMap.size;
        for (int i2 = 0; n3 > 0 && i2 < n2; ++i2) {
            long l3 = lArray[i2];
            if (l2 == l3) continue;
            this.put(KArray[i2], l3);
            --n3;
        }
    }

    public KeySet keySet() {
        if (null == this.keySet) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    public ValueCollection values() {
        if (null == this.valueCollection) {
            this.valueCollection = new ValueCollection();
        }
        return this.valueCollection;
    }

    public EntrySet entrySet() {
        if (null == this.entrySet) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        EntryIterator entryIterator = new EntryIterator();
        entryIterator.reset();
        StringBuilder stringBuilder = new StringBuilder().append('{');
        while (true) {
            entryIterator.next();
            stringBuilder.append(entryIterator.getKey()).append('=').append(entryIterator.getLongValue());
            if (!entryIterator.hasNext()) {
                return stringBuilder.append('}').toString();
            }
            stringBuilder.append(',').append(' ');
        }
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Map)) {
            return false;
        }
        Map map = (Map)object;
        if (this.size != map.size()) {
            return false;
        }
        K[] KArray = this.keys;
        long[] lArray = this.values;
        long l2 = this.missingValue;
        long l3 = object instanceof Object2LongHashMap ? ((Object2LongHashMap)object).missingValue : l2;
        int n2 = lArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            long l4 = lArray[i2];
            if (l2 == l4) continue;
            Object v2 = map.get(KArray[i2]);
            if (!(v2 instanceof Long)) {
                return false;
            }
            long l5 = (Long)v2;
            if (l3 != l5 && l4 == l5) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int n2 = 0;
        K[] KArray = this.keys;
        long[] lArray = this.values;
        int n3 = lArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            long l2 = lArray[i2];
            if (this.missingValue == l2) continue;
            n2 += KArray[i2].hashCode() ^ Long.hashCode(l2);
        }
        return n2;
    }

    @Override
    public long replace(K k2, long l2) {
        long l3;
        Objects.requireNonNull(k2);
        long l4 = this.missingValue;
        if (l4 == l2) {
            throw new IllegalArgumentException("cannot accept missingValue");
        }
        K[] KArray = this.keys;
        long[] lArray = this.values;
        int n2 = lArray.length - 1;
        int n3 = Hashing.hash(k2, n2);
        while (l4 != (l3 = lArray[n3])) {
            if (Objects.equals(KArray[n3], k2)) {
                lArray[n3] = l2;
                return l3;
            }
            ++n3;
            n3 &= n2;
        }
        return l4;
    }

    @Override
    public boolean replace(K k2, long l2, long l3) {
        long l4;
        Objects.requireNonNull(k2);
        long l5 = this.missingValue;
        if (l5 == l3) {
            throw new IllegalArgumentException("cannot accept missingValue");
        }
        K[] KArray = this.keys;
        long[] lArray = this.values;
        int n2 = lArray.length - 1;
        int n3 = Hashing.hash(k2, n2);
        while (l5 != (l4 = lArray[n3])) {
            if (Objects.equals(KArray[n3], k2)) {
                if (l2 != l4) break;
                lArray[n3] = l3;
                return true;
            }
            ++n3;
            n3 &= n2;
        }
        return false;
    }

    public void replaceAllLong(ObjectLongToLongFunction<? super K> objectLongToLongFunction) {
        Objects.requireNonNull(objectLongToLongFunction);
        long l2 = this.missingValue;
        K[] KArray = this.keys;
        long[] lArray = this.values;
        int n2 = lArray.length;
        int n3 = this.size;
        for (int i2 = 0; n3 > 0 && i2 < n2; ++i2) {
            long l3 = lArray[i2];
            if (l2 == l3) continue;
            long l4 = objectLongToLongFunction.apply(KArray[i2], l3);
            if (l2 == l4) {
                throw new IllegalArgumentException("cannot accept missingValue");
            }
            lArray[i2] = l4;
            --n3;
        }
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super Long> biConsumer) {
        this.forEachLong(biConsumer::accept);
    }

    public void forEachLong(ObjLongConsumer<? super K> objLongConsumer) {
        Objects.requireNonNull(objLongConsumer);
        long l2 = this.missingValue;
        K[] KArray = this.keys;
        long[] lArray = this.values;
        int n2 = lArray.length;
        int n3 = this.size;
        for (int i2 = 0; n3 > 0 && i2 < n2; ++i2) {
            long l3 = lArray[i2];
            if (l2 == l3) continue;
            objLongConsumer.accept(KArray[i2], l3);
            --n3;
        }
    }

    private void increaseCapacity() {
        int n2 = this.values.length << 1;
        if (n2 < 0) {
            throw new IllegalStateException("max capacity reached at size=" + this.size);
        }
        this.rehash(n2);
    }

    private void rehash(int n2) {
        int n3 = n2 - 1;
        this.resizeThreshold = (int)((float)n2 * this.loadFactor);
        Object[] objectArray = new Object[n2];
        long[] lArray = new long[n2];
        Arrays.fill(lArray, this.missingValue);
        K[] KArray = this.keys;
        long[] lArray2 = this.values;
        int n4 = lArray2.length;
        for (int i2 = 0; i2 < n4; ++i2) {
            long l2 = lArray2[i2];
            if (this.missingValue == l2) continue;
            K k2 = KArray[i2];
            int n5 = Hashing.hash(k2, n3);
            while (this.missingValue != lArray[n5]) {
                ++n5;
                n5 &= n3;
            }
            objectArray[n5] = k2;
            lArray[n5] = l2;
        }
        this.keys = objectArray;
        this.values = lArray;
    }

    private void compactChain(int n2) {
        K[] KArray = this.keys;
        long[] lArray = this.values;
        int n3 = lArray.length - 1;
        int n4 = n2;
        while (true) {
            ++n4;
            long l2 = lArray[n4 &= n3];
            if (this.missingValue == l2) break;
            K k2 = KArray[n4];
            int n5 = Hashing.hash(k2, n3);
            if ((n4 >= n5 || n5 > n2 && n2 > n4) && (n5 > n2 || n2 > n4)) continue;
            KArray[n2] = k2;
            lArray[n2] = l2;
            KArray[n4] = null;
            lArray[n4] = this.missingValue;
            n2 = n4;
        }
    }

    private Long valueOrNull(long l2) {
        return l2 == this.missingValue ? null : Long.valueOf(l2);
    }

    public final class EntryIterator
    extends AbstractIterator<Map.Entry<K, Long>>
    implements Map.Entry<K, Long> {
        @Override
        public Map.Entry<K, Long> next() {
            this.findNext();
            if (Object2LongHashMap.this.shouldAvoidAllocation) {
                return this;
            }
            return this.allocateDuplicateEntry();
        }

        private Map.Entry<K, Long> allocateDuplicateEntry() {
            return new MapEntry(this.getKey(), this.getLongValue());
        }

        @Override
        public K getKey() {
            return Object2LongHashMap.this.keys[this.position()];
        }

        public long getLongValue() {
            return Object2LongHashMap.this.values[this.position()];
        }

        @Override
        public Long getValue() {
            return this.getLongValue();
        }

        @Override
        public Long setValue(Long l2) {
            return this.setValue((long)l2);
        }

        @Override
        public long setValue(long l2) {
            if (Object2LongHashMap.this.missingValue == l2) {
                throw new IllegalArgumentException("cannot accept missingValue");
            }
            int n2 = this.position();
            long l3 = Object2LongHashMap.this.values[n2];
            ((Object2LongHashMap)Object2LongHashMap.this).values[n2] = l2;
            return l3;
        }

        @Override
        public int hashCode() {
            return this.getKey().hashCode() ^ Long.hashCode(this.getLongValue());
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return Objects.equals(this.getKey(), entry.getKey()) && entry.getValue() instanceof Long && this.getLongValue() == ((Long)entry.getValue()).longValue();
        }

        public final class MapEntry
        implements Map.Entry<K, Long> {
            private final K k;
            private long v;

            public MapEntry(K k2, long l2) {
                this.k = k2;
                this.v = l2;
            }

            @Override
            public K getKey() {
                return this.k;
            }

            @Override
            public Long getValue() {
                return this.v;
            }

            @Override
            public Long setValue(Long l2) {
                Long l3 = Object2LongHashMap.this.put(this.k, l2);
                this.v = l2;
                return l3;
            }

            @Override
            public int hashCode() {
                return this.getKey().hashCode() ^ Long.hashCode(this.v);
            }

            @Override
            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)object;
                return Objects.equals(this.getKey(), entry.getKey()) && entry.getValue() instanceof Long && this.v == (Long)entry.getValue();
            }

            public String toString() {
                return this.k + "=" + this.v;
            }
        }
    }

    public final class KeyIterator
    extends AbstractIterator<K> {
        @Override
        public K next() {
            this.findNext();
            return Object2LongHashMap.this.keys[this.position()];
        }
    }

    public final class ValueIterator
    extends AbstractIterator<Long> {
        @Override
        public Long next() {
            return this.nextLong();
        }

        public long nextLong() {
            this.findNext();
            return Object2LongHashMap.this.values[this.position()];
        }
    }

    abstract class AbstractIterator<T>
    implements Iterator<T> {
        private int posCounter;
        private int stopCounter;
        private int remaining;
        private boolean isPositionValid = false;

        AbstractIterator() {
        }

        protected final int position() {
            return this.posCounter & Object2LongHashMap.this.values.length - 1;
        }

        @Override
        public boolean hasNext() {
            return this.remaining > 0;
        }

        protected final void findNext() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            long l2 = Object2LongHashMap.this.missingValue;
            long[] lArray = Object2LongHashMap.this.values;
            int n2 = lArray.length - 1;
            for (int i2 = this.posCounter - 1; i2 >= this.stopCounter; --i2) {
                int n3 = i2 & n2;
                if (l2 == lArray[n3]) continue;
                this.posCounter = i2;
                this.isPositionValid = true;
                --this.remaining;
                return;
            }
            this.isPositionValid = false;
            throw new IllegalStateException();
        }

        @Override
        public abstract T next();

        @Override
        public void remove() {
            if (!this.isPositionValid) {
                throw new IllegalStateException();
            }
            int n2 = this.position();
            ((Object2LongHashMap)Object2LongHashMap.this).values[n2] = Object2LongHashMap.this.missingValue;
            ((Object2LongHashMap)Object2LongHashMap.this).keys[n2] = null;
            --Object2LongHashMap.this.size;
            Object2LongHashMap.this.compactChain(n2);
            this.isPositionValid = false;
        }

        final void reset() {
            int n2;
            this.remaining = Object2LongHashMap.this.size;
            long[] lArray = Object2LongHashMap.this.values;
            int n3 = n2 = lArray.length;
            if (Object2LongHashMap.this.missingValue != lArray[n2 - 1]) {
                for (n3 = 0; n3 < n2 && Object2LongHashMap.this.missingValue != lArray[n3]; ++n3) {
                }
            }
            this.stopCounter = n3;
            this.posCounter = n3 + n2;
            this.isPositionValid = false;
        }
    }

    public final class EntrySet
    extends AbstractSet<Map.Entry<K, Long>> {
        private final EntryIterator entryIterator;

        public EntrySet() {
            this.entryIterator = Object2LongHashMap.this.shouldAvoidAllocation ? new EntryIterator() : null;
        }

        public EntryIterator iterator() {
            EntryIterator entryIterator = this.entryIterator;
            if (null == entryIterator) {
                entryIterator = new EntryIterator();
            }
            entryIterator.reset();
            return entryIterator;
        }

        @Override
        public int size() {
            return Object2LongHashMap.this.size();
        }

        @Override
        public void clear() {
            Object2LongHashMap.this.clear();
        }

        @Override
        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Long l2 = Object2LongHashMap.this.get(entry.getKey());
            return l2 != null && l2.equals(entry.getValue());
        }

        public boolean removeIfLong(ObjLongPredicate<? super K> objLongPredicate) {
            boolean bl2 = false;
            EntryIterator entryIterator = this.iterator();
            while (entryIterator.hasNext()) {
                entryIterator.findNext();
                if (!objLongPredicate.test(entryIterator.getKey(), entryIterator.getLongValue())) continue;
                entryIterator.remove();
                bl2 = true;
            }
            return bl2;
        }

        @Override
        public Object[] toArray() {
            return this.toArray(new Object[this.size()]);
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            T[] TArray2 = TArray.length >= Object2LongHashMap.this.size ? TArray : (Object[])Array.newInstance(TArray.getClass().getComponentType(), Object2LongHashMap.this.size);
            EntryIterator entryIterator = this.iterator();
            for (int i2 = 0; i2 < TArray2.length; ++i2) {
                if (!entryIterator.hasNext()) {
                    TArray2[i2] = null;
                    break;
                }
                entryIterator.next();
                TArray2[i2] = entryIterator.allocateDuplicateEntry();
            }
            return TArray2;
        }
    }

    public final class ValueCollection
    extends AbstractCollection<Long> {
        private final ValueIterator valueIterator;

        public ValueCollection() {
            this.valueIterator = Object2LongHashMap.this.shouldAvoidAllocation ? new ValueIterator() : null;
        }

        public ValueIterator iterator() {
            ValueIterator valueIterator = this.valueIterator;
            if (null == valueIterator) {
                valueIterator = new ValueIterator();
            }
            valueIterator.reset();
            return valueIterator;
        }

        @Override
        public int size() {
            return Object2LongHashMap.this.size();
        }

        @Override
        public boolean contains(Object object) {
            return Object2LongHashMap.this.containsValue(object);
        }

        public boolean contains(long l2) {
            return Object2LongHashMap.this.containsValue(l2);
        }

        @Override
        public void clear() {
            Object2LongHashMap.this.clear();
        }

        public boolean removeIfLong(LongPredicate longPredicate) {
            boolean bl2 = false;
            ValueIterator valueIterator = this.iterator();
            while (valueIterator.hasNext()) {
                if (!longPredicate.test(valueIterator.nextLong())) continue;
                valueIterator.remove();
                bl2 = true;
            }
            return bl2;
        }
    }

    public final class KeySet
    extends AbstractSet<K> {
        private final KeyIterator keyIterator;

        public KeySet() {
            this.keyIterator = Object2LongHashMap.this.shouldAvoidAllocation ? new KeyIterator() : null;
        }

        public KeyIterator iterator() {
            KeyIterator keyIterator = this.keyIterator;
            if (null == keyIterator) {
                keyIterator = new KeyIterator();
            }
            keyIterator.reset();
            return keyIterator;
        }

        @Override
        public int size() {
            return Object2LongHashMap.this.size();
        }

        @Override
        public boolean contains(Object object) {
            return Object2LongHashMap.this.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            return Object2LongHashMap.this.missingValue != Object2LongHashMap.this.removeKey(object);
        }

        @Override
        public void clear() {
            Object2LongHashMap.this.clear();
        }
    }
}

