/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.collections;

import java.util.function.Consumer;
import java.util.function.IntFunction;

public final class IntLruCache<E>
implements AutoCloseable {
    private final int capacity;
    private final IntFunction<E> factory;
    private final Consumer<E> closer;
    private final int[] keys;
    private final Object[] values;
    private int size;

    public IntLruCache(int n2, IntFunction<E> intFunction, Consumer<E> consumer) {
        this.capacity = n2;
        this.factory = intFunction;
        this.closer = consumer;
        this.keys = new int[n2];
        this.values = new Object[n2];
        this.size = 0;
    }

    public E lookup(int n2) {
        int n3 = this.size;
        int[] nArray = this.keys;
        Object[] objectArray = this.values;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (n2 != nArray[i2]) continue;
            Object object = objectArray[i2];
            this.makeMostRecent(n2, object, i2);
            return (E)object;
        }
        E e2 = this.factory.apply(n2);
        if (e2 != null) {
            if (this.capacity == n3) {
                this.closer.accept(objectArray[n3 - 1]);
            } else {
                this.size = ++n3;
            }
            this.makeMostRecent(n2, e2, n3 - 1);
        }
        return e2;
    }

    private void makeMostRecent(int n2, Object object, int n3) {
        int[] nArray = this.keys;
        Object[] objectArray = this.values;
        for (int i2 = n3; i2 > 0; --i2) {
            nArray[i2] = nArray[i2 - 1];
            objectArray[i2] = objectArray[i2 - 1];
        }
        nArray[0] = n2;
        objectArray[0] = object;
    }

    public int capacity() {
        return this.capacity;
    }

    @Override
    public void close() {
        Consumer<E> consumer = this.closer;
        Object[] objectArray = this.values;
        int n2 = this.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            consumer.accept(objectArray[i2]);
        }
    }
}

