/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.collections;

import java.util.AbstractQueue;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import org.agrona.BitUtil;

public class IntArrayQueue
extends AbstractQueue<Integer> {
    public static final int DEFAULT_NULL_VALUE = Integer.MIN_VALUE;
    public static final int MIN_CAPACITY = 8;
    private final boolean shouldAvoidAllocation;
    private int head;
    private int tail;
    private final int nullValue;
    private int[] elements;
    private IntIterator iterator;

    public IntArrayQueue() {
        this(8, Integer.MIN_VALUE, true);
    }

    public IntArrayQueue(int n2) {
        this(8, n2, true);
    }

    public IntArrayQueue(int n2, int n3) {
        this(n2, n3, true);
    }

    public IntArrayQueue(int n2, int n3, boolean bl2) {
        this.nullValue = n3;
        this.shouldAvoidAllocation = bl2;
        if (n2 < 8) {
            throw new IllegalArgumentException("initial capacity < MIN_INITIAL_CAPACITY : " + n2);
        }
        int n4 = BitUtil.findNextPositivePowerOfTwo(n2);
        if (n4 < 8) {
            throw new IllegalArgumentException("invalid initial capacity: " + n2);
        }
        this.elements = new int[n4];
        Arrays.fill(this.elements, n3);
    }

    public int nullValue() {
        return this.nullValue;
    }

    public int capacity() {
        return this.elements.length;
    }

    @Override
    public int size() {
        return this.tail - this.head & this.elements.length - 1;
    }

    @Override
    public boolean isEmpty() {
        return this.head == this.tail;
    }

    @Override
    public void clear() {
        if (this.head != this.tail) {
            Arrays.fill(this.elements, this.nullValue);
            this.head = 0;
            this.tail = 0;
        }
    }

    @Override
    public boolean offer(Integer n2) {
        return this.offerInt(n2);
    }

    public boolean offerInt(int n2) {
        if (this.nullValue == n2) {
            throw new NullPointerException();
        }
        this.elements[this.tail] = n2;
        this.tail = this.tail + 1 & this.elements.length - 1;
        if (this.tail == this.head) {
            this.increaseCapacity();
        }
        return true;
    }

    @Override
    public boolean add(Integer n2) {
        return this.offerInt(n2);
    }

    public boolean addInt(int n2) {
        return this.offerInt(n2);
    }

    @Override
    public Integer peek() {
        int n2 = this.elements[this.head];
        return n2 == this.nullValue ? null : Integer.valueOf(n2);
    }

    public int peekInt() {
        return this.elements[this.head];
    }

    @Override
    public Integer poll() {
        int n2 = this.pollInt();
        return n2 == this.nullValue ? null : Integer.valueOf(n2);
    }

    public int pollInt() {
        int n2 = this.elements[this.head];
        if (this.nullValue == n2) {
            return this.nullValue;
        }
        this.elements[this.head] = this.nullValue;
        this.head = this.head + 1 & this.elements.length - 1;
        return n2;
    }

    @Override
    public Integer remove() {
        int n2 = this.pollInt();
        if (this.nullValue == n2) {
            throw new NoSuchElementException();
        }
        return n2;
    }

    @Override
    public Integer element() {
        int n2 = this.elements[this.head];
        if (this.nullValue == n2) {
            throw new NoSuchElementException();
        }
        return n2;
    }

    public int elementInt() {
        int n2 = this.elements[this.head];
        if (this.nullValue == n2) {
            throw new NoSuchElementException();
        }
        return n2;
    }

    public int removeInt() {
        int n2 = this.pollInt();
        if (this.nullValue == n2) {
            throw new NoSuchElementException();
        }
        return n2;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        int n2 = this.head;
        while (n2 != this.tail) {
            stringBuilder.append(this.elements[n2]).append(", ");
            n2 = n2 + 1 & this.elements.length - 1;
        }
        if (stringBuilder.length() > 1) {
            stringBuilder.setLength(stringBuilder.length() - 2);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public void forEach(Consumer<? super Integer> consumer) {
        int n2 = this.head;
        while (n2 != this.tail) {
            consumer.accept((Integer)this.elements[n2]);
            n2 = n2 + 1 & this.elements.length - 1;
        }
    }

    public void forEachInt(IntConsumer intConsumer) {
        int n2 = this.head;
        while (n2 != this.tail) {
            intConsumer.accept(this.elements[n2]);
            n2 = n2 + 1 & this.elements.length - 1;
        }
    }

    public IntIterator iterator() {
        IntIterator intIterator = this.iterator;
        if (null == intIterator) {
            intIterator = new IntIterator();
            if (this.shouldAvoidAllocation) {
                this.iterator = intIterator;
            }
        }
        return intIterator.reset();
    }

    private void increaseCapacity() {
        int n2 = this.head;
        int n3 = this.elements.length;
        int n4 = n3 - n2;
        int n5 = n3 << 1;
        if (n5 < 8) {
            throw new IllegalStateException("max capacity reached");
        }
        int[] nArray = new int[n5];
        Arrays.fill(nArray, n3, n5, this.nullValue);
        System.arraycopy(this.elements, n2, nArray, 0, n4);
        System.arraycopy(this.elements, 0, nArray, n4, n2);
        this.elements = nArray;
        this.head = 0;
        this.tail = n3;
    }

    public final class IntIterator
    implements Iterator<Integer> {
        private int index;

        IntIterator reset() {
            this.index = IntArrayQueue.this.head;
            return this;
        }

        @Override
        public boolean hasNext() {
            return this.index != IntArrayQueue.this.tail;
        }

        @Override
        public Integer next() {
            return this.nextValue();
        }

        public int nextValue() {
            if (this.index == IntArrayQueue.this.tail) {
                throw new NoSuchElementException();
            }
            int n2 = IntArrayQueue.this.elements[this.index];
            this.index = this.index + 1 & IntArrayQueue.this.elements.length - 1;
            return n2;
        }
    }
}

