/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.collections;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.IntPredicate;
import java.util.stream.IntStream;

public class IntArrayList
extends AbstractList<Integer>
implements List<Integer>,
RandomAccess {
    public static final int DEFAULT_NULL_VALUE = Integer.MIN_VALUE;
    public static final int INITIAL_CAPACITY = 10;
    private final int nullValue;
    private int size = 0;
    private int[] elements;

    public IntArrayList() {
        this(10, Integer.MIN_VALUE);
    }

    public IntArrayList(int n2, int n3) {
        this.nullValue = n3;
        this.elements = new int[Math.max(n2, 10)];
    }

    public IntArrayList(int[] nArray, int n2, int n3) {
        this.wrap(nArray, n2);
        this.nullValue = n3;
    }

    public void wrap(int[] nArray, int n2) {
        if (n2 < 0 || n2 > nArray.length) {
            throw new IllegalArgumentException("illegal initial size " + n2 + " for array length of " + nArray.length);
        }
        this.elements = nArray;
        this.size = n2;
    }

    public int nullValue() {
        return this.nullValue;
    }

    @Override
    public int size() {
        return this.size;
    }

    public int capacity() {
        return this.elements.length;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    public void trimToSize() {
        if (this.elements.length != this.size && this.elements.length > 10) {
            this.elements = Arrays.copyOf(this.elements, Math.max(10, this.size));
        }
    }

    @Override
    public Integer get(int n2) {
        int n3 = this.getInt(n2);
        return this.nullValue == n3 ? null : Integer.valueOf(n3);
    }

    public int getInt(int n2) {
        this.checkIndex(n2);
        return this.elements[n2];
    }

    @Override
    public boolean add(Integer n2) {
        return this.addInt(null == n2 ? this.nullValue : n2);
    }

    public boolean addInt(int n2) {
        this.ensureCapacityPrivate(this.size + 1);
        this.elements[this.size] = n2;
        ++this.size;
        return true;
    }

    @Override
    public void add(int n2, Integer n3) {
        this.addInt(n2, null == n3 ? this.nullValue : n3);
    }

    public void addInt(int n2, int n3) {
        this.checkIndexForAdd(n2);
        int n4 = this.size + 1;
        this.ensureCapacityPrivate(n4);
        if (n2 < this.size) {
            System.arraycopy(this.elements, n2, this.elements, n2 + 1, this.size - n2);
        }
        this.elements[n2] = n3;
        ++this.size;
    }

    @Override
    public Integer set(int n2, Integer n3) {
        int n4 = this.setInt(n2, null == n3 ? this.nullValue : n3);
        return this.nullValue == n4 ? null : Integer.valueOf(n4);
    }

    public int setInt(int n2, int n3) {
        this.checkIndex(n2);
        int n4 = this.elements[n2];
        this.elements[n2] = n3;
        return n4;
    }

    @Override
    public boolean contains(Object object) {
        return this.containsInt(null == object ? this.nullValue : (Integer)object);
    }

    public boolean containsInt(int n2) {
        return -1 != this.indexOf(n2);
    }

    public int indexOf(int n2) {
        int[] nArray = this.elements;
        int n3 = this.size;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (n2 != nArray[i2]) continue;
            return i2;
        }
        return -1;
    }

    public int lastIndexOf(int n2) {
        int[] nArray = this.elements;
        for (int i2 = this.size - 1; i2 >= 0; --i2) {
            if (n2 != nArray[i2]) continue;
            return i2;
        }
        return -1;
    }

    public boolean addAll(IntArrayList intArrayList) {
        int n2 = intArrayList.size;
        if (n2 > 0) {
            this.ensureCapacityPrivate(this.size + n2);
            System.arraycopy(intArrayList.elements, 0, this.elements, this.size, n2);
            this.size += n2;
            return true;
        }
        return false;
    }

    public boolean addAll(int n2, IntArrayList intArrayList) {
        this.checkIndexForAdd(n2);
        int n3 = intArrayList.size;
        if (n3 > 0) {
            int n4 = this.size;
            this.ensureCapacityPrivate(n4 + n3);
            int[] nArray = this.elements;
            for (int i2 = n4 - 1; i2 >= n2; --i2) {
                nArray[i2 + n3] = nArray[i2];
            }
            System.arraycopy(intArrayList.elements, 0, nArray, n2, n3);
            this.size += n3;
            return true;
        }
        return false;
    }

    public boolean containsAll(IntArrayList intArrayList) {
        int[] nArray = intArrayList.elements;
        int n2 = intArrayList.nullValue;
        boolean bl2 = this.contains(null);
        int n3 = intArrayList.size;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = nArray[i2];
            if (this.containsInt(n4) || bl2 && n2 == n4) continue;
            return false;
        }
        return true;
    }

    public boolean retainAll(IntArrayList intArrayList) {
        int[] nArray = this.elements;
        int n2 = this.size;
        if (n2 > 0) {
            if (intArrayList.isEmpty()) {
                this.size = 0;
                return true;
            }
            int n3 = this.nullValue;
            boolean bl2 = intArrayList.contains(null);
            int[] nArray2 = null;
            int n4 = -1;
            for (int i2 = 0; i2 < n2; ++i2) {
                int n5 = nArray[i2];
                if (!(intArrayList.containsInt(n5) || bl2 && n3 == n5)) {
                    if (null != nArray2) continue;
                    nArray2 = Arrays.copyOf(nArray, n2);
                    n4 = i2 - 1;
                    continue;
                }
                if (null == nArray2) continue;
                nArray2[++n4] = n5;
            }
            if (null != nArray2) {
                this.elements = nArray2;
                this.size = n4 + 1;
                return true;
            }
        }
        return false;
    }

    public boolean removeAll(IntArrayList intArrayList) {
        int[] nArray = this.elements;
        int n2 = this.size;
        if (n2 > 0 && !intArrayList.isEmpty()) {
            int n3 = this.nullValue;
            boolean bl2 = intArrayList.contains(null);
            int[] nArray2 = null;
            int n4 = -1;
            for (int i2 = 0; i2 < n2; ++i2) {
                int n5 = nArray[i2];
                if (intArrayList.containsInt(n5) || bl2 && n3 == n5) {
                    if (null != nArray2) continue;
                    nArray2 = Arrays.copyOf(nArray, n2);
                    n4 = i2 - 1;
                    continue;
                }
                if (null == nArray2) continue;
                nArray2[++n4] = n5;
            }
            if (null != nArray2) {
                this.elements = nArray2;
                this.size = n4 + 1;
                return true;
            }
        }
        return false;
    }

    public boolean removeIfInt(IntPredicate intPredicate) {
        Objects.requireNonNull(intPredicate);
        int[] nArray = this.elements;
        int n2 = this.size;
        if (n2 > 0) {
            int[] nArray2 = null;
            int n3 = -1;
            for (int i2 = 0; i2 < n2; ++i2) {
                int n4 = nArray[i2];
                if (intPredicate.test(n4)) {
                    if (null != nArray2) continue;
                    nArray2 = Arrays.copyOf(nArray, n2);
                    n3 = i2 - 1;
                    continue;
                }
                if (null == nArray2) continue;
                nArray2[++n3] = n4;
            }
            if (null != nArray2) {
                this.elements = nArray2;
                this.size = n3 + 1;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean remove(Object object) {
        return this.removeInt(null == object ? this.nullValue : (Integer)object);
    }

    @Override
    public Integer remove(int n2) {
        int n3 = this.removeAt(n2);
        return this.nullValue == n3 ? null : Integer.valueOf(n3);
    }

    public int removeAt(int n2) {
        this.checkIndex(n2);
        int n3 = this.elements[n2];
        int n4 = this.size - n2 - 1;
        if (n4 > 0) {
            System.arraycopy(this.elements, n2 + 1, this.elements, n2, n4);
        }
        --this.size;
        return n3;
    }

    public int fastUnorderedRemove(int n2) {
        this.checkIndex(n2);
        int n3 = this.elements[n2];
        this.elements[n2] = this.elements[--this.size];
        return n3;
    }

    public boolean removeInt(int n2) {
        int n3 = this.indexOf(n2);
        if (-1 != n3) {
            this.removeAt(n3);
            return true;
        }
        return false;
    }

    public boolean fastUnorderedRemoveInt(int n2) {
        int n3 = this.indexOf(n2);
        if (-1 != n3) {
            this.elements[n3] = this.elements[--this.size];
            return true;
        }
        return false;
    }

    public void pushInt(int n2) {
        this.ensureCapacityPrivate(this.size + 1);
        this.elements[this.size] = n2;
        ++this.size;
    }

    public int popInt() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.elements[--this.size];
    }

    public void forEachOrderedInt(IntConsumer intConsumer) {
        int[] nArray = this.elements;
        int n2 = this.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            intConsumer.accept(nArray[i2]);
        }
    }

    public IntStream intStream() {
        return Arrays.stream(this.elements, 0, this.size);
    }

    public int[] toIntArray() {
        return Arrays.copyOf(this.elements, this.size);
    }

    public int[] toIntArray(int[] nArray) {
        if (nArray.length == this.size) {
            System.arraycopy(this.elements, 0, nArray, 0, nArray.length);
            return nArray;
        }
        return Arrays.copyOf(this.elements, this.size);
    }

    public void ensureCapacity(int n2) {
        this.ensureCapacityPrivate(Math.max(n2, 10));
    }

    public boolean equals(IntArrayList intArrayList) {
        if (intArrayList == this) {
            return true;
        }
        boolean bl2 = false;
        int n2 = this.size;
        if (n2 == intArrayList.size) {
            bl2 = true;
            int[] nArray = this.elements;
            int[] nArray2 = intArrayList.elements;
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = nArray[i2];
                int n4 = nArray2[i2];
                if (n3 == n4 || n3 == this.nullValue && n4 == intArrayList.nullValue) continue;
                bl2 = false;
                break;
            }
        }
        return bl2;
    }

    @Override
    public boolean equals(Object object) {
        List list;
        if (object == this) {
            return true;
        }
        boolean bl2 = false;
        if (object instanceof IntArrayList) {
            return this.equals((IntArrayList)object);
        }
        if (object instanceof List && this.size == (list = (List)object).size()) {
            bl2 = true;
            int n2 = 0;
            for (Object e2 : list) {
                Integer n3;
                Integer n4;
                if ((null == e2 || e2 instanceof Integer) && Objects.equals(n4 = this.get(n2++), n3 = (Integer)e2)) continue;
                bl2 = false;
                break;
            }
        }
        return bl2;
    }

    @Override
    public int hashCode() {
        int n2 = 1;
        int n3 = this.nullValue;
        int[] nArray = this.elements;
        int n4 = this.size;
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = nArray[i2];
            n2 = 31 * n2 + (n3 == n5 ? 0 : Integer.hashCode(n5));
        }
        return n2;
    }

    @Override
    public void forEach(Consumer<? super Integer> consumer) {
        Objects.requireNonNull(consumer);
        int n2 = this.nullValue;
        int[] nArray = this.elements;
        int n3 = this.size;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = nArray[i2];
            consumer.accept(n2 != n4 ? Integer.valueOf(n4) : null);
        }
    }

    public void forEachInt(IntConsumer intConsumer) {
        Objects.requireNonNull(intConsumer);
        int[] nArray = this.elements;
        int n2 = this.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            intConsumer.accept(nArray[i2]);
        }
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        int n2 = this.nullValue;
        int[] nArray = this.elements;
        int n3 = this.size;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = nArray[i2];
            stringBuilder.append(n4 != n2 ? Integer.valueOf(n4) : null).append(", ");
        }
        if (stringBuilder.length() > 1) {
            stringBuilder.setLength(stringBuilder.length() - 2);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private void ensureCapacityPrivate(int n2) {
        int n3 = this.elements.length;
        if (n2 > n3) {
            int n4;
            if (n2 > 0x7FFFFFF7) {
                throw new IllegalStateException("max capacity: 2147483639");
            }
            int n5 = n4 = n3 > 10 ? n3 : 10;
            while (n4 < n2) {
                if ((n4 += n4 >> 1) >= 0 && n4 < 0x7FFFFFF7) continue;
                n4 = 0x7FFFFFF7;
            }
            int[] nArray = new int[n4];
            System.arraycopy(this.elements, 0, nArray, 0, n3);
            this.elements = nArray;
        }
    }

    private void checkIndex(int n2) {
        if (n2 >= this.size || n2 < 0) {
            throw new IndexOutOfBoundsException("index=" + n2 + " size=" + this.size);
        }
    }

    private void checkIndexForAdd(int n2) {
        if (n2 > this.size || n2 < 0) {
            throw new IndexOutOfBoundsException("index=" + n2 + " size=" + this.size);
        }
    }
}

