/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.collections;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import org.agrona.BitUtil;

public final class CollectionUtil {
    private CollectionUtil() {
    }

    public static <K, V> V getOrDefault(Map<K, V> map, K k2, Function<K, V> function) {
        V v2 = map.get(k2);
        if (v2 == null) {
            v2 = function.apply(k2);
            map.put(k2, v2);
        }
        return v2;
    }

    public static <V> int sum(List<V> list, ToIntFunction<V> toIntFunction) {
        int n2 = 0;
        int n3 = list.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            V v2 = list.get(i2);
            n2 += toIntFunction.applyAsInt(v2);
        }
        return n2;
    }

    public static void validateLoadFactor(float f2) {
        if (f2 < 0.1f || f2 > 0.9f) {
            throw new IllegalArgumentException("load factor must be in the range of 0.1 to 0.9: " + f2);
        }
    }

    public static void validatePositivePowerOfTwo(int n2) {
        if (!BitUtil.isPowerOfTwo(n2)) {
            throw new IllegalArgumentException("value must be a positive power of two: " + n2);
        }
    }

    public static <T> int removeIf(List<T> list, Predicate<T> predicate) {
        int n2 = list.size();
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            T t2 = list.get(n4);
            if (predicate.test(t2)) {
                list.remove(n4);
                ++n3;
                --n2;
                continue;
            }
            ++n4;
        }
        return n3;
    }
}

