/*
 * Decompiled with CFR 0.152.
 */
package org.agrona;

import java.util.Collection;
import org.agrona.ErrorHandler;
import org.agrona.LangUtil;

public final class CloseHelper {
    private CloseHelper() {
    }

    public static void quietClose(AutoCloseable autoCloseable) {
        if (null != autoCloseable) {
            try {
                autoCloseable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void quietCloseAll(Collection<? extends AutoCloseable> collection) {
        if (null != collection) {
            for (AutoCloseable autoCloseable : collection) {
                if (null == autoCloseable) continue;
                try {
                    autoCloseable.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void quietCloseAll(AutoCloseable ... autoCloseableArray) {
        if (null != autoCloseableArray) {
            for (AutoCloseable autoCloseable : autoCloseableArray) {
                if (null == autoCloseable) continue;
                try {
                    autoCloseable.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static void close(AutoCloseable autoCloseable) {
        if (null != autoCloseable) {
            try {
                autoCloseable.close();
            }
            catch (Exception exception) {
                LangUtil.rethrowUnchecked(exception);
            }
        }
    }

    public static void closeAll(Collection<? extends AutoCloseable> collection) {
        if (null != collection) {
            Exception exception = null;
            for (AutoCloseable autoCloseable : collection) {
                if (null == autoCloseable) continue;
                try {
                    autoCloseable.close();
                }
                catch (Exception exception2) {
                    if (null == exception) {
                        exception = exception2;
                        continue;
                    }
                    exception.addSuppressed(exception2);
                }
            }
            if (null != exception) {
                LangUtil.rethrowUnchecked(exception);
            }
        }
    }

    public static void closeAll(AutoCloseable ... autoCloseableArray) {
        if (null != autoCloseableArray) {
            Exception exception = null;
            for (AutoCloseable autoCloseable : autoCloseableArray) {
                if (null == autoCloseable) continue;
                try {
                    autoCloseable.close();
                }
                catch (Exception exception2) {
                    if (exception == null) {
                        exception = exception2;
                        continue;
                    }
                    exception.addSuppressed(exception2);
                }
            }
            if (null != exception) {
                LangUtil.rethrowUnchecked(exception);
            }
        }
    }

    public static void close(ErrorHandler errorHandler, AutoCloseable autoCloseable) {
        if (null != autoCloseable) {
            try {
                autoCloseable.close();
            }
            catch (Exception exception) {
                if (null == errorHandler) {
                    NullPointerException nullPointerException = new NullPointerException("errorHandler is null");
                    nullPointerException.addSuppressed(exception);
                    throw nullPointerException;
                }
                errorHandler.onError(exception);
            }
        }
    }

    public static void closeAll(ErrorHandler errorHandler, Collection<? extends AutoCloseable> collection) {
        if (null != collection) {
            Throwable throwable = null;
            for (AutoCloseable autoCloseable : collection) {
                if (null == autoCloseable) continue;
                try {
                    autoCloseable.close();
                }
                catch (Exception exception) {
                    if (null == errorHandler) {
                        if (null == throwable) {
                            throwable = new NullPointerException("errorHandler is null");
                        }
                        throwable.addSuppressed(exception);
                        continue;
                    }
                    errorHandler.onError(exception);
                }
            }
            if (null != throwable) {
                LangUtil.rethrowUnchecked(throwable);
            }
        }
    }

    public static void closeAll(ErrorHandler errorHandler, AutoCloseable ... autoCloseableArray) {
        if (null != autoCloseableArray) {
            Throwable throwable = null;
            for (AutoCloseable autoCloseable : autoCloseableArray) {
                if (null == autoCloseable) continue;
                try {
                    autoCloseable.close();
                }
                catch (Exception exception) {
                    if (null == errorHandler) {
                        if (null == throwable) {
                            throwable = new NullPointerException("errorHandler is null");
                        }
                        throwable.addSuppressed(exception);
                        continue;
                    }
                    errorHandler.onError(exception);
                }
            }
            if (null != throwable) {
                LangUtil.rethrowUnchecked(throwable);
            }
        }
    }
}

