/*
 * Decompiled with CFR 0.152.
 */
package org.agrona;

import java.nio.charset.StandardCharsets;
import java.util.concurrent.ThreadLocalRandom;

public final class BitUtil {
    public static final int SIZE_OF_BYTE = 1;
    public static final int SIZE_OF_BOOLEAN = 1;
    public static final int SIZE_OF_CHAR = 2;
    public static final int SIZE_OF_SHORT = 2;
    public static final int SIZE_OF_INT = 4;
    public static final int SIZE_OF_FLOAT = 4;
    public static final int SIZE_OF_LONG = 8;
    public static final int SIZE_OF_DOUBLE = 8;
    public static final int CACHE_LINE_LENGTH = 64;
    private static final byte[] HEX_DIGIT_TABLE = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    private static final byte[] FROM_HEX_DIGIT_TABLE = new byte[128];
    private static final int LAST_DIGIT_MASK = 1;

    private BitUtil() {
    }

    public static int findNextPositivePowerOfTwo(int n2) {
        return 1 << 32 - Integer.numberOfLeadingZeros(n2 - 1);
    }

    public static long findNextPositivePowerOfTwo(long l2) {
        return 1L << 64 - Long.numberOfLeadingZeros(l2 - 1L);
    }

    public static int align(int n2, int n3) {
        return n2 + (n3 - 1) & -n3;
    }

    public static long align(long l2, long l3) {
        return l2 + (l3 - 1L) & -l3;
    }

    public static byte[] fromHexByteArray(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length >> 1];
        for (int i2 = 1; i2 < byArray.length; i2 += 2) {
            int n2 = FROM_HEX_DIGIT_TABLE[byArray[i2 - 1]] << 4;
            byte by2 = FROM_HEX_DIGIT_TABLE[byArray[i2]];
            byArray2[i2 - 1 >> 1] = (byte)(n2 | by2);
        }
        return byArray2;
    }

    public static byte[] toHexByteArray(byte[] byArray) {
        return BitUtil.toHexByteArray(byArray, 0, byArray.length);
    }

    public static byte[] toHexByteArray(byte[] byArray, int n2, int n3) {
        byte[] byArray2 = new byte[n3 << 1];
        for (int i2 = 0; i2 < n3 << 1; i2 += 2) {
            byte by2 = byArray[n2 + (i2 >> 1)];
            byArray2[i2] = HEX_DIGIT_TABLE[by2 >> 4 & 0xF];
            byArray2[i2 + 1] = HEX_DIGIT_TABLE[by2 & 0xF];
        }
        return byArray2;
    }

    public static byte[] toHexByteArray(CharSequence charSequence, int n2, int n3) {
        byte[] byArray = new byte[n3 << 1];
        for (int i2 = 0; i2 < n3 << 1; i2 += 2) {
            byte by2 = (byte)charSequence.charAt(n2 + (i2 >> 1));
            byArray[i2] = HEX_DIGIT_TABLE[by2 >> 4 & 0xF];
            byArray[i2 + 1] = HEX_DIGIT_TABLE[by2 & 0xF];
        }
        return byArray;
    }

    public static byte[] fromHex(String string) {
        int n2 = string.length();
        byte[] byArray = new byte[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            byArray[i2] = (byte)string.charAt(i2);
        }
        return BitUtil.fromHexByteArray(byArray);
    }

    public static String toHex(byte[] byArray, int n2, int n3) {
        return new String(BitUtil.toHexByteArray(byArray, n2, n3), StandardCharsets.US_ASCII);
    }

    public static String toHex(byte[] byArray) {
        return new String(BitUtil.toHexByteArray(byArray), StandardCharsets.US_ASCII);
    }

    public static boolean isEven(int n2) {
        return (n2 & 1) == 0;
    }

    public static boolean isEven(long l2) {
        return (l2 & 1L) == 0L;
    }

    public static boolean isPowerOfTwo(int n2) {
        return n2 > 0 && (n2 & ~n2 + 1) == n2;
    }

    public static boolean isPowerOfTwo(long l2) {
        return l2 > 0L && (l2 & (l2 ^ 0xFFFFFFFFFFFFFFFFL) + 1L) == l2;
    }

    public static int next(int n2, int n3) {
        int n4 = n2 + 1;
        if (n4 == n3) {
            n4 = 0;
        }
        return n4;
    }

    public static int previous(int n2, int n3) {
        if (0 == n2) {
            return n3 - 1;
        }
        return n2 - 1;
    }

    public static int calculateShiftForScale(int n2) {
        if (4 == n2) {
            return 2;
        }
        if (8 == n2) {
            return 3;
        }
        throw new IllegalArgumentException("unknown pointer size for scale=" + n2);
    }

    public static int generateRandomisedId() {
        return ThreadLocalRandom.current().nextInt();
    }

    public static boolean isAligned(long l2, int n2) {
        if (!BitUtil.isPowerOfTwo(n2)) {
            throw new IllegalArgumentException("alignment must be a power of 2: alignment=" + n2);
        }
        return (l2 & (long)(n2 - 1)) == 0L;
    }

    static {
        BitUtil.FROM_HEX_DIGIT_TABLE[48] = 0;
        BitUtil.FROM_HEX_DIGIT_TABLE[49] = 1;
        BitUtil.FROM_HEX_DIGIT_TABLE[50] = 2;
        BitUtil.FROM_HEX_DIGIT_TABLE[51] = 3;
        BitUtil.FROM_HEX_DIGIT_TABLE[52] = 4;
        BitUtil.FROM_HEX_DIGIT_TABLE[53] = 5;
        BitUtil.FROM_HEX_DIGIT_TABLE[54] = 6;
        BitUtil.FROM_HEX_DIGIT_TABLE[55] = 7;
        BitUtil.FROM_HEX_DIGIT_TABLE[56] = 8;
        BitUtil.FROM_HEX_DIGIT_TABLE[57] = 9;
        BitUtil.FROM_HEX_DIGIT_TABLE[97] = 10;
        BitUtil.FROM_HEX_DIGIT_TABLE[65] = 10;
        BitUtil.FROM_HEX_DIGIT_TABLE[98] = 11;
        BitUtil.FROM_HEX_DIGIT_TABLE[66] = 11;
        BitUtil.FROM_HEX_DIGIT_TABLE[99] = 12;
        BitUtil.FROM_HEX_DIGIT_TABLE[67] = 12;
        BitUtil.FROM_HEX_DIGIT_TABLE[100] = 13;
        BitUtil.FROM_HEX_DIGIT_TABLE[68] = 13;
        BitUtil.FROM_HEX_DIGIT_TABLE[101] = 14;
        BitUtil.FROM_HEX_DIGIT_TABLE[69] = 14;
        BitUtil.FROM_HEX_DIGIT_TABLE[102] = 15;
        BitUtil.FROM_HEX_DIGIT_TABLE[70] = 15;
    }
}

