/*
 * Decompiled with CFR 0.152.
 */
package org.agrona;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.agrona.AsciiEncoding;
import org.agrona.AsciiNumberFormatException;
import org.agrona.BufferUtil;
import org.agrona.DirectBuffer;
import org.agrona.LangUtil;
import org.agrona.MutableDirectBuffer;
import org.agrona.UnsafeAccess;

public abstract class AbstractMutableDirectBuffer
implements MutableDirectBuffer {
    protected byte[] byteArray;
    protected long addressOffset;
    protected int capacity;

    @Override
    public byte[] byteArray() {
        return this.byteArray;
    }

    @Override
    public long addressOffset() {
        return this.addressOffset;
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public void checkLimit(int n2) {
        if (n2 > this.capacity) {
            throw new IndexOutOfBoundsException("limit=" + n2 + " is beyond capacity=" + this.capacity);
        }
    }

    @Override
    public void setMemory(int n2, int n3, byte by2) {
        this.ensureCapacity(n2, n3);
        byte[] byArray = this.byteArray;
        long l2 = this.addressOffset + (long)n2;
        if (n3 < 100) {
            int n4;
            int n5 = n3 & 0xFFFFFFF8;
            long l3 = (long)by2 << 56 | ((long)by2 & 0xFFL) << 48 | ((long)by2 & 0xFFL) << 40 | ((long)by2 & 0xFFL) << 32 | ((long)by2 & 0xFFL) << 24 | ((long)by2 & 0xFFL) << 16 | ((long)by2 & 0xFFL) << 8 | (long)by2 & 0xFFL;
            for (n4 = 0; n4 < n5; n4 += 8) {
                UnsafeAccess.UNSAFE.putLong(byArray, l2 + (long)n4, l3);
            }
            while (n4 < n3) {
                UnsafeAccess.UNSAFE.putByte(byArray, l2 + (long)n4, by2);
                ++n4;
            }
        } else if (UnsafeAccess.MEMSET_HACK_REQUIRED && n3 > UnsafeAccess.MEMSET_HACK_THRESHOLD && 0L == (l2 & 1L)) {
            UnsafeAccess.UNSAFE.putByte(byArray, l2, by2);
            UnsafeAccess.UNSAFE.setMemory(byArray, l2 + 1L, n3 - 1, by2);
        } else {
            UnsafeAccess.UNSAFE.setMemory(byArray, l2, n3, by2);
        }
    }

    @Override
    public long getLong(int n2, ByteOrder byteOrder) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(n2, 8);
        }
        long l2 = UnsafeAccess.UNSAFE.getLong(this.byteArray, this.addressOffset + (long)n2);
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            l2 = Long.reverseBytes(l2);
        }
        return l2;
    }

    @Override
    public void putLong(int n2, long l2, ByteOrder byteOrder) {
        this.ensureCapacity(n2, 8);
        long l3 = l2;
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            l3 = Long.reverseBytes(l3);
        }
        UnsafeAccess.UNSAFE.putLong(this.byteArray, this.addressOffset + (long)n2, l3);
    }

    @Override
    public long getLong(int n2) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(n2, 8);
        }
        return UnsafeAccess.UNSAFE.getLong(this.byteArray, this.addressOffset + (long)n2);
    }

    @Override
    public void putLong(int n2, long l2) {
        this.ensureCapacity(n2, 8);
        UnsafeAccess.UNSAFE.putLong(this.byteArray, this.addressOffset + (long)n2, l2);
    }

    @Override
    public int getInt(int n2, ByteOrder byteOrder) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(n2, 4);
        }
        int n3 = UnsafeAccess.UNSAFE.getInt(this.byteArray, this.addressOffset + (long)n2);
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            n3 = Integer.reverseBytes(n3);
        }
        return n3;
    }

    @Override
    public void putInt(int n2, int n3, ByteOrder byteOrder) {
        this.ensureCapacity(n2, 4);
        int n4 = n3;
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            n4 = Integer.reverseBytes(n4);
        }
        UnsafeAccess.UNSAFE.putInt(this.byteArray, this.addressOffset + (long)n2, n4);
    }

    @Override
    public int getInt(int n2) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(n2, 4);
        }
        return UnsafeAccess.UNSAFE.getInt(this.byteArray, this.addressOffset + (long)n2);
    }

    @Override
    public void putInt(int n2, int n3) {
        this.ensureCapacity(n2, 4);
        UnsafeAccess.UNSAFE.putInt(this.byteArray, this.addressOffset + (long)n2, n3);
    }

    @Override
    public double getDouble(int n2, ByteOrder byteOrder) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(n2, 8);
        }
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            long l2 = UnsafeAccess.UNSAFE.getLong(this.byteArray, this.addressOffset + (long)n2);
            return Double.longBitsToDouble(Long.reverseBytes(l2));
        }
        return UnsafeAccess.UNSAFE.getDouble(this.byteArray, this.addressOffset + (long)n2);
    }

    @Override
    public void putDouble(int n2, double d2, ByteOrder byteOrder) {
        this.ensureCapacity(n2, 8);
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            long l2 = Long.reverseBytes(Double.doubleToRawLongBits(d2));
            UnsafeAccess.UNSAFE.putLong(this.byteArray, this.addressOffset + (long)n2, l2);
        } else {
            UnsafeAccess.UNSAFE.putDouble(this.byteArray, this.addressOffset + (long)n2, d2);
        }
    }

    @Override
    public double getDouble(int n2) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(n2, 8);
        }
        return UnsafeAccess.UNSAFE.getDouble(this.byteArray, this.addressOffset + (long)n2);
    }

    @Override
    public void putDouble(int n2, double d2) {
        this.ensureCapacity(n2, 8);
        UnsafeAccess.UNSAFE.putDouble(this.byteArray, this.addressOffset + (long)n2, d2);
    }

    @Override
    public float getFloat(int n2, ByteOrder byteOrder) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(n2, 4);
        }
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            int n3 = UnsafeAccess.UNSAFE.getInt(this.byteArray, this.addressOffset + (long)n2);
            return Float.intBitsToFloat(Integer.reverseBytes(n3));
        }
        return UnsafeAccess.UNSAFE.getFloat(this.byteArray, this.addressOffset + (long)n2);
    }

    @Override
    public void putFloat(int n2, float f2, ByteOrder byteOrder) {
        this.ensureCapacity(n2, 4);
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            int n3 = Integer.reverseBytes(Float.floatToRawIntBits(f2));
            UnsafeAccess.UNSAFE.putInt(this.byteArray, this.addressOffset + (long)n2, n3);
        } else {
            UnsafeAccess.UNSAFE.putFloat(this.byteArray, this.addressOffset + (long)n2, f2);
        }
    }

    @Override
    public float getFloat(int n2) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(n2, 4);
        }
        return UnsafeAccess.UNSAFE.getFloat(this.byteArray, this.addressOffset + (long)n2);
    }

    @Override
    public void putFloat(int n2, float f2) {
        this.ensureCapacity(n2, 4);
        UnsafeAccess.UNSAFE.putFloat(this.byteArray, this.addressOffset + (long)n2, f2);
    }

    @Override
    public short getShort(int n2, ByteOrder byteOrder) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(n2, 2);
        }
        short s2 = UnsafeAccess.UNSAFE.getShort(this.byteArray, this.addressOffset + (long)n2);
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            s2 = Short.reverseBytes(s2);
        }
        return s2;
    }

    @Override
    public void putShort(int n2, short s2, ByteOrder byteOrder) {
        this.ensureCapacity(n2, 2);
        short s3 = s2;
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            s3 = Short.reverseBytes(s3);
        }
        UnsafeAccess.UNSAFE.putShort(this.byteArray, this.addressOffset + (long)n2, s3);
    }

    @Override
    public short getShort(int n2) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(n2, 2);
        }
        return UnsafeAccess.UNSAFE.getShort(this.byteArray, this.addressOffset + (long)n2);
    }

    @Override
    public void putShort(int n2, short s2) {
        this.ensureCapacity(n2, 2);
        UnsafeAccess.UNSAFE.putShort(this.byteArray, this.addressOffset + (long)n2, s2);
    }

    @Override
    public byte getByte(int n2) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(n2, 1);
        }
        return UnsafeAccess.UNSAFE.getByte(this.byteArray, this.addressOffset + (long)n2);
    }

    @Override
    public void putByte(int n2, byte by2) {
        this.ensureCapacity(n2, 1);
        UnsafeAccess.UNSAFE.putByte(this.byteArray, this.addressOffset + (long)n2, by2);
    }

    @Override
    public void getBytes(int n2, byte[] byArray) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(n2, byArray.length);
            BufferUtil.boundsCheck(byArray, 0L, byArray.length);
        }
        UnsafeAccess.UNSAFE.copyMemory(this.byteArray, this.addressOffset + (long)n2, byArray, BufferUtil.ARRAY_BASE_OFFSET, byArray.length);
    }

    @Override
    public void getBytes(int n2, byte[] byArray, int n3, int n4) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(n2, n4);
            BufferUtil.boundsCheck(byArray, (long)n3, n4);
        }
        UnsafeAccess.UNSAFE.copyMemory(this.byteArray, this.addressOffset + (long)n2, byArray, BufferUtil.ARRAY_BASE_OFFSET + (long)n3, n4);
    }

    @Override
    public void getBytes(int n2, MutableDirectBuffer mutableDirectBuffer, int n3, int n4) {
        mutableDirectBuffer.putBytes(n3, this, n2, n4);
    }

    @Override
    public void getBytes(int n2, ByteBuffer byteBuffer, int n3) {
        int n4 = byteBuffer.position();
        this.getBytes(n2, byteBuffer, n4, n3);
        byteBuffer.position(n4 + n3);
    }

    @Override
    public void getBytes(int n2, ByteBuffer byteBuffer, int n3, int n4) {
        long l2;
        byte[] byArray;
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(n2, n4);
            BufferUtil.boundsCheck(byteBuffer, (long)n3, n4);
        }
        if (byteBuffer.isDirect()) {
            byArray = null;
            l2 = BufferUtil.address(byteBuffer);
        } else {
            byArray = BufferUtil.array(byteBuffer);
            l2 = BufferUtil.ARRAY_BASE_OFFSET + (long)BufferUtil.arrayOffset(byteBuffer);
        }
        UnsafeAccess.UNSAFE.copyMemory(this.byteArray, this.addressOffset + (long)n2, byArray, l2 + (long)n3, n4);
    }

    @Override
    public void putBytes(int n2, byte[] byArray) {
        this.ensureCapacity(n2, byArray.length);
        UnsafeAccess.UNSAFE.copyMemory(byArray, BufferUtil.ARRAY_BASE_OFFSET, this.byteArray, this.addressOffset + (long)n2, byArray.length);
    }

    @Override
    public void putBytes(int n2, byte[] byArray, int n3, int n4) {
        this.ensureCapacity(n2, n4);
        if (SHOULD_BOUNDS_CHECK) {
            BufferUtil.boundsCheck(byArray, (long)n3, n4);
        }
        UnsafeAccess.UNSAFE.copyMemory(byArray, BufferUtil.ARRAY_BASE_OFFSET + (long)n3, this.byteArray, this.addressOffset + (long)n2, n4);
    }

    @Override
    public void putBytes(int n2, ByteBuffer byteBuffer, int n3) {
        int n4 = byteBuffer.position();
        this.putBytes(n2, byteBuffer, n4, n3);
        byteBuffer.position(n4 + n3);
    }

    @Override
    public void putBytes(int n2, ByteBuffer byteBuffer, int n3, int n4) {
        long l2;
        byte[] byArray;
        this.ensureCapacity(n2, n4);
        if (SHOULD_BOUNDS_CHECK) {
            BufferUtil.boundsCheck(byteBuffer, (long)n3, n4);
        }
        if (byteBuffer.isDirect()) {
            byArray = null;
            l2 = BufferUtil.address(byteBuffer);
        } else {
            byArray = BufferUtil.array(byteBuffer);
            l2 = BufferUtil.ARRAY_BASE_OFFSET + (long)BufferUtil.arrayOffset(byteBuffer);
        }
        UnsafeAccess.UNSAFE.copyMemory(byArray, l2 + (long)n3, this.byteArray, this.addressOffset + (long)n2, n4);
    }

    @Override
    public void putBytes(int n2, DirectBuffer directBuffer, int n3, int n4) {
        this.ensureCapacity(n2, n4);
        if (SHOULD_BOUNDS_CHECK) {
            directBuffer.boundsCheck(n3, n4);
        }
        UnsafeAccess.UNSAFE.copyMemory(directBuffer.byteArray(), directBuffer.addressOffset() + (long)n3, this.byteArray, this.addressOffset + (long)n2, n4);
    }

    @Override
    public char getChar(int n2, ByteOrder byteOrder) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(n2, 2);
        }
        char c2 = UnsafeAccess.UNSAFE.getChar(this.byteArray, this.addressOffset + (long)n2);
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            c2 = (char)Short.reverseBytes((short)c2);
        }
        return c2;
    }

    @Override
    public void putChar(int n2, char c2, ByteOrder byteOrder) {
        this.ensureCapacity(n2, 2);
        char c3 = c2;
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            c3 = (char)Short.reverseBytes((short)c3);
        }
        UnsafeAccess.UNSAFE.putChar(this.byteArray, this.addressOffset + (long)n2, c3);
    }

    @Override
    public char getChar(int n2) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(n2, 2);
        }
        return UnsafeAccess.UNSAFE.getChar(this.byteArray, this.addressOffset + (long)n2);
    }

    @Override
    public void putChar(int n2, char c2) {
        this.ensureCapacity(n2, 2);
        UnsafeAccess.UNSAFE.putChar(this.byteArray, this.addressOffset + (long)n2, c2);
    }

    @Override
    public String getStringAscii(int n2) {
        int n3;
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(n2, 4);
        }
        if (0 == (n3 = UnsafeAccess.UNSAFE.getInt(this.byteArray, this.addressOffset + (long)n2))) {
            return "";
        }
        return this.getStringWithoutLengthAscii(n2 + 4, n3);
    }

    @Override
    public int getStringAscii(int n2, Appendable appendable) {
        int n3;
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(n2, 4);
        }
        if (0 == (n3 = UnsafeAccess.UNSAFE.getInt(this.byteArray, this.addressOffset + (long)n2))) {
            return 0;
        }
        return this.getStringWithoutLengthAscii(n2 + 4, n3, appendable);
    }

    @Override
    public String getStringAscii(int n2, ByteOrder byteOrder) {
        int n3;
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(n2, 4);
        }
        int n4 = UnsafeAccess.UNSAFE.getInt(this.byteArray, this.addressOffset + (long)n2);
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            n4 = Integer.reverseBytes(n4);
        }
        if (0 == (n3 = n4)) {
            return "";
        }
        return this.getStringWithoutLengthAscii(n2 + 4, n3);
    }

    @Override
    public int getStringAscii(int n2, Appendable appendable, ByteOrder byteOrder) {
        int n3;
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(n2, 4);
        }
        int n4 = UnsafeAccess.UNSAFE.getInt(this.byteArray, this.addressOffset + (long)n2);
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            n4 = Integer.reverseBytes(n4);
        }
        if (0 == (n3 = n4)) {
            return 0;
        }
        return this.getStringWithoutLengthAscii(n2 + 4, n3, appendable);
    }

    @Override
    public String getStringAscii(int n2, int n3) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(n2 + 4, n3);
        }
        if (0 == n3) {
            return "";
        }
        byte[] byArray = new byte[n3];
        UnsafeAccess.UNSAFE.copyMemory(this.byteArray, this.addressOffset + (long)n2 + 4L, byArray, BufferUtil.ARRAY_BASE_OFFSET, n3);
        return new String(byArray, StandardCharsets.US_ASCII);
    }

    @Override
    public int getStringAscii(int n2, int n3, Appendable appendable) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(n2, n3 + 4);
        }
        try {
            byte[] byArray = this.byteArray;
            long l2 = this.addressOffset;
            int n4 = n2 + 4 + n3;
            for (int i2 = n2 + 4; i2 < n4; ++i2) {
                char c2 = (char)UnsafeAccess.UNSAFE.getByte(byArray, l2 + (long)i2);
                appendable.append(c2 > '\u007f' ? (char)'?' : (char)c2);
            }
        }
        catch (IOException iOException) {
            LangUtil.rethrowUnchecked(iOException);
        }
        return n3;
    }

    @Override
    public int putStringAscii(int n2, String string) {
        if (null == string) {
            this.ensureCapacity(n2, 4);
            UnsafeAccess.UNSAFE.putInt(this.byteArray, this.addressOffset + (long)n2, 0);
            return 4;
        }
        int n3 = string.length();
        this.ensureCapacity(n2, n3 + 4);
        byte[] byArray = this.byteArray;
        long l2 = this.addressOffset + (long)n2;
        UnsafeAccess.UNSAFE.putInt(byArray, l2, n3);
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = string.charAt(i2);
            if (n4 > 127) {
                n4 = 63;
            }
            UnsafeAccess.UNSAFE.putByte(byArray, l2 + 4L + (long)i2, (byte)n4);
        }
        return 4 + n3;
    }

    @Override
    public int putStringAscii(int n2, CharSequence charSequence) {
        if (null == charSequence) {
            this.ensureCapacity(n2, 4);
            UnsafeAccess.UNSAFE.putInt(this.byteArray, this.addressOffset + (long)n2, 0);
            return 4;
        }
        int n3 = charSequence.length();
        this.ensureCapacity(n2, n3 + 4);
        byte[] byArray = this.byteArray;
        long l2 = this.addressOffset + (long)n2;
        UnsafeAccess.UNSAFE.putInt(byArray, l2, n3);
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = charSequence.charAt(i2);
            if (n4 > 127) {
                n4 = 63;
            }
            UnsafeAccess.UNSAFE.putByte(byArray, l2 + 4L + (long)i2, (byte)n4);
        }
        return 4 + n3;
    }

    @Override
    public int putStringAscii(int n2, String string, ByteOrder byteOrder) {
        if (null == string) {
            this.ensureCapacity(n2, 4);
            UnsafeAccess.UNSAFE.putInt(this.byteArray, this.addressOffset + (long)n2, 0);
            return 4;
        }
        int n3 = string.length();
        this.ensureCapacity(n2, n3 + 4);
        int n4 = n3;
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            n4 = Integer.reverseBytes(n4);
        }
        byte[] byArray = this.byteArray;
        long l2 = this.addressOffset + (long)n2;
        UnsafeAccess.UNSAFE.putInt(byArray, l2, n4);
        for (int i2 = 0; i2 < n3; ++i2) {
            int n5 = string.charAt(i2);
            if (n5 > 127) {
                n5 = 63;
            }
            UnsafeAccess.UNSAFE.putByte(byArray, l2 + 4L + (long)i2, (byte)n5);
        }
        return 4 + n3;
    }

    @Override
    public int putStringAscii(int n2, CharSequence charSequence, ByteOrder byteOrder) {
        if (null == charSequence) {
            this.ensureCapacity(n2, 4);
            UnsafeAccess.UNSAFE.putInt(this.byteArray, this.addressOffset + (long)n2, 0);
            return 4;
        }
        int n3 = charSequence.length();
        this.ensureCapacity(n2, n3 + 4);
        int n4 = n3;
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            n4 = Integer.reverseBytes(n4);
        }
        byte[] byArray = this.byteArray;
        long l2 = this.addressOffset + (long)n2;
        UnsafeAccess.UNSAFE.putInt(byArray, l2, n4);
        for (int i2 = 0; i2 < n3; ++i2) {
            int n5 = charSequence.charAt(i2);
            if (n5 > 127) {
                n5 = 63;
            }
            UnsafeAccess.UNSAFE.putByte(byArray, l2 + 4L + (long)i2, (byte)n5);
        }
        return 4 + n3;
    }

    @Override
    public String getStringWithoutLengthAscii(int n2, int n3) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(n2, n3);
        }
        if (0 == n3) {
            return "";
        }
        byte[] byArray = new byte[n3];
        UnsafeAccess.UNSAFE.copyMemory(this.byteArray, this.addressOffset + (long)n2, byArray, BufferUtil.ARRAY_BASE_OFFSET, n3);
        return new String(byArray, StandardCharsets.US_ASCII);
    }

    @Override
    public int getStringWithoutLengthAscii(int n2, int n3, Appendable appendable) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(n2, n3);
        }
        try {
            byte[] byArray = this.byteArray;
            long l2 = this.addressOffset;
            int n4 = n2 + n3;
            for (int i2 = n2; i2 < n4; ++i2) {
                char c2 = (char)UnsafeAccess.UNSAFE.getByte(byArray, l2 + (long)i2);
                appendable.append(c2 > '\u007f' ? (char)'?' : (char)c2);
            }
        }
        catch (IOException iOException) {
            LangUtil.rethrowUnchecked(iOException);
        }
        return n3;
    }

    @Override
    public int putStringWithoutLengthAscii(int n2, String string) {
        if (null == string) {
            return 0;
        }
        int n3 = string.length();
        this.ensureCapacity(n2, n3);
        byte[] byArray = this.byteArray;
        long l2 = this.addressOffset + (long)n2;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = string.charAt(i2);
            if (n4 > 127) {
                n4 = 63;
            }
            UnsafeAccess.UNSAFE.putByte(byArray, l2 + (long)i2, (byte)n4);
        }
        return n3;
    }

    @Override
    public int putStringWithoutLengthAscii(int n2, CharSequence charSequence) {
        if (null == charSequence) {
            return 0;
        }
        int n3 = charSequence.length();
        this.ensureCapacity(n2, n3);
        byte[] byArray = this.byteArray;
        long l2 = this.addressOffset + (long)n2;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = charSequence.charAt(i2);
            if (n4 > 127) {
                n4 = 63;
            }
            UnsafeAccess.UNSAFE.putByte(byArray, l2 + (long)i2, (byte)n4);
        }
        return n3;
    }

    @Override
    public int putStringWithoutLengthAscii(int n2, String string, int n3, int n4) {
        if (null == string) {
            return 0;
        }
        int n5 = Math.min(string.length() - n3, n4);
        this.ensureCapacity(n2, n5);
        byte[] byArray = this.byteArray;
        long l2 = this.addressOffset + (long)n2;
        for (int i2 = 0; i2 < n5; ++i2) {
            int n6 = string.charAt(n3 + i2);
            if (n6 > 127) {
                n6 = 63;
            }
            UnsafeAccess.UNSAFE.putByte(byArray, l2 + (long)i2, (byte)n6);
        }
        return n5;
    }

    @Override
    public int putStringWithoutLengthAscii(int n2, CharSequence charSequence, int n3, int n4) {
        if (null == charSequence) {
            return 0;
        }
        int n5 = Math.min(charSequence.length() - n3, n4);
        this.ensureCapacity(n2, n5);
        byte[] byArray = this.byteArray;
        long l2 = this.addressOffset + (long)n2;
        for (int i2 = 0; i2 < n5; ++i2) {
            int n6 = charSequence.charAt(n3 + i2);
            if (n6 > 127) {
                n6 = 63;
            }
            UnsafeAccess.UNSAFE.putByte(byArray, l2 + (long)i2, (byte)n6);
        }
        return n5;
    }

    @Override
    public String getStringUtf8(int n2) {
        int n3;
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(n2, 4);
        }
        if (0 == (n3 = UnsafeAccess.UNSAFE.getInt(this.byteArray, this.addressOffset + (long)n2))) {
            return "";
        }
        return this.getStringWithoutLengthUtf8(n2 + 4, n3);
    }

    @Override
    public String getStringUtf8(int n2, ByteOrder byteOrder) {
        int n3;
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(n2, 4);
        }
        int n4 = UnsafeAccess.UNSAFE.getInt(this.byteArray, this.addressOffset + (long)n2);
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            n4 = Integer.reverseBytes(n4);
        }
        if (0 == (n3 = n4)) {
            return "";
        }
        return this.getStringWithoutLengthUtf8(n2 + 4, n3);
    }

    @Override
    public String getStringUtf8(int n2, int n3) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(n2 + 4, n3);
        }
        byte[] byArray = new byte[n3];
        UnsafeAccess.UNSAFE.copyMemory(this.byteArray, this.addressOffset + (long)n2 + 4L, byArray, BufferUtil.ARRAY_BASE_OFFSET, n3);
        return new String(byArray, StandardCharsets.UTF_8);
    }

    @Override
    public int putStringUtf8(int n2, String string) {
        return this.putStringUtf8(n2, string, Integer.MAX_VALUE);
    }

    @Override
    public int putStringUtf8(int n2, String string, ByteOrder byteOrder) {
        return this.putStringUtf8(n2, string, byteOrder, Integer.MAX_VALUE);
    }

    @Override
    public int putStringUtf8(int n2, String string, int n3) {
        byte[] byArray;
        byte[] byArray2 = byArray = string != null ? string.getBytes(StandardCharsets.UTF_8) : BufferUtil.NULL_BYTES;
        if (byArray.length > n3) {
            throw new IllegalArgumentException("Encoded string larger than maximum size: " + n3);
        }
        this.ensureCapacity(n2, 4 + byArray.length);
        byte[] byArray3 = this.byteArray;
        long l2 = this.addressOffset + (long)n2;
        UnsafeAccess.UNSAFE.putInt(byArray3, l2, byArray.length);
        UnsafeAccess.UNSAFE.copyMemory(byArray, BufferUtil.ARRAY_BASE_OFFSET, byArray3, l2 + 4L, byArray.length);
        return 4 + byArray.length;
    }

    @Override
    public int putStringUtf8(int n2, String string, ByteOrder byteOrder, int n3) {
        byte[] byArray;
        byte[] byArray2 = byArray = string != null ? string.getBytes(StandardCharsets.UTF_8) : BufferUtil.NULL_BYTES;
        if (byArray.length > n3) {
            throw new IllegalArgumentException("Encoded string larger than maximum size: " + n3);
        }
        this.ensureCapacity(n2, 4 + byArray.length);
        int n4 = byArray.length;
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            n4 = Integer.reverseBytes(n4);
        }
        byte[] byArray3 = this.byteArray;
        long l2 = this.addressOffset + (long)n2;
        UnsafeAccess.UNSAFE.putInt(byArray3, l2, n4);
        UnsafeAccess.UNSAFE.copyMemory(byArray, BufferUtil.ARRAY_BASE_OFFSET, byArray3, l2 + 4L, byArray.length);
        return 4 + byArray.length;
    }

    @Override
    public String getStringWithoutLengthUtf8(int n2, int n3) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(n2, n3);
        }
        if (0 == n3) {
            return "";
        }
        byte[] byArray = new byte[n3];
        UnsafeAccess.UNSAFE.copyMemory(this.byteArray, this.addressOffset + (long)n2, byArray, BufferUtil.ARRAY_BASE_OFFSET, n3);
        return new String(byArray, StandardCharsets.UTF_8);
    }

    @Override
    public int putStringWithoutLengthUtf8(int n2, String string) {
        byte[] byArray = string != null ? string.getBytes(StandardCharsets.UTF_8) : BufferUtil.NULL_BYTES;
        this.ensureCapacity(n2, byArray.length);
        UnsafeAccess.UNSAFE.copyMemory(byArray, BufferUtil.ARRAY_BASE_OFFSET, this.byteArray, this.addressOffset + (long)n2, byArray.length);
        return byArray.length;
    }

    @Override
    public int parseNaturalIntAscii(int n2, int n3) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(n2, n3);
        }
        if (n3 <= 0) {
            throw new AsciiNumberFormatException("empty string: index=" + n2 + " length=" + n3);
        }
        if (n3 < 10) {
            return this.parsePositiveIntAscii(n2, n3, n2, n2 + n3);
        }
        long l2 = this.parsePositiveIntAsciiOverflowCheck(n2, n3, n2, n2 + n3);
        if (l2 >= AsciiEncoding.INTEGER_ABSOLUTE_MIN_VALUE) {
            this.throwParseIntOverflowError(n2, n3);
        }
        return (int)l2;
    }

    @Override
    public long parseNaturalLongAscii(int n2, int n3) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(n2, n3);
        }
        if (n3 <= 0) {
            throw new AsciiNumberFormatException("empty string: index=" + n2 + " length=" + n3);
        }
        if (n3 < 19) {
            return this.parsePositiveLongAscii(n2, n3, n2, n2 + n3);
        }
        return this.parseLongAsciiOverflowCheck(n2, n3, AsciiEncoding.LONG_MAX_VALUE_DIGITS, n2, n2 + n3);
    }

    @Override
    public int parseIntAscii(int n2, int n3) {
        int n4;
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(n2, n3);
        }
        if (n3 <= 0) {
            throw new AsciiNumberFormatException("empty string: index=" + n2 + " length=" + n3);
        }
        boolean bl2 = 45 == UnsafeAccess.UNSAFE.getByte(this.byteArray, this.addressOffset + (long)n2);
        int n5 = n2;
        if (bl2) {
            ++n5;
            if (1 == n3) {
                this.throwParseIntError(n2, n3);
            }
        }
        if ((n4 = n2 + n3) - n5 < 10) {
            int n6 = this.parsePositiveIntAscii(n2, n3, n5, n4);
            return bl2 ? -n6 : n6;
        }
        long l2 = this.parsePositiveIntAsciiOverflowCheck(n2, n3, n5, n4);
        if (l2 > AsciiEncoding.INTEGER_ABSOLUTE_MIN_VALUE || AsciiEncoding.INTEGER_ABSOLUTE_MIN_VALUE == l2 && !bl2) {
            this.throwParseIntOverflowError(n2, n3);
        }
        return (int)(bl2 ? -l2 : l2);
    }

    @Override
    public long parseLongAscii(int n2, int n3) {
        int n4;
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(n2, n3);
        }
        if (n3 <= 0) {
            throw new AsciiNumberFormatException("empty string: index=" + n2 + " length=" + n3);
        }
        boolean bl2 = 45 == UnsafeAccess.UNSAFE.getByte(this.byteArray, this.addressOffset + (long)n2);
        int n5 = n2;
        if (bl2) {
            ++n5;
            if (1 == n3) {
                this.throwParseLongError(n2, n3);
            }
        }
        if ((n4 = n2 + n3) - n5 < 19) {
            long l2 = this.parsePositiveLongAscii(n2, n3, n5, n4);
            return bl2 ? -l2 : l2;
        }
        if (bl2) {
            return -this.parseLongAsciiOverflowCheck(n2, n3, AsciiEncoding.LONG_MIN_VALUE_DIGITS, n5, n4);
        }
        return this.parseLongAsciiOverflowCheck(n2, n3, AsciiEncoding.LONG_MAX_VALUE_DIGITS, n5, n4);
    }

    @Override
    public int putIntAscii(int n2, int n3) {
        long l2;
        byte[] byArray;
        int n4;
        int n5;
        if (0 == n3) {
            this.putByte(n2, (byte)48);
            return 1;
        }
        int n6 = n3;
        if (n3 < 0) {
            if (Integer.MIN_VALUE == n3) {
                this.putBytes(n2, AsciiEncoding.MIN_INTEGER_VALUE);
                return AsciiEncoding.MIN_INTEGER_VALUE.length;
            }
            n6 = -n6;
            n5 = AsciiEncoding.digitCount(n6);
            n4 = n5 + 1;
            this.ensureCapacity(n2, n4);
            byArray = this.byteArray;
            l2 = this.addressOffset + (long)n2;
            UnsafeAccess.UNSAFE.putByte(byArray, l2, (byte)45);
            ++l2;
        } else {
            n4 = n5 = AsciiEncoding.digitCount(n6);
            this.ensureCapacity(n2, n4);
            byArray = this.byteArray;
            l2 = this.addressOffset + (long)n2;
        }
        AbstractMutableDirectBuffer.putPositiveIntAscii(byArray, l2, n6, n5);
        return n4;
    }

    @Override
    public int putNaturalIntAscii(int n2, int n3) {
        if (0 == n3) {
            this.putByte(n2, (byte)48);
            return 1;
        }
        int n4 = AsciiEncoding.digitCount(n3);
        this.ensureCapacity(n2, n4);
        AbstractMutableDirectBuffer.putPositiveIntAscii(this.byteArray, this.addressOffset + (long)n2, n3, n4);
        return n4;
    }

    @Override
    public void putNaturalPaddedIntAscii(int n2, int n3, int n4) {
        this.ensureCapacity(n2, n3);
        byte[] byArray = this.byteArray;
        long l2 = this.addressOffset;
        int n5 = n2 + n3;
        int n6 = n4;
        for (int i2 = n5 - 1; i2 >= n2; --i2) {
            int n7 = n6 % 10;
            n6 /= 10;
            UnsafeAccess.UNSAFE.putByte(byArray, l2 + (long)i2, (byte)(48 + n7));
        }
        if (n6 != 0) {
            throw new NumberFormatException("Cannot write " + n4 + " in " + n3 + " bytes");
        }
    }

    @Override
    public int putNaturalIntAsciiFromEnd(int n2, int n3) {
        int n4 = AsciiEncoding.digitCount(n2);
        this.ensureCapacity(n3 - n4, n4);
        byte[] byArray = this.byteArray;
        long l2 = this.addressOffset;
        int n5 = n3;
        for (int i2 = n2; i2 > 0; i2 /= 10) {
            int n6 = i2 % 10;
            UnsafeAccess.UNSAFE.putByte(byArray, l2 + (long)(--n5), (byte)(48 + n6));
        }
        return n5;
    }

    @Override
    public int putNaturalLongAscii(int n2, long l2) {
        if (0L == l2) {
            this.putByte(n2, (byte)48);
            return 1;
        }
        int n3 = AsciiEncoding.digitCount(l2);
        this.ensureCapacity(n2, n3);
        AbstractMutableDirectBuffer.putPositiveLongAscii(this.byteArray, this.addressOffset + (long)n2, l2, n3);
        return n3;
    }

    @Override
    public int putLongAscii(int n2, long l2) {
        long l3;
        byte[] byArray;
        int n3;
        int n4;
        if (0L == l2) {
            this.putByte(n2, (byte)48);
            return 1;
        }
        long l4 = l2;
        if (l2 < 0L) {
            if (Long.MIN_VALUE == l2) {
                this.putBytes(n2, AsciiEncoding.MIN_LONG_VALUE);
                return AsciiEncoding.MIN_LONG_VALUE.length;
            }
            l4 = -l4;
            n4 = AsciiEncoding.digitCount(l4);
            n3 = n4 + 1;
            this.ensureCapacity(n2, n3);
            byArray = this.byteArray;
            l3 = this.addressOffset + (long)n2;
            UnsafeAccess.UNSAFE.putByte(byArray, l3, (byte)45);
            ++l3;
        } else {
            n3 = n4 = AsciiEncoding.digitCount(l4);
            this.ensureCapacity(n2, n3);
            byArray = this.byteArray;
            l3 = this.addressOffset + (long)n2;
        }
        AbstractMutableDirectBuffer.putPositiveLongAscii(byArray, l3, l4, n4);
        return n3;
    }

    @Override
    public void boundsCheck(int n2, int n3) {
        this.boundsCheck0(n2, n3);
    }

    public boolean equals(Object object) {
        int n2;
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        AbstractMutableDirectBuffer abstractMutableDirectBuffer = (AbstractMutableDirectBuffer)object;
        int n3 = this.capacity;
        if (n3 != abstractMutableDirectBuffer.capacity) {
            return false;
        }
        byte[] byArray = this.byteArray;
        byte[] byArray2 = abstractMutableDirectBuffer.byteArray;
        long l2 = this.addressOffset;
        long l3 = abstractMutableDirectBuffer.addressOffset;
        int n4 = n3 & 0xFFFFFFF8;
        for (n2 = 0; n2 < n4; n2 += 8) {
            if (UnsafeAccess.UNSAFE.getLong(byArray, l2 + (long)n2) == UnsafeAccess.UNSAFE.getLong(byArray2, l3 + (long)n2)) continue;
            return false;
        }
        while (n2 < n3) {
            if (UnsafeAccess.UNSAFE.getByte(byArray, l2 + (long)n2) != UnsafeAccess.UNSAFE.getByte(byArray2, l3 + (long)n2)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public int hashCode() {
        int n2;
        byte[] byArray = this.byteArray;
        long l2 = this.addressOffset;
        int n3 = this.capacity;
        int n4 = 19;
        int n5 = n3 & 0xFFFFFFF8;
        for (n2 = 0; n2 < n5; n2 += 8) {
            n4 = 31 * n4 + Long.hashCode(UnsafeAccess.UNSAFE.getLong(byArray, l2 + (long)n2));
        }
        while (n2 < n3) {
            n4 = 31 * n4 + UnsafeAccess.UNSAFE.getByte(byArray, l2 + (long)n2);
            ++n2;
        }
        return n4;
    }

    @Override
    public int compareTo(DirectBuffer directBuffer) {
        int n2;
        if (this == directBuffer) {
            return 0;
        }
        int n3 = this.capacity;
        int n4 = directBuffer.capacity();
        byte[] byArray = this.byteArray;
        byte[] byArray2 = directBuffer.byteArray();
        long l2 = this.addressOffset;
        long l3 = directBuffer.addressOffset();
        int n5 = Math.min(n3, n4);
        int n6 = n5 & 0xFFFFFFF8;
        for (n2 = 0; n2 < n6; n2 += 8) {
            int n7 = Long.compare(UnsafeAccess.UNSAFE.getLong(byArray, l2 + (long)n2), UnsafeAccess.UNSAFE.getLong(byArray2, l3 + (long)n2));
            if (0 == n7) continue;
            return n7;
        }
        while (n2 < n5) {
            n6 = Byte.compare(UnsafeAccess.UNSAFE.getByte(byArray, l2 + (long)n2), UnsafeAccess.UNSAFE.getByte(byArray2, l3 + (long)n2));
            if (0 != n6) {
                return n6;
            }
            ++n2;
        }
        return Integer.compare(n3, n4);
    }

    protected final void boundsCheck0(int n2, int n3) {
        long l2 = (long)n2 + (long)n3;
        if (n2 < 0 || n3 < 0 || l2 > (long)this.capacity) {
            throw new IndexOutOfBoundsException("index=" + n2 + " length=" + n3 + " capacity=" + this.capacity);
        }
    }

    protected abstract void ensureCapacity(int var1, int var2);

    private int parsePositiveIntAscii(int n2, int n3, int n4, int n5) {
        byte by2;
        int n6;
        long l2 = this.addressOffset;
        byte[] byArray = this.byteArray;
        int n7 = n4;
        int n8 = 0;
        while (n5 - n7 >= 4 && AsciiEncoding.isFourDigitsAsciiEncodedNumber(n6 = UnsafeAccess.UNSAFE.getInt(byArray, l2 + (long)n7))) {
            if (BufferUtil.NATIVE_BYTE_ORDER != ByteOrder.LITTLE_ENDIAN) {
                n6 = Integer.reverseBytes(n6);
            }
            n8 = n8 * 10000 + AsciiEncoding.parseFourDigitsLittleEndian(n6);
            n7 += 4;
        }
        while (n7 < n5 && AsciiEncoding.isDigit(by2 = UnsafeAccess.UNSAFE.getByte(byArray, l2 + (long)n7))) {
            n8 = n8 * 10 + (by2 - 48);
            ++n7;
        }
        if (n7 != n5) {
            this.throwParseIntError(n2, n3);
        }
        return n8;
    }

    private long parsePositiveIntAsciiOverflowCheck(int n2, int n3, int n4, int n5) {
        if (n5 - n4 > 10) {
            this.throwParseIntOverflowError(n2, n3);
        }
        long l2 = this.addressOffset;
        byte[] byArray = this.byteArray;
        int n6 = n4;
        long l3 = 0L;
        long l4 = UnsafeAccess.UNSAFE.getLong(byArray, l2 + (long)n6);
        if (AsciiEncoding.isEightDigitAsciiEncodedNumber(l4)) {
            byte by2;
            if (BufferUtil.NATIVE_BYTE_ORDER != ByteOrder.LITTLE_ENDIAN) {
                l4 = Long.reverseBytes(l4);
            }
            l3 = AsciiEncoding.parseEightDigitsLittleEndian(l4);
            n6 += 8;
            while (n6 < n5 && AsciiEncoding.isDigit(by2 = UnsafeAccess.UNSAFE.getByte(byArray, l2 + (long)n6))) {
                l3 = l3 * 10L + (long)(by2 - 48);
                ++n6;
            }
        }
        if (n6 != n5) {
            this.throwParseIntError(n2, n3);
        }
        return l3;
    }

    private void throwParseIntError(int n2, int n3) {
        throw new AsciiNumberFormatException("error parsing int: " + this.getStringWithoutLengthAscii(n2, n3));
    }

    private void throwParseIntOverflowError(int n2, int n3) {
        throw new AsciiNumberFormatException("int overflow parsing: " + this.getStringWithoutLengthAscii(n2, n3));
    }

    private long parsePositiveLongAscii(int n2, int n3, int n4, int n5) {
        byte by2;
        int n6;
        long l2;
        long l3 = this.addressOffset;
        byte[] byArray = this.byteArray;
        int n7 = n4;
        long l4 = 0L;
        while (n5 - n7 >= 8 && AsciiEncoding.isEightDigitAsciiEncodedNumber(l2 = UnsafeAccess.UNSAFE.getLong(byArray, l3 + (long)n7))) {
            if (BufferUtil.NATIVE_BYTE_ORDER != ByteOrder.LITTLE_ENDIAN) {
                l2 = Long.reverseBytes(l2);
            }
            l4 = l4 * 100000000L + (long)AsciiEncoding.parseEightDigitsLittleEndian(l2);
            n7 += 8;
        }
        while (n5 - n7 >= 4 && AsciiEncoding.isFourDigitsAsciiEncodedNumber(n6 = UnsafeAccess.UNSAFE.getInt(byArray, l3 + (long)n7))) {
            if (BufferUtil.NATIVE_BYTE_ORDER != ByteOrder.LITTLE_ENDIAN) {
                n6 = Integer.reverseBytes(n6);
            }
            l4 = l4 * 10000L + (long)AsciiEncoding.parseFourDigitsLittleEndian(n6);
            n7 += 4;
        }
        while (n7 < n5 && AsciiEncoding.isDigit(by2 = UnsafeAccess.UNSAFE.getByte(byArray, l3 + (long)n7))) {
            l4 = l4 * 10L + (long)(by2 - 48);
            ++n7;
        }
        if (n7 != n5) {
            this.throwParseLongError(n2, n3);
        }
        return l4;
    }

    private long parseLongAsciiOverflowCheck(int n2, int n3, int[] nArray, int n4, int n5) {
        int n6;
        long l2;
        if (n5 - n4 > 19) {
            this.throwParseLongOverflowError(n2, n3);
        }
        long l3 = this.addressOffset;
        byte[] byArray = this.byteArray;
        int n7 = n4;
        int n8 = 0;
        boolean bl2 = true;
        long l4 = 0L;
        while (n5 - n7 >= 8 && AsciiEncoding.isEightDigitAsciiEncodedNumber(l2 = UnsafeAccess.UNSAFE.getLong(byArray, l3 + (long)n7))) {
            if (BufferUtil.NATIVE_BYTE_ORDER != ByteOrder.LITTLE_ENDIAN) {
                l2 = Long.reverseBytes(l2);
            }
            n6 = AsciiEncoding.parseEightDigitsLittleEndian(l2);
            if (bl2) {
                if (n6 > nArray[n8]) {
                    this.throwParseLongOverflowError(n2, n3);
                } else if (n6 < nArray[n8]) {
                    bl2 = false;
                }
                ++n8;
            }
            l4 = l4 * 100000000L + (long)n6;
            n7 += 8;
        }
        int n9 = 0;
        while (n7 < n5 && AsciiEncoding.isDigit((byte)(n6 = UnsafeAccess.UNSAFE.getByte(byArray, l3 + (long)n7)))) {
            n9 = n9 * 10 + (n6 - 48);
            ++n7;
        }
        if (n7 != n5) {
            this.throwParseLongError(n2, n3);
        } else if (bl2 && n9 > nArray[n8]) {
            this.throwParseLongOverflowError(n2, n3);
        }
        return l4 * 1000L + (long)n9;
    }

    private void throwParseLongError(int n2, int n3) {
        throw new AsciiNumberFormatException("error parsing long: " + this.getStringWithoutLengthAscii(n2, n3));
    }

    private void throwParseLongOverflowError(int n2, int n3) {
        throw new AsciiNumberFormatException("long overflow parsing: " + this.getStringWithoutLengthAscii(n2, n3));
    }

    private static void putPositiveIntAscii(byte[] byArray, long l2, int n2, int n3) {
        int n4;
        int n5;
        int n6 = n3;
        for (n5 = n2; n5 >= 10000; n5 /= 10000) {
            n4 = n5 % 10000;
            int n7 = n4 / 100 << 1;
            int n8 = n4 % 100 << 1;
            UnsafeAccess.UNSAFE.putByte(byArray, l2 + (long)(n6 -= 4), AsciiEncoding.ASCII_DIGITS[n7]);
            UnsafeAccess.UNSAFE.putByte(byArray, l2 + (long)n6 + 1L, AsciiEncoding.ASCII_DIGITS[n7 + 1]);
            UnsafeAccess.UNSAFE.putByte(byArray, l2 + (long)n6 + 2L, AsciiEncoding.ASCII_DIGITS[n8]);
            UnsafeAccess.UNSAFE.putByte(byArray, l2 + (long)n6 + 3L, AsciiEncoding.ASCII_DIGITS[n8 + 1]);
        }
        if (n5 >= 100) {
            n4 = n5 % 100 << 1;
            n5 /= 100;
            UnsafeAccess.UNSAFE.putByte(byArray, l2 + (long)n6 - 1L, AsciiEncoding.ASCII_DIGITS[n4 + 1]);
            UnsafeAccess.UNSAFE.putByte(byArray, l2 + (long)n6 - 2L, AsciiEncoding.ASCII_DIGITS[n4]);
        }
        if (n5 >= 10) {
            n4 = n5 << 1;
            UnsafeAccess.UNSAFE.putByte(byArray, l2 + 1L, AsciiEncoding.ASCII_DIGITS[n4 + 1]);
            UnsafeAccess.UNSAFE.putByte(byArray, l2, AsciiEncoding.ASCII_DIGITS[n4]);
        } else {
            UnsafeAccess.UNSAFE.putByte(byArray, l2, (byte)(48 + n5));
        }
    }

    private static void putPositiveLongAscii(byte[] byArray, long l2, long l3, int n2) {
        long l4;
        int n3 = n2;
        for (l4 = l3; l4 >= 100000000L; l4 /= 100000000L) {
            int n4 = (int)(l4 % 100000000L);
            int n5 = n4 / 10000;
            int n6 = n4 % 10000;
            int n7 = n5 / 100 << 1;
            int n8 = n5 % 100 << 1;
            int n9 = n6 / 100 << 1;
            int n10 = n6 % 100 << 1;
            UnsafeAccess.UNSAFE.putByte(byArray, l2 + (long)(n3 -= 8), AsciiEncoding.ASCII_DIGITS[n7]);
            UnsafeAccess.UNSAFE.putByte(byArray, l2 + (long)n3 + 1L, AsciiEncoding.ASCII_DIGITS[n7 + 1]);
            UnsafeAccess.UNSAFE.putByte(byArray, l2 + (long)n3 + 2L, AsciiEncoding.ASCII_DIGITS[n8]);
            UnsafeAccess.UNSAFE.putByte(byArray, l2 + (long)n3 + 3L, AsciiEncoding.ASCII_DIGITS[n8 + 1]);
            UnsafeAccess.UNSAFE.putByte(byArray, l2 + (long)n3 + 4L, AsciiEncoding.ASCII_DIGITS[n9]);
            UnsafeAccess.UNSAFE.putByte(byArray, l2 + (long)n3 + 5L, AsciiEncoding.ASCII_DIGITS[n9 + 1]);
            UnsafeAccess.UNSAFE.putByte(byArray, l2 + (long)n3 + 6L, AsciiEncoding.ASCII_DIGITS[n10]);
            UnsafeAccess.UNSAFE.putByte(byArray, l2 + (long)n3 + 7L, AsciiEncoding.ASCII_DIGITS[n10 + 1]);
        }
        AbstractMutableDirectBuffer.putPositiveIntAscii(byArray, l2, (int)l4, n3);
    }
}

