/*
 * Decompiled with CFR 0.152.
 */
package org.HdrHistogram.packedarray;

import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.HdrHistogram.packedarray.AbstractPackedArrayContext;
import org.HdrHistogram.packedarray.IterationValue;
import org.HdrHistogram.packedarray.ResizeException;

abstract class AbstractPackedLongArray
implements Iterable<Long>,
Serializable {
    private static final int NUMBER_OF_SETS = 8;
    private AbstractPackedArrayContext arrayContext;
    private long startTimeStampMsec = Long.MAX_VALUE;
    private long endTimeStampMsec = 0L;
    static final int NUMBER_OF_NON_ZEROS_TO_HASH = 8;

    AbstractPackedLongArray() {
    }

    AbstractPackedArrayContext getArrayContext() {
        return this.arrayContext;
    }

    void setArrayContext(AbstractPackedArrayContext abstractPackedArrayContext) {
        this.arrayContext = abstractPackedArrayContext;
    }

    public long getStartTimeStamp() {
        return this.startTimeStampMsec;
    }

    public void setStartTimeStamp(long l2) {
        this.startTimeStampMsec = l2;
    }

    public long getEndTimeStamp() {
        return this.endTimeStampMsec;
    }

    public void setEndTimeStamp(long l2) {
        this.endTimeStampMsec = l2;
    }

    public abstract void setVirtualLength(int var1);

    public abstract AbstractPackedLongArray copy();

    abstract void resizeStorageArray(int var1);

    abstract void clearContents();

    abstract long criticalSectionEnter();

    abstract void criticalSectionExit(long var1);

    public String toString() {
        String string = "PackedArray:\n";
        AbstractPackedArrayContext abstractPackedArrayContext = this.getArrayContext();
        string = string + abstractPackedArrayContext.toString();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long get(int n2) {
        long l2 = 0L;
        for (int i2 = 0; i2 < 8; ++i2) {
            int n3 = 0;
            long l3 = 0L;
            do {
                int n4 = 0;
                long l4 = this.criticalSectionEnter();
                try {
                    AbstractPackedArrayContext abstractPackedArrayContext = this.getArrayContext();
                    if (!abstractPackedArrayContext.isPacked()) {
                        long l5 = abstractPackedArrayContext.getAtUnpackedIndex(n2);
                        return l5;
                    }
                    n3 = abstractPackedArrayContext.getPackedIndex(i2, n2, false);
                    if (n3 < 0) {
                        long l6 = l2;
                        return l6;
                    }
                    l3 = ((long)abstractPackedArrayContext.getAtByteIndex(n3) & 0xFFL) << (i2 << 3);
                }
                catch (ResizeException resizeException) {
                    n4 = resizeException.getNewSize();
                }
                finally {
                    this.criticalSectionExit(l4);
                    if (n4 != 0) {
                        this.resizeStorageArray(n4);
                    }
                }
            } while (n3 == 0);
            l2 += l3;
        }
        return l2;
    }

    public void increment(int n2) {
        this.add(n2, 1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(int n2, long l2) {
        if (l2 == 0L) {
            return;
        }
        long l3 = l2;
        while (true) {
            try {
                long l4 = 255L;
                int n3 = 0;
                int n4 = 0;
                while (n3 < 8) {
                    long l5 = this.criticalSectionEnter();
                    try {
                        AbstractPackedArrayContext abstractPackedArrayContext = this.getArrayContext();
                        if (!abstractPackedArrayContext.isPacked()) {
                            abstractPackedArrayContext.addAndGetAtUnpackedIndex(n2, l3);
                            return;
                        }
                        int n5 = abstractPackedArrayContext.getPackedIndex(n3, n2, true);
                        long l6 = l3 & l4;
                        byte by2 = (byte)(l6 >> n4);
                        long l7 = abstractPackedArrayContext.addAtByteIndex(n5, by2);
                        l3 -= l6;
                        long l8 = l7 & 0x100L;
                        if ((l3 += l8 << n4) == 0L) {
                            return;
                        }
                    }
                    finally {
                        this.criticalSectionExit(l5);
                    }
                    ++n3;
                    n4 += 8;
                    l4 <<= 8;
                }
                return;
            }
            catch (ResizeException resizeException) {
                this.resizeStorageArray(resizeException.getNewSize());
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(int n2, long l2) {
        int n3 = 0;
        while (true) {
            long l3 = l2;
            try {
                for (int i2 = 0; i2 < 8; ++i2) {
                    long l4 = this.criticalSectionEnter();
                    try {
                        int n4;
                        AbstractPackedArrayContext abstractPackedArrayContext = this.getArrayContext();
                        if (!abstractPackedArrayContext.isPacked()) {
                            abstractPackedArrayContext.setAtUnpackedIndex(n2, l2);
                            return;
                        }
                        if (l3 == 0L && (n4 = abstractPackedArrayContext.getPackedIndex(i2, n2, false)) < 0) {
                            return;
                        }
                        n4 = abstractPackedArrayContext.getPackedIndex(i2, n2, true);
                        byte by2 = (byte)(l3 & 0xFFL);
                        l3 >>= 8;
                        if (i2 < n3) continue;
                        abstractPackedArrayContext.setAtByteIndex(n4, by2);
                        ++n3;
                        continue;
                    }
                    finally {
                        this.criticalSectionExit(l4);
                    }
                }
                return;
            }
            catch (ResizeException resizeException) {
                this.resizeStorageArray(resizeException.getNewSize());
                continue;
            }
            break;
        }
    }

    public void add(AbstractPackedLongArray abstractPackedLongArray) {
        for (IterationValue iterationValue : abstractPackedLongArray.nonZeroValues()) {
            this.add(iterationValue.getIndex(), iterationValue.getValue());
        }
    }

    public void clear() {
        this.clearContents();
    }

    public int getPhysicalLength() {
        return this.getArrayContext().length();
    }

    public int length() {
        return this.getArrayContext().getVirtualLength();
    }

    @Override
    public Iterator<Long> iterator() {
        return new AllValuesIterator();
    }

    public Iterable<IterationValue> nonZeroValues() {
        return this.getArrayContext().nonZeroValues();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AbstractPackedLongArray)) {
            return false;
        }
        AbstractPackedLongArray abstractPackedLongArray = (AbstractPackedLongArray)object;
        if (this.length() != abstractPackedLongArray.length()) {
            return false;
        }
        if (this.arrayContext.isPacked() || abstractPackedLongArray.arrayContext.isPacked()) {
            for (IterationValue iterationValue : this.nonZeroValues()) {
                if (abstractPackedLongArray.get(iterationValue.getIndex()) == iterationValue.getValue()) continue;
                return false;
            }
            for (IterationValue iterationValue : abstractPackedLongArray.nonZeroValues()) {
                if (this.get(iterationValue.getIndex()) == iterationValue.getValue()) continue;
                return false;
            }
        } else {
            for (int i2 = 0; i2 < this.length(); ++i2) {
                if (this.get(i2) == abstractPackedLongArray.get(i2)) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int n2 = 0;
        n2 = this.oneAtATimeHashStep(n2, this.length());
        int n3 = 0;
        for (IterationValue iterationValue : this.nonZeroValues()) {
            if (++n3 > 8) break;
            n2 = this.oneAtATimeHashStep(n2, iterationValue.getIndex());
            n2 = this.oneAtATimeHashStep(n2, (int)iterationValue.getValue());
        }
        n2 += n2 << 3;
        n2 ^= n2 >> 11;
        n2 += n2 << 15;
        return n2;
    }

    private int oneAtATimeHashStep(int n2, int n3) {
        int n4 = n2;
        n4 += n3;
        n4 += n4 << 10;
        n4 ^= n4 >> 6;
        return n4;
    }

    class AllValuesIterator
    implements Iterator<Long> {
        int nextVirtrualIndex = 0;

        AllValuesIterator() {
        }

        @Override
        public Long next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return AbstractPackedLongArray.this.get(this.nextVirtrualIndex++);
        }

        @Override
        public boolean hasNext() {
            return this.nextVirtrualIndex >= 0 && this.nextVirtrualIndex < AbstractPackedLongArray.this.length();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

