/*
 * Decompiled with CFR 0.152.
 */
package org.HdrHistogram;

import java.util.concurrent.atomic.AtomicLong;
import org.HdrHistogram.DoubleHistogram;
import org.HdrHistogram.DoubleValueRecorder;
import org.HdrHistogram.PackedDoubleHistogram;
import org.HdrHistogram.WriterReaderPhaser;

public class SingleWriterDoubleRecorder
implements DoubleValueRecorder {
    private static AtomicLong instanceIdSequencer = new AtomicLong(1L);
    private final long instanceId = instanceIdSequencer.getAndIncrement();
    private final WriterReaderPhaser recordingPhaser = new WriterReaderPhaser();
    private volatile DoubleHistogram activeHistogram;
    private DoubleHistogram inactiveHistogram;

    public SingleWriterDoubleRecorder(int n2, boolean bl2) {
        this.activeHistogram = bl2 ? new PackedInternalDoubleHistogram(this.instanceId, n2) : new InternalDoubleHistogram(this.instanceId, n2);
        this.inactiveHistogram = null;
        this.activeHistogram.setStartTimeStamp(System.currentTimeMillis());
    }

    public SingleWriterDoubleRecorder(int n2) {
        this(n2, false);
    }

    public SingleWriterDoubleRecorder(long l2, int n2) {
        this.activeHistogram = new InternalDoubleHistogram(this.instanceId, l2, n2);
        this.inactiveHistogram = null;
        this.activeHistogram.setStartTimeStamp(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recordValue(double d2) {
        long l2 = this.recordingPhaser.writerCriticalSectionEnter();
        try {
            this.activeHistogram.recordValue(d2);
        }
        finally {
            this.recordingPhaser.writerCriticalSectionExit(l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recordValueWithCount(double d2, long l2) throws ArrayIndexOutOfBoundsException {
        long l3 = this.recordingPhaser.writerCriticalSectionEnter();
        try {
            this.activeHistogram.recordValueWithCount(d2, l2);
        }
        finally {
            this.recordingPhaser.writerCriticalSectionExit(l3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recordValueWithExpectedInterval(double d2, double d3) throws ArrayIndexOutOfBoundsException {
        long l2 = this.recordingPhaser.writerCriticalSectionEnter();
        try {
            this.activeHistogram.recordValueWithExpectedInterval(d2, d3);
        }
        finally {
            this.recordingPhaser.writerCriticalSectionExit(l2);
        }
    }

    public synchronized DoubleHistogram getIntervalHistogram() {
        return this.getIntervalHistogram(null);
    }

    public synchronized DoubleHistogram getIntervalHistogram(DoubleHistogram doubleHistogram) {
        return this.getIntervalHistogram(doubleHistogram, true);
    }

    public synchronized DoubleHistogram getIntervalHistogram(DoubleHistogram doubleHistogram, boolean bl2) {
        this.validateFitAsReplacementHistogram(doubleHistogram, bl2);
        this.inactiveHistogram = doubleHistogram;
        this.performIntervalSample();
        DoubleHistogram doubleHistogram2 = this.inactiveHistogram;
        this.inactiveHistogram = null;
        return doubleHistogram2;
    }

    public synchronized void getIntervalHistogramInto(DoubleHistogram doubleHistogram) {
        this.performIntervalSample();
        this.inactiveHistogram.copyInto(doubleHistogram);
    }

    @Override
    public synchronized void reset() {
        this.performIntervalSample();
        this.performIntervalSample();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performIntervalSample() {
        try {
            this.recordingPhaser.readerLock();
            if (this.inactiveHistogram == null) {
                if (this.activeHistogram instanceof InternalDoubleHistogram) {
                    this.inactiveHistogram = new InternalDoubleHistogram((InternalDoubleHistogram)this.activeHistogram);
                } else if (this.activeHistogram instanceof PackedInternalDoubleHistogram) {
                    this.inactiveHistogram = new PackedInternalDoubleHistogram(this.instanceId, this.activeHistogram.getNumberOfSignificantValueDigits());
                } else {
                    throw new IllegalStateException("Unexpected internal histogram type for activeHistogram");
                }
            }
            this.inactiveHistogram.reset();
            DoubleHistogram doubleHistogram = this.inactiveHistogram;
            this.inactiveHistogram = this.activeHistogram;
            this.activeHistogram = doubleHistogram;
            long l2 = System.currentTimeMillis();
            this.activeHistogram.setStartTimeStamp(l2);
            this.inactiveHistogram.setEndTimeStamp(l2);
            this.recordingPhaser.flipPhase(500000L);
        }
        finally {
            this.recordingPhaser.readerUnlock();
        }
    }

    private void validateFitAsReplacementHistogram(DoubleHistogram doubleHistogram, boolean bl2) {
        boolean bl3 = true;
        if (doubleHistogram == null) {
            bl3 = false;
        } else if (doubleHistogram instanceof InternalDoubleHistogram && (!bl2 || ((InternalDoubleHistogram)doubleHistogram).containingInstanceId == ((InternalDoubleHistogram)this.activeHistogram).containingInstanceId)) {
            bl3 = false;
        } else if (doubleHistogram instanceof PackedInternalDoubleHistogram && (!bl2 || ((PackedInternalDoubleHistogram)doubleHistogram).containingInstanceId == ((PackedInternalDoubleHistogram)this.activeHistogram).containingInstanceId)) {
            bl3 = false;
        }
        if (bl3) {
            throw new IllegalArgumentException("replacement histogram must have been obtained via a previous getIntervalHistogram() call from this " + this.getClass().getName() + " instance");
        }
    }

    private class PackedInternalDoubleHistogram
    extends PackedDoubleHistogram {
        private final long containingInstanceId;

        private PackedInternalDoubleHistogram(long l2, int n2) {
            super(n2);
            this.containingInstanceId = l2;
        }
    }

    private class InternalDoubleHistogram
    extends DoubleHistogram {
        private final long containingInstanceId;

        private InternalDoubleHistogram(long l2, int n2) {
            super(n2);
            this.containingInstanceId = l2;
        }

        private InternalDoubleHistogram(long l2, long l3, int n2) {
            super(l3, n2);
            this.containingInstanceId = l2;
        }

        private InternalDoubleHistogram(InternalDoubleHistogram internalDoubleHistogram) {
            super(internalDoubleHistogram);
            this.containingInstanceId = internalDoubleHistogram.containingInstanceId;
        }
    }
}

