/*
 * Decompiled with CFR 0.152.
 */
package org.HdrHistogram;

import java.util.concurrent.atomic.AtomicLong;
import org.HdrHistogram.AtomicHistogram;
import org.HdrHistogram.ConcurrentHistogram;
import org.HdrHistogram.Histogram;
import org.HdrHistogram.PackedConcurrentHistogram;
import org.HdrHistogram.ValueRecorder;
import org.HdrHistogram.WriterReaderPhaser;

public class Recorder
implements ValueRecorder {
    private static AtomicLong instanceIdSequencer = new AtomicLong(1L);
    private final long instanceId = instanceIdSequencer.getAndIncrement();
    private final WriterReaderPhaser recordingPhaser = new WriterReaderPhaser();
    private volatile Histogram activeHistogram;
    private Histogram inactiveHistogram;

    public Recorder(int n2, boolean bl2) {
        this.activeHistogram = bl2 ? new InternalPackedConcurrentHistogram(this.instanceId, n2) : new InternalConcurrentHistogram(this.instanceId, n2);
        this.inactiveHistogram = null;
        this.activeHistogram.setStartTimeStamp(System.currentTimeMillis());
    }

    public Recorder(int n2) {
        this(n2, false);
    }

    public Recorder(long l2, int n2) {
        this(1L, l2, n2);
    }

    public Recorder(long l2, long l3, int n2) {
        this.activeHistogram = new InternalAtomicHistogram(this.instanceId, l2, l3, n2);
        this.inactiveHistogram = null;
        this.activeHistogram.setStartTimeStamp(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recordValue(long l2) throws ArrayIndexOutOfBoundsException {
        long l3 = this.recordingPhaser.writerCriticalSectionEnter();
        try {
            this.activeHistogram.recordValue(l2);
        }
        finally {
            this.recordingPhaser.writerCriticalSectionExit(l3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recordValueWithCount(long l2, long l3) throws ArrayIndexOutOfBoundsException {
        long l4 = this.recordingPhaser.writerCriticalSectionEnter();
        try {
            this.activeHistogram.recordValueWithCount(l2, l3);
        }
        finally {
            this.recordingPhaser.writerCriticalSectionExit(l4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recordValueWithExpectedInterval(long l2, long l3) throws ArrayIndexOutOfBoundsException {
        long l4 = this.recordingPhaser.writerCriticalSectionEnter();
        try {
            this.activeHistogram.recordValueWithExpectedInterval(l2, l3);
        }
        finally {
            this.recordingPhaser.writerCriticalSectionExit(l4);
        }
    }

    public synchronized Histogram getIntervalHistogram() {
        return this.getIntervalHistogram(null);
    }

    public synchronized Histogram getIntervalHistogram(Histogram histogram) {
        return this.getIntervalHistogram(histogram, true);
    }

    public synchronized Histogram getIntervalHistogram(Histogram histogram, boolean bl2) {
        this.validateFitAsReplacementHistogram(histogram, bl2);
        this.inactiveHistogram = histogram;
        this.performIntervalSample();
        Histogram histogram2 = this.inactiveHistogram;
        this.inactiveHistogram = null;
        return histogram2;
    }

    public synchronized void getIntervalHistogramInto(Histogram histogram) {
        this.performIntervalSample();
        this.inactiveHistogram.copyInto(histogram);
    }

    @Override
    public synchronized void reset() {
        this.performIntervalSample();
        this.performIntervalSample();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performIntervalSample() {
        try {
            this.recordingPhaser.readerLock();
            if (this.inactiveHistogram == null) {
                if (this.activeHistogram instanceof InternalAtomicHistogram) {
                    this.inactiveHistogram = new InternalAtomicHistogram(this.instanceId, this.activeHistogram.getLowestDiscernibleValue(), this.activeHistogram.getHighestTrackableValue(), this.activeHistogram.getNumberOfSignificantValueDigits());
                } else if (this.activeHistogram instanceof InternalConcurrentHistogram) {
                    this.inactiveHistogram = new InternalConcurrentHistogram(this.instanceId, this.activeHistogram.getNumberOfSignificantValueDigits());
                } else if (this.activeHistogram instanceof InternalPackedConcurrentHistogram) {
                    this.inactiveHistogram = new InternalPackedConcurrentHistogram(this.instanceId, this.activeHistogram.getNumberOfSignificantValueDigits());
                } else {
                    throw new IllegalStateException("Unexpected internal histogram type for activeHistogram");
                }
            }
            this.inactiveHistogram.reset();
            Histogram histogram = this.inactiveHistogram;
            this.inactiveHistogram = this.activeHistogram;
            this.activeHistogram = histogram;
            long l2 = System.currentTimeMillis();
            this.activeHistogram.setStartTimeStamp(l2);
            this.inactiveHistogram.setEndTimeStamp(l2);
            this.recordingPhaser.flipPhase(500000L);
        }
        finally {
            this.recordingPhaser.readerUnlock();
        }
    }

    private void validateFitAsReplacementHistogram(Histogram histogram, boolean bl2) {
        boolean bl3 = true;
        if (histogram == null) {
            bl3 = false;
        } else if (histogram instanceof InternalAtomicHistogram) {
            if (this.activeHistogram instanceof InternalAtomicHistogram && (!bl2 || ((InternalAtomicHistogram)histogram).containingInstanceId == ((InternalAtomicHistogram)this.activeHistogram).containingInstanceId)) {
                bl3 = false;
            }
        } else if (histogram instanceof InternalConcurrentHistogram) {
            if (this.activeHistogram instanceof InternalConcurrentHistogram && (!bl2 || ((InternalConcurrentHistogram)histogram).containingInstanceId == ((InternalConcurrentHistogram)this.activeHistogram).containingInstanceId)) {
                bl3 = false;
            }
        } else if (histogram instanceof InternalPackedConcurrentHistogram && this.activeHistogram instanceof InternalPackedConcurrentHistogram && (!bl2 || ((InternalPackedConcurrentHistogram)histogram).containingInstanceId == ((InternalPackedConcurrentHistogram)this.activeHistogram).containingInstanceId)) {
            bl3 = false;
        }
        if (bl3) {
            throw new IllegalArgumentException("replacement histogram must have been obtained via a previous getIntervalHistogram() call from this " + this.getClass().getName() + (bl2 ? " insatnce" : " class"));
        }
    }

    private static class InternalPackedConcurrentHistogram
    extends PackedConcurrentHistogram {
        private final long containingInstanceId;

        private InternalPackedConcurrentHistogram(long l2, int n2) {
            super(n2);
            this.containingInstanceId = l2;
        }
    }

    private static class InternalConcurrentHistogram
    extends ConcurrentHistogram {
        private final long containingInstanceId;

        private InternalConcurrentHistogram(long l2, int n2) {
            super(n2);
            this.containingInstanceId = l2;
        }
    }

    private static class InternalAtomicHistogram
    extends AtomicHistogram {
        private final long containingInstanceId;

        private InternalAtomicHistogram(long l2, long l3, long l4, int n2) {
            super(l3, l4, n2);
            this.containingInstanceId = l2;
        }
    }
}

