/*
 * Decompiled with CFR 0.152.
 */
package org.HdrHistogram;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.zip.DataFormatException;
import org.HdrHistogram.AbstractHistogram;
import org.HdrHistogram.Base64Helper;
import org.HdrHistogram.Histogram;
import org.HdrHistogram.WriterReaderPhaser;

public class ConcurrentHistogram
extends Histogram {
    static final AtomicLongFieldUpdater<ConcurrentHistogram> totalCountUpdater = AtomicLongFieldUpdater.newUpdater(ConcurrentHistogram.class, "totalCount");
    volatile long totalCount;
    volatile ConcurrentArrayWithNormalizingOffset activeCounts;
    volatile ConcurrentArrayWithNormalizingOffset inactiveCounts;
    transient WriterReaderPhaser wrp = new WriterReaderPhaser();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void setIntegerToDoubleValueConversionRatio(double d2) {
        try {
            this.wrp.readerLock();
            this.inactiveCounts.setDoubleToIntegerValueConversionRatio(1.0 / d2);
            ConcurrentArrayWithNormalizingOffset concurrentArrayWithNormalizingOffset = this.activeCounts;
            this.activeCounts = this.inactiveCounts;
            this.inactiveCounts = concurrentArrayWithNormalizingOffset;
            this.wrp.flipPhase();
            this.inactiveCounts.setDoubleToIntegerValueConversionRatio(1.0 / d2);
            concurrentArrayWithNormalizingOffset = this.activeCounts;
            this.activeCounts = this.inactiveCounts;
            this.inactiveCounts = concurrentArrayWithNormalizingOffset;
            this.wrp.flipPhase();
        }
        finally {
            this.wrp.readerUnlock();
        }
        super.setIntegerToDoubleValueConversionRatio(d2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    long getCountAtIndex(int n2) {
        try {
            this.wrp.readerLock();
            assert (this.countsArrayLength == this.activeCounts.length());
            assert (this.countsArrayLength == this.inactiveCounts.length());
            long l2 = this.activeCounts.get(this.normalizeIndex(n2, this.activeCounts.getNormalizingIndexOffset(), this.activeCounts.length()));
            long l3 = this.inactiveCounts.get(this.normalizeIndex(n2, this.inactiveCounts.getNormalizingIndexOffset(), this.inactiveCounts.length()));
            long l4 = l2 + l3;
            return l4;
        }
        finally {
            this.wrp.readerUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    long getCountAtNormalizedIndex(int n2) {
        try {
            this.wrp.readerLock();
            assert (this.countsArrayLength == this.activeCounts.length());
            assert (this.countsArrayLength == this.inactiveCounts.length());
            long l2 = this.activeCounts.get(n2);
            long l3 = this.inactiveCounts.get(n2);
            long l4 = l2 + l3;
            return l4;
        }
        finally {
            this.wrp.readerUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void incrementCountAtIndex(int n2) {
        long l2 = this.wrp.writerCriticalSectionEnter();
        try {
            this.activeCounts.atomicIncrement(this.normalizeIndex(n2, this.activeCounts.getNormalizingIndexOffset(), this.activeCounts.length()));
        }
        finally {
            this.wrp.writerCriticalSectionExit(l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void addToCountAtIndex(int n2, long l2) {
        long l3 = this.wrp.writerCriticalSectionEnter();
        try {
            this.activeCounts.atomicAdd(this.normalizeIndex(n2, this.activeCounts.getNormalizingIndexOffset(), this.activeCounts.length()), l2);
        }
        finally {
            this.wrp.writerCriticalSectionExit(l3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void setCountAtIndex(int n2, long l2) {
        try {
            this.wrp.readerLock();
            assert (this.countsArrayLength == this.activeCounts.length());
            assert (this.countsArrayLength == this.inactiveCounts.length());
            this.activeCounts.lazySet(this.normalizeIndex(n2, this.activeCounts.getNormalizingIndexOffset(), this.activeCounts.length()), l2);
            this.inactiveCounts.lazySet(this.normalizeIndex(n2, this.inactiveCounts.getNormalizingIndexOffset(), this.inactiveCounts.length()), 0L);
        }
        finally {
            this.wrp.readerUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void setCountAtNormalizedIndex(int n2, long l2) {
        try {
            this.wrp.readerLock();
            assert (this.countsArrayLength == this.activeCounts.length());
            assert (this.countsArrayLength == this.inactiveCounts.length());
            this.inactiveCounts.lazySet(n2, l2);
            this.activeCounts.lazySet(n2, 0L);
        }
        finally {
            this.wrp.readerUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void recordConvertedDoubleValue(double d2) {
        long l2 = this.wrp.writerCriticalSectionEnter();
        try {
            long l3 = (long)(d2 * this.activeCounts.getDoubleToIntegerValueConversionRatio());
            int n2 = this.countsArrayIndex(l3);
            this.activeCounts.atomicIncrement(this.normalizeIndex(n2, this.activeCounts.getNormalizingIndexOffset(), this.activeCounts.length()));
            this.updateMinAndMax(l3);
            this.incrementTotalCount();
        }
        finally {
            this.wrp.writerCriticalSectionExit(l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recordConvertedDoubleValueWithCount(double d2, long l2) throws ArrayIndexOutOfBoundsException {
        long l3 = this.wrp.writerCriticalSectionEnter();
        try {
            long l4 = (long)(d2 * this.activeCounts.getDoubleToIntegerValueConversionRatio());
            int n2 = this.countsArrayIndex(l4);
            this.activeCounts.atomicAdd(this.normalizeIndex(n2, this.activeCounts.getNormalizingIndexOffset(), this.activeCounts.length()), l2);
            this.updateMinAndMax(l4);
            this.addToTotalCount(l2);
        }
        finally {
            this.wrp.writerCriticalSectionExit(l3);
        }
    }

    @Override
    int getNormalizingIndexOffset() {
        return this.activeCounts.getNormalizingIndexOffset();
    }

    @Override
    void setNormalizingIndexOffset(int n2) {
        this.setNormalizingIndexOffset(n2, 0, false, this.getIntegerToDoubleValueConversionRatio());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setNormalizingIndexOffset(int n2, int n3, boolean bl2, double d2) {
        try {
            this.wrp.readerLock();
            assert (this.countsArrayLength == this.activeCounts.length());
            assert (this.countsArrayLength == this.inactiveCounts.length());
            assert (this.activeCounts.getNormalizingIndexOffset() == this.inactiveCounts.getNormalizingIndexOffset());
            if (n2 == this.activeCounts.getNormalizingIndexOffset()) {
                return;
            }
            this.setNormalizingIndexOffsetForInactive(n2, n3, bl2, d2);
            ConcurrentArrayWithNormalizingOffset concurrentArrayWithNormalizingOffset = this.activeCounts;
            this.activeCounts = this.inactiveCounts;
            this.inactiveCounts = concurrentArrayWithNormalizingOffset;
            this.wrp.flipPhase();
            this.setNormalizingIndexOffsetForInactive(n2, n3, bl2, d2);
            concurrentArrayWithNormalizingOffset = this.activeCounts;
            this.activeCounts = this.inactiveCounts;
            this.inactiveCounts = concurrentArrayWithNormalizingOffset;
            this.wrp.flipPhase();
        }
        finally {
            this.wrp.readerUnlock();
        }
    }

    private void setNormalizingIndexOffsetForInactive(int n2, int n3, boolean bl2, double d2) {
        int n4 = this.normalizeIndex(0, this.inactiveCounts.getNormalizingIndexOffset(), this.inactiveCounts.length());
        long l2 = this.inactiveCounts.get(n4);
        this.inactiveCounts.lazySet(n4, 0L);
        this.inactiveCounts.setNormalizingIndexOffset(n2);
        if (n3 > 0 && bl2) {
            this.shiftLowestInactiveHalfBucketContentsLeft(n3, n4);
        }
        n4 = this.normalizeIndex(0, this.inactiveCounts.getNormalizingIndexOffset(), this.inactiveCounts.length());
        this.inactiveCounts.lazySet(n4, l2);
        this.inactiveCounts.setDoubleToIntegerValueConversionRatio(1.0 / d2);
    }

    private void shiftLowestInactiveHalfBucketContentsLeft(int n2, int n3) {
        int n4 = n2 >> this.subBucketHalfCountMagnitude;
        for (int i2 = 1; i2 < this.subBucketHalfCount; ++i2) {
            long l2 = this.valueFromIndex(i2) << n4;
            int n5 = this.countsArrayIndex(l2);
            int n6 = this.normalizeIndex(n5, this.inactiveCounts.getNormalizingIndexOffset(), this.inactiveCounts.length());
            long l3 = this.inactiveCounts.get(i2 + n3);
            this.inactiveCounts.lazySet(n6, l3);
            this.inactiveCounts.lazySet(i2 + n3, 0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void shiftNormalizingIndexByOffset(int n2, boolean bl2, double d2) {
        try {
            this.wrp.readerLock();
            assert (this.countsArrayLength == this.activeCounts.length());
            assert (this.countsArrayLength == this.inactiveCounts.length());
            int n3 = this.getNormalizingIndexOffset() + n2;
            this.setNormalizingIndexOffset(n3, n2, bl2, d2);
        }
        finally {
            this.wrp.readerUnlock();
        }
    }

    ConcurrentArrayWithNormalizingOffset allocateArray(int n2, int n3) {
        return new AtomicLongArrayWithNormalizingOffset(n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void resize(long l2) {
        try {
            this.wrp.readerLock();
            assert (this.countsArrayLength == this.activeCounts.length());
            assert (this.countsArrayLength == this.inactiveCounts.length());
            int n2 = this.determineArrayLengthNeeded(l2);
            int n3 = n2 - this.countsArrayLength;
            if (n3 <= 0) {
                return;
            }
            ConcurrentArrayWithNormalizingOffset concurrentArrayWithNormalizingOffset = this.allocateArray(n2, this.inactiveCounts.getNormalizingIndexOffset());
            ConcurrentArrayWithNormalizingOffset concurrentArrayWithNormalizingOffset2 = this.allocateArray(n2, this.activeCounts.getNormalizingIndexOffset());
            ConcurrentArrayWithNormalizingOffset concurrentArrayWithNormalizingOffset3 = this.inactiveCounts;
            this.inactiveCounts = concurrentArrayWithNormalizingOffset;
            this.copyInactiveCountsContentsOnResize(concurrentArrayWithNormalizingOffset3, n3);
            ConcurrentArrayWithNormalizingOffset concurrentArrayWithNormalizingOffset4 = this.activeCounts;
            this.activeCounts = this.inactiveCounts;
            this.inactiveCounts = concurrentArrayWithNormalizingOffset4;
            this.wrp.flipPhase();
            concurrentArrayWithNormalizingOffset3 = this.inactiveCounts;
            this.inactiveCounts = concurrentArrayWithNormalizingOffset2;
            this.copyInactiveCountsContentsOnResize(concurrentArrayWithNormalizingOffset3, n3);
            concurrentArrayWithNormalizingOffset4 = this.activeCounts;
            this.activeCounts = this.inactiveCounts;
            this.inactiveCounts = concurrentArrayWithNormalizingOffset4;
            this.wrp.flipPhase();
            this.establishSize(l2);
            assert (this.countsArrayLength == this.activeCounts.length());
            assert (this.countsArrayLength == this.inactiveCounts.length());
        }
        finally {
            this.wrp.readerUnlock();
        }
    }

    void copyInactiveCountsContentsOnResize(ConcurrentArrayWithNormalizingOffset concurrentArrayWithNormalizingOffset, int n2) {
        int n3 = this.normalizeIndex(0, concurrentArrayWithNormalizingOffset.getNormalizingIndexOffset(), concurrentArrayWithNormalizingOffset.length());
        if (n3 == 0) {
            for (int i2 = 0; i2 < concurrentArrayWithNormalizingOffset.length(); ++i2) {
                this.inactiveCounts.lazySet(i2, concurrentArrayWithNormalizingOffset.get(i2));
            }
        } else {
            int n4;
            for (n4 = 0; n4 < n3; ++n4) {
                this.inactiveCounts.lazySet(n4, concurrentArrayWithNormalizingOffset.get(n4));
            }
            for (n4 = n3; n4 < concurrentArrayWithNormalizingOffset.length(); ++n4) {
                int n5 = n4 + n2;
                this.inactiveCounts.lazySet(n5, concurrentArrayWithNormalizingOffset.get(n4));
            }
        }
    }

    @Override
    public void setAutoResize(boolean bl2) {
        this.autoResize = true;
    }

    @Override
    void clearCounts() {
        try {
            this.wrp.readerLock();
            assert (this.countsArrayLength == this.activeCounts.length());
            assert (this.countsArrayLength == this.inactiveCounts.length());
            for (int i2 = 0; i2 < this.activeCounts.length(); ++i2) {
                this.activeCounts.lazySet(i2, 0L);
                this.inactiveCounts.lazySet(i2, 0L);
            }
            totalCountUpdater.set(this, 0L);
        }
        finally {
            this.wrp.readerUnlock();
        }
    }

    @Override
    public ConcurrentHistogram copy() {
        ConcurrentHistogram concurrentHistogram = new ConcurrentHistogram(this);
        concurrentHistogram.add(this);
        return concurrentHistogram;
    }

    @Override
    public ConcurrentHistogram copyCorrectedForCoordinatedOmission(long l2) {
        ConcurrentHistogram concurrentHistogram = new ConcurrentHistogram(this);
        concurrentHistogram.addWhileCorrectingForCoordinatedOmission(this, l2);
        return concurrentHistogram;
    }

    @Override
    public long getTotalCount() {
        return totalCountUpdater.get(this);
    }

    @Override
    void setTotalCount(long l2) {
        totalCountUpdater.set(this, l2);
    }

    @Override
    void incrementTotalCount() {
        totalCountUpdater.incrementAndGet(this);
    }

    @Override
    void addToTotalCount(long l2) {
        totalCountUpdater.addAndGet(this, l2);
    }

    @Override
    int _getEstimatedFootprintInBytes() {
        return 512 + 16 * this.activeCounts.length();
    }

    public ConcurrentHistogram(int n2) {
        this(1L, 2L, n2);
        this.setAutoResize(true);
    }

    public ConcurrentHistogram(long l2, int n2) {
        this(1L, l2, n2);
    }

    public ConcurrentHistogram(long l2, long l3, int n2) {
        this(l2, l3, n2, true);
    }

    public ConcurrentHistogram(AbstractHistogram abstractHistogram) {
        this(abstractHistogram, true);
    }

    ConcurrentHistogram(AbstractHistogram abstractHistogram, boolean bl2) {
        super(abstractHistogram, false);
        if (bl2) {
            this.activeCounts = new AtomicLongArrayWithNormalizingOffset(this.countsArrayLength, 0);
            this.inactiveCounts = new AtomicLongArrayWithNormalizingOffset(this.countsArrayLength, 0);
        }
        this.wordSizeInBytes = 8;
    }

    ConcurrentHistogram(long l2, long l3, int n2, boolean bl2) {
        super(l2, l3, n2, false);
        if (bl2) {
            this.activeCounts = new AtomicLongArrayWithNormalizingOffset(this.countsArrayLength, 0);
            this.inactiveCounts = new AtomicLongArrayWithNormalizingOffset(this.countsArrayLength, 0);
        }
        this.wordSizeInBytes = 8;
    }

    public static ConcurrentHistogram decodeFromByteBuffer(ByteBuffer byteBuffer, long l2) {
        return ConcurrentHistogram.decodeFromByteBuffer(byteBuffer, ConcurrentHistogram.class, l2);
    }

    public static ConcurrentHistogram decodeFromCompressedByteBuffer(ByteBuffer byteBuffer, long l2) throws DataFormatException {
        return ConcurrentHistogram.decodeFromCompressedByteBuffer(byteBuffer, ConcurrentHistogram.class, l2);
    }

    public static ConcurrentHistogram fromString(String string) throws DataFormatException {
        return ConcurrentHistogram.decodeFromCompressedByteBuffer(ByteBuffer.wrap(Base64Helper.parseBase64Binary(string)), 0L);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.wrp = new WriterReaderPhaser();
    }

    @Override
    synchronized void fillBufferFromCountsArray(ByteBuffer byteBuffer) {
        try {
            this.wrp.readerLock();
            super.fillBufferFromCountsArray(byteBuffer);
        }
        finally {
            this.wrp.readerUnlock();
        }
    }

    static class AtomicLongArrayWithNormalizingOffset
    extends AtomicLongArray
    implements ConcurrentArrayWithNormalizingOffset {
        private int normalizingIndexOffset;
        private double doubleToIntegerValueConversionRatio;

        AtomicLongArrayWithNormalizingOffset(int n2, int n3) {
            super(n2);
            this.normalizingIndexOffset = n3;
        }

        @Override
        public int getNormalizingIndexOffset() {
            return this.normalizingIndexOffset;
        }

        @Override
        public void setNormalizingIndexOffset(int n2) {
            this.normalizingIndexOffset = n2;
        }

        @Override
        public double getDoubleToIntegerValueConversionRatio() {
            return this.doubleToIntegerValueConversionRatio;
        }

        @Override
        public void setDoubleToIntegerValueConversionRatio(double d2) {
            this.doubleToIntegerValueConversionRatio = d2;
        }

        @Override
        public int getEstimatedFootprintInBytes() {
            return 256 + 8 * this.length();
        }

        @Override
        public void atomicIncrement(int n2) {
            this.incrementAndGet(n2);
        }

        @Override
        public void atomicAdd(int n2, long l2) {
            this.addAndGet(n2, l2);
        }
    }

    static interface ConcurrentArrayWithNormalizingOffset {
        public int getNormalizingIndexOffset();

        public void setNormalizingIndexOffset(int var1);

        public double getDoubleToIntegerValueConversionRatio();

        public void setDoubleToIntegerValueConversionRatio(double var1);

        public int getEstimatedFootprintInBytes();

        public long get(int var1);

        public void atomicIncrement(int var1);

        public void atomicAdd(int var1, long var2);

        public void lazySet(int var1, long var2);

        public int length();
    }
}

