/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.platform;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import javax.annotation.Nullable;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Protocol;
import okhttp3.internal.Util;
import okhttp3.internal.platform.Platform;

final class Jdk9Platform
extends Platform {
    final Method setProtocolMethod;
    final Method getProtocolMethod;

    Jdk9Platform(Method method, Method method2) {
        this.setProtocolMethod = method;
        this.getProtocolMethod = method2;
    }

    @Override
    public void configureTlsExtensions(SSLSocket sSLSocket, String string, List<Protocol> list) {
        try {
            SSLParameters sSLParameters = sSLSocket.getSSLParameters();
            List<String> list2 = Jdk9Platform.alpnProtocolNames(list);
            this.setProtocolMethod.invoke((Object)sSLParameters, new Object[]{list2.toArray(new String[list2.size()])});
            sSLSocket.setSSLParameters(sSLParameters);
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            throw Util.assertionError("unable to set ssl parameters", reflectiveOperationException);
        }
    }

    @Override
    @Nullable
    public String getSelectedProtocol(SSLSocket sSLSocket) {
        try {
            String string = (String)this.getProtocolMethod.invoke((Object)sSLSocket, new Object[0]);
            if (string == null || string.equals("")) {
                return null;
            }
            return string;
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            throw Util.assertionError("unable to get selected protocols", reflectiveOperationException);
        }
    }

    @Override
    public X509TrustManager trustManager(SSLSocketFactory sSLSocketFactory) {
        throw new UnsupportedOperationException("clientBuilder.sslSocketFactory(SSLSocketFactory) not supported on JDK 9+");
    }

    public static Jdk9Platform buildIfSupported() {
        try {
            Method method = SSLParameters.class.getMethod("setApplicationProtocols", String[].class);
            Method method2 = SSLSocket.class.getMethod("getApplicationProtocol", new Class[0]);
            return new Jdk9Platform(method, method2);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }
}

