/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import java.util.Arrays;

public final class Settings {
    static final int DEFAULT_INITIAL_WINDOW_SIZE = 65535;
    static final int HEADER_TABLE_SIZE = 1;
    static final int ENABLE_PUSH = 2;
    static final int MAX_CONCURRENT_STREAMS = 4;
    static final int MAX_FRAME_SIZE = 5;
    static final int MAX_HEADER_LIST_SIZE = 6;
    static final int INITIAL_WINDOW_SIZE = 7;
    static final int COUNT = 10;
    private int set;
    private final int[] values = new int[10];

    void clear() {
        this.set = 0;
        Arrays.fill(this.values, 0);
    }

    Settings set(int n2, int n3) {
        if (n2 < 0 || n2 >= this.values.length) {
            return this;
        }
        int n4 = 1 << n2;
        this.set |= n4;
        this.values[n2] = n3;
        return this;
    }

    boolean isSet(int n2) {
        int n3 = 1 << n2;
        return (this.set & n3) != 0;
    }

    int get(int n2) {
        return this.values[n2];
    }

    int size() {
        return Integer.bitCount(this.set);
    }

    int getHeaderTableSize() {
        int n2 = 2;
        return (n2 & this.set) != 0 ? this.values[1] : -1;
    }

    boolean getEnablePush(boolean bl2) {
        int n2 = 4;
        return ((n2 & this.set) != 0 ? this.values[2] : (bl2 ? 1 : 0)) == 1;
    }

    int getMaxConcurrentStreams(int n2) {
        int n3 = 16;
        return (n3 & this.set) != 0 ? this.values[4] : n2;
    }

    int getMaxFrameSize(int n2) {
        int n3 = 32;
        return (n3 & this.set) != 0 ? this.values[5] : n2;
    }

    int getMaxHeaderListSize(int n2) {
        int n3 = 64;
        return (n3 & this.set) != 0 ? this.values[6] : n2;
    }

    int getInitialWindowSize() {
        int n2 = 128;
        return (n2 & this.set) != 0 ? this.values[7] : 65535;
    }

    void merge(Settings settings) {
        for (int i2 = 0; i2 < 10; ++i2) {
            if (!settings.isSet(i2)) continue;
            this.set(i2, settings.get(i2));
        }
    }
}

