/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import okhttp3.internal.Util;
import okio.ByteString;

public final class Header {
    public static final ByteString PSEUDO_PREFIX = ByteString.encodeUtf8(":");
    public static final ByteString RESPONSE_STATUS = ByteString.encodeUtf8(":status");
    public static final ByteString TARGET_METHOD = ByteString.encodeUtf8(":method");
    public static final ByteString TARGET_PATH = ByteString.encodeUtf8(":path");
    public static final ByteString TARGET_SCHEME = ByteString.encodeUtf8(":scheme");
    public static final ByteString TARGET_AUTHORITY = ByteString.encodeUtf8(":authority");
    public final ByteString name;
    public final ByteString value;
    final int hpackSize;

    public Header(String string, String string2) {
        this(ByteString.encodeUtf8(string), ByteString.encodeUtf8(string2));
    }

    public Header(ByteString byteString, String string) {
        this(byteString, ByteString.encodeUtf8(string));
    }

    public Header(ByteString byteString, ByteString byteString2) {
        this.name = byteString;
        this.value = byteString2;
        this.hpackSize = 32 + byteString.size() + byteString2.size();
    }

    public boolean equals(Object object) {
        if (object instanceof Header) {
            Header header = (Header)object;
            return this.name.equals(header.name) && this.value.equals(header.value);
        }
        return false;
    }

    public int hashCode() {
        int n2 = 17;
        n2 = 31 * n2 + this.name.hashCode();
        n2 = 31 * n2 + this.value.hashCode();
        return n2;
    }

    public String toString() {
        return Util.format("%s: %s", this.name.utf8(), this.value.utf8());
    }
}

