/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.HttpRetryException;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.security.cert.CertificateException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocketFactory;
import okhttp3.Address;
import okhttp3.Call;
import okhttp3.CertificatePinner;
import okhttp3.EventListener;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.Route;
import okhttp3.internal.Util;
import okhttp3.internal.connection.RouteException;
import okhttp3.internal.connection.StreamAllocation;
import okhttp3.internal.http.HttpMethod;
import okhttp3.internal.http.RealInterceptorChain;
import okhttp3.internal.http.UnrepeatableRequestBody;
import okhttp3.internal.http2.ConnectionShutdownException;

public final class RetryAndFollowUpInterceptor
implements Interceptor {
    private static final int MAX_FOLLOW_UPS = 20;
    private final OkHttpClient client;
    private final boolean forWebSocket;
    private volatile StreamAllocation streamAllocation;
    private Object callStackTrace;
    private volatile boolean canceled;

    public RetryAndFollowUpInterceptor(OkHttpClient okHttpClient, boolean bl2) {
        this.client = okHttpClient;
        this.forWebSocket = bl2;
    }

    public void cancel() {
        this.canceled = true;
        StreamAllocation streamAllocation = this.streamAllocation;
        if (streamAllocation != null) {
            streamAllocation.cancel();
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void setCallStackTrace(Object object) {
        this.callStackTrace = object;
    }

    public StreamAllocation streamAllocation() {
        return this.streamAllocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response intercept(Interceptor.Chain chain) throws IOException {
        StreamAllocation streamAllocation;
        Request request = chain.request();
        RealInterceptorChain realInterceptorChain = (RealInterceptorChain)chain;
        Call call = realInterceptorChain.call();
        EventListener eventListener = realInterceptorChain.eventListener();
        this.streamAllocation = streamAllocation = new StreamAllocation(this.client.connectionPool(), this.createAddress(request.url()), call, eventListener, this.callStackTrace);
        int n2 = 0;
        Response response = null;
        while (true) {
            Request request2;
            Response response2;
            if (this.canceled) {
                streamAllocation.release();
                throw new IOException("Canceled");
            }
            boolean bl2 = true;
            try {
                response2 = realInterceptorChain.proceed(request, streamAllocation, null, null);
                bl2 = false;
            }
            catch (RouteException routeException) {
                if (!this.recover(routeException.getLastConnectException(), streamAllocation, false, request)) {
                    throw routeException.getLastConnectException();
                }
                bl2 = false;
                continue;
            }
            catch (IOException iOException) {
                boolean bl3;
                boolean bl4 = bl3 = !(iOException instanceof ConnectionShutdownException);
                if (!this.recover(iOException, streamAllocation, bl3, request)) {
                    throw iOException;
                }
                bl2 = false;
                continue;
            }
            finally {
                if (!bl2) continue;
                streamAllocation.streamFailed(null);
                streamAllocation.release();
                continue;
            }
            if (response != null) {
                response2 = response2.newBuilder().priorResponse(response.newBuilder().body(null).build()).build();
            }
            if ((request2 = this.followUpRequest(response2, streamAllocation.route())) == null) {
                if (!this.forWebSocket) {
                    streamAllocation.release();
                }
                return response2;
            }
            Util.closeQuietly(response2.body());
            if (++n2 > 20) {
                streamAllocation.release();
                throw new ProtocolException("Too many follow-up requests: " + n2);
            }
            if (request2.body() instanceof UnrepeatableRequestBody) {
                streamAllocation.release();
                throw new HttpRetryException("Cannot retry streamed HTTP body", response2.code());
            }
            if (!this.sameConnection(response2, request2.url())) {
                streamAllocation.release();
                this.streamAllocation = streamAllocation = new StreamAllocation(this.client.connectionPool(), this.createAddress(request2.url()), call, eventListener, this.callStackTrace);
            } else if (streamAllocation.codec() != null) {
                throw new IllegalStateException("Closing the body of " + response2 + " didn't close its backing stream. Bad interceptor?");
            }
            request = request2;
            response = response2;
        }
    }

    private Address createAddress(HttpUrl httpUrl) {
        SSLSocketFactory sSLSocketFactory = null;
        HostnameVerifier hostnameVerifier = null;
        CertificatePinner certificatePinner = null;
        if (httpUrl.isHttps()) {
            sSLSocketFactory = this.client.sslSocketFactory();
            hostnameVerifier = this.client.hostnameVerifier();
            certificatePinner = this.client.certificatePinner();
        }
        return new Address(httpUrl.host(), httpUrl.port(), this.client.dns(), this.client.socketFactory(), sSLSocketFactory, hostnameVerifier, certificatePinner, this.client.proxyAuthenticator(), this.client.proxy(), this.client.protocols(), this.client.connectionSpecs(), this.client.proxySelector());
    }

    private boolean recover(IOException iOException, StreamAllocation streamAllocation, boolean bl2, Request request) {
        streamAllocation.streamFailed(iOException);
        if (!this.client.retryOnConnectionFailure()) {
            return false;
        }
        if (bl2 && request.body() instanceof UnrepeatableRequestBody) {
            return false;
        }
        if (!this.isRecoverable(iOException, bl2)) {
            return false;
        }
        return streamAllocation.hasMoreRoutes();
    }

    private boolean isRecoverable(IOException iOException, boolean bl2) {
        if (iOException instanceof ProtocolException) {
            return false;
        }
        if (iOException instanceof InterruptedIOException) {
            return iOException instanceof SocketTimeoutException && !bl2;
        }
        if (iOException instanceof SSLHandshakeException && iOException.getCause() instanceof CertificateException) {
            return false;
        }
        return !(iOException instanceof SSLPeerUnverifiedException);
    }

    private Request followUpRequest(Response response, Route route) throws IOException {
        if (response == null) {
            throw new IllegalStateException();
        }
        int n2 = response.code();
        String string = response.request().method();
        switch (n2) {
            case 407: {
                Proxy proxy;
                Proxy proxy2 = proxy = route != null ? route.proxy() : this.client.proxy();
                if (proxy.type() != Proxy.Type.HTTP) {
                    throw new ProtocolException("Received HTTP_PROXY_AUTH (407) code while not using proxy");
                }
                return this.client.proxyAuthenticator().authenticate(route, response);
            }
            case 401: {
                return this.client.authenticator().authenticate(route, response);
            }
            case 307: 
            case 308: {
                if (!string.equals("GET") && !string.equals("HEAD")) {
                    return null;
                }
            }
            case 300: 
            case 301: 
            case 302: 
            case 303: {
                if (!this.client.followRedirects()) {
                    return null;
                }
                String string2 = response.header("Location");
                if (string2 == null) {
                    return null;
                }
                HttpUrl httpUrl = response.request().url().resolve(string2);
                if (httpUrl == null) {
                    return null;
                }
                boolean bl2 = httpUrl.scheme().equals(response.request().url().scheme());
                if (!bl2 && !this.client.followSslRedirects()) {
                    return null;
                }
                Request.Builder builder = response.request().newBuilder();
                if (HttpMethod.permitsRequestBody(string)) {
                    boolean bl3 = HttpMethod.redirectsWithBody(string);
                    if (HttpMethod.redirectsToGet(string)) {
                        builder.method("GET", null);
                    } else {
                        RequestBody requestBody = bl3 ? response.request().body() : null;
                        builder.method(string, requestBody);
                    }
                    if (!bl3) {
                        builder.removeHeader("Transfer-Encoding");
                        builder.removeHeader("Content-Length");
                        builder.removeHeader("Content-Type");
                    }
                }
                if (!this.sameConnection(response, httpUrl)) {
                    builder.removeHeader("Authorization");
                }
                return builder.url(httpUrl).build();
            }
            case 408: {
                if (!this.client.retryOnConnectionFailure()) {
                    return null;
                }
                if (response.request().body() instanceof UnrepeatableRequestBody) {
                    return null;
                }
                if (response.priorResponse() != null && response.priorResponse().code() == 408) {
                    return null;
                }
                if (this.retryAfter(response, 0) > 0) {
                    return null;
                }
                return response.request();
            }
            case 503: {
                if (response.priorResponse() != null && response.priorResponse().code() == 503) {
                    return null;
                }
                if (this.retryAfter(response, Integer.MAX_VALUE) == 0) {
                    return response.request();
                }
                return null;
            }
        }
        return null;
    }

    private int retryAfter(Response response, int n2) {
        String string = response.header("Retry-After");
        if (string == null) {
            return n2;
        }
        if (string.matches("\\d+")) {
            return Integer.valueOf(string);
        }
        return Integer.MAX_VALUE;
    }

    private boolean sameConnection(Response response, HttpUrl httpUrl) {
        HttpUrl httpUrl2 = response.request().url();
        return httpUrl2.host().equals(httpUrl.host()) && httpUrl2.port() == httpUrl.port() && httpUrl2.scheme().equals(httpUrl.scheme());
    }
}

