/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import okhttp3.Challenge;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.internal.Util;

public final class HttpHeaders {
    private static final String TOKEN = "([^ \"=]*)";
    private static final String QUOTED_STRING = "\"([^\"]*)\"";
    private static final Pattern PARAMETER = Pattern.compile(" +([^ \"=]*)=(:?\"([^\"]*)\"|([^ \"=]*)) *(:?,|$)");

    private HttpHeaders() {
    }

    public static long contentLength(Response response) {
        return HttpHeaders.contentLength(response.headers());
    }

    public static long contentLength(Headers headers) {
        return HttpHeaders.stringToLong(headers.get("Content-Length"));
    }

    private static long stringToLong(String string) {
        if (string == null) {
            return -1L;
        }
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1L;
        }
    }

    public static boolean varyMatches(Response response, Headers headers, Request request) {
        for (String string : HttpHeaders.varyFields(response)) {
            if (Util.equal(headers.values(string), request.headers(string))) continue;
            return false;
        }
        return true;
    }

    public static boolean hasVaryAll(Response response) {
        return HttpHeaders.hasVaryAll(response.headers());
    }

    public static boolean hasVaryAll(Headers headers) {
        return HttpHeaders.varyFields(headers).contains("*");
    }

    private static Set<String> varyFields(Response response) {
        return HttpHeaders.varyFields(response.headers());
    }

    public static Set<String> varyFields(Headers headers) {
        Set<String> set = Collections.emptySet();
        int n2 = headers.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!"Vary".equalsIgnoreCase(headers.name(i2))) continue;
            String string = headers.value(i2);
            if (set.isEmpty()) {
                set = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            }
            for (String string2 : string.split(",")) {
                set.add(string2.trim());
            }
        }
        return set;
    }

    public static Headers varyHeaders(Response response) {
        Headers headers = response.networkResponse().request().headers();
        Headers headers2 = response.headers();
        return HttpHeaders.varyHeaders(headers, headers2);
    }

    public static Headers varyHeaders(Headers headers, Headers headers2) {
        Set<String> set = HttpHeaders.varyFields(headers2);
        if (set.isEmpty()) {
            return new Headers.Builder().build();
        }
        Headers.Builder builder = new Headers.Builder();
        int n2 = headers.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = headers.name(i2);
            if (!set.contains(string)) continue;
            builder.add(string, headers.value(i2));
        }
        return builder.build();
    }

    public static List<Challenge> parseChallenges(Headers headers, String string) {
        ArrayList<Challenge> arrayList = new ArrayList<Challenge>();
        List<String> list = headers.values(string);
        for (String string2 : list) {
            int n2 = string2.indexOf(32);
            if (n2 == -1) continue;
            String string3 = string2.substring(0, n2);
            String string4 = null;
            String string5 = null;
            Matcher matcher = PARAMETER.matcher(string2);
            int n3 = n2;
            while (matcher.find(n3)) {
                if (string2.regionMatches(true, matcher.start(1), "realm", 0, 5)) {
                    string4 = matcher.group(3);
                } else if (string2.regionMatches(true, matcher.start(1), "charset", 0, 7)) {
                    string5 = matcher.group(3);
                }
                if (string4 != null && string5 != null) break;
                n3 = matcher.end();
            }
            if (string4 == null) continue;
            Challenge challenge = new Challenge(string3, string4);
            if (string5 != null) {
                if (!string5.equalsIgnoreCase("UTF-8")) continue;
                challenge = challenge.withCharset(Util.UTF_8);
            }
            arrayList.add(challenge);
        }
        return arrayList;
    }

    public static void receiveHeaders(CookieJar cookieJar, HttpUrl httpUrl, Headers headers) {
        if (cookieJar == CookieJar.NO_COOKIES) {
            return;
        }
        List<Cookie> list = Cookie.parseAll(httpUrl, headers);
        if (list.isEmpty()) {
            return;
        }
        cookieJar.saveFromResponse(httpUrl, list);
    }

    public static boolean hasBody(Response response) {
        if (response.request().method().equals("HEAD")) {
            return false;
        }
        int n2 = response.code();
        if ((n2 < 100 || n2 >= 200) && n2 != 204 && n2 != 304) {
            return true;
        }
        return HttpHeaders.contentLength(response) != -1L || "chunked".equalsIgnoreCase(response.header("Transfer-Encoding"));
    }

    public static int skipUntil(String string, int n2, String string2) {
        while (n2 < string.length() && string2.indexOf(string.charAt(n2)) == -1) {
            ++n2;
        }
        return n2;
    }

    public static int skipWhitespace(String string, int n2) {
        char c2;
        while (n2 < string.length() && ((c2 = string.charAt(n2)) == ' ' || c2 == '\t')) {
            ++n2;
        }
        return n2;
    }

    public static int parseSeconds(String string, int n2) {
        try {
            long l2 = Long.parseLong(string);
            if (l2 > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            if (l2 < 0L) {
                return 0;
            }
            return (int)l2;
        }
        catch (NumberFormatException numberFormatException) {
            return n2;
        }
    }
}

