/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.cache2;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import okhttp3.internal.Util;
import okhttp3.internal.cache2.FileOperator;
import okio.Buffer;
import okio.ByteString;
import okio.Source;
import okio.Timeout;

final class Relay {
    private static final int SOURCE_UPSTREAM = 1;
    private static final int SOURCE_FILE = 2;
    static final ByteString PREFIX_CLEAN = ByteString.encodeUtf8("OkHttp cache v1\n");
    static final ByteString PREFIX_DIRTY = ByteString.encodeUtf8("OkHttp DIRTY :(\n");
    private static final long FILE_HEADER_SIZE = 32L;
    RandomAccessFile file;
    Thread upstreamReader;
    Source upstream;
    final Buffer upstreamBuffer = new Buffer();
    long upstreamPos;
    boolean complete;
    private final ByteString metadata;
    final Buffer buffer = new Buffer();
    final long bufferMaxSize;
    int sourceCount;

    private Relay(RandomAccessFile randomAccessFile, Source source, long l2, ByteString byteString, long l3) {
        this.file = randomAccessFile;
        this.upstream = source;
        this.complete = source == null;
        this.upstreamPos = l2;
        this.metadata = byteString;
        this.bufferMaxSize = l3;
    }

    public static Relay edit(File file, Source source, ByteString byteString, long l2) throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
        Relay relay = new Relay(randomAccessFile, source, 0L, byteString, l2);
        randomAccessFile.setLength(0L);
        relay.writeHeader(PREFIX_DIRTY, -1L, -1L);
        return relay;
    }

    public static Relay read(File file) throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
        FileOperator fileOperator = new FileOperator(randomAccessFile.getChannel());
        Buffer buffer = new Buffer();
        fileOperator.read(0L, buffer, 32L);
        ByteString byteString = buffer.readByteString(PREFIX_CLEAN.size());
        if (!byteString.equals(PREFIX_CLEAN)) {
            throw new IOException("unreadable cache file");
        }
        long l2 = buffer.readLong();
        long l3 = buffer.readLong();
        Buffer buffer2 = new Buffer();
        fileOperator.read(32L + l2, buffer2, l3);
        ByteString byteString2 = buffer2.readByteString();
        return new Relay(randomAccessFile, null, l2, byteString2, 0L);
    }

    private void writeHeader(ByteString byteString, long l2, long l3) throws IOException {
        Buffer buffer = new Buffer();
        buffer.write(byteString);
        buffer.writeLong(l2);
        buffer.writeLong(l3);
        if (buffer.size() != 32L) {
            throw new IllegalArgumentException();
        }
        FileOperator fileOperator = new FileOperator(this.file.getChannel());
        fileOperator.write(0L, buffer, 32L);
    }

    private void writeMetadata(long l2) throws IOException {
        Buffer buffer = new Buffer();
        buffer.write(this.metadata);
        FileOperator fileOperator = new FileOperator(this.file.getChannel());
        fileOperator.write(32L + l2, buffer, this.metadata.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void commit(long l2) throws IOException {
        this.writeMetadata(l2);
        this.file.getChannel().force(false);
        this.writeHeader(PREFIX_CLEAN, l2, this.metadata.size());
        this.file.getChannel().force(false);
        Relay relay = this;
        synchronized (relay) {
            this.complete = true;
        }
        Util.closeQuietly(this.upstream);
        this.upstream = null;
    }

    boolean isClosed() {
        return this.file == null;
    }

    public ByteString metadata() {
        return this.metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Source newSource() {
        Relay relay = this;
        synchronized (relay) {
            if (this.file == null) {
                return null;
            }
            ++this.sourceCount;
        }
        return new RelaySource();
    }

    class RelaySource
    implements Source {
        private final Timeout timeout = new Timeout();
        private FileOperator fileOperator;
        private long sourcePos;

        RelaySource() {
            this.fileOperator = new FileOperator(Relay.this.file.getChannel());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long read(Buffer buffer, long l2) throws IOException {
            int n2;
            long l3;
            block27: {
                if (this.fileOperator == null) {
                    throw new IllegalStateException("closed");
                }
                Relay relay = Relay.this;
                synchronized (relay) {
                    while (this.sourcePos == (l3 = Relay.this.upstreamPos)) {
                        if (Relay.this.complete) {
                            return -1L;
                        }
                        if (Relay.this.upstreamReader != null) {
                            this.timeout.waitUntilNotified(Relay.this);
                            continue;
                        }
                        Relay.this.upstreamReader = Thread.currentThread();
                        n2 = 1;
                        break block27;
                    }
                    long l4 = l3 - Relay.this.buffer.size();
                    if (this.sourcePos < l4) {
                        n2 = 2;
                        break block27;
                    }
                    long l5 = Math.min(l2, l3 - this.sourcePos);
                    Relay.this.buffer.copyTo(buffer, this.sourcePos - l4, l5);
                    this.sourcePos += l5;
                    return l5;
                }
            }
            if (n2 == 2) {
                long l6 = Math.min(l2, l3 - this.sourcePos);
                this.fileOperator.read(32L + this.sourcePos, buffer, l6);
                this.sourcePos += l6;
                return l6;
            }
            try {
                long l7 = Relay.this.upstream.read(Relay.this.upstreamBuffer, Relay.this.bufferMaxSize);
                if (l7 == -1L) {
                    Relay.this.commit(l3);
                    long l8 = -1L;
                    return l8;
                }
                long l9 = Math.min(l7, l2);
                Relay.this.upstreamBuffer.copyTo(buffer, 0L, l9);
                this.sourcePos += l9;
                this.fileOperator.write(32L + l3, Relay.this.upstreamBuffer.clone(), l7);
                Relay relay = Relay.this;
                synchronized (relay) {
                    Relay.this.buffer.write(Relay.this.upstreamBuffer, l7);
                    if (Relay.this.buffer.size() > Relay.this.bufferMaxSize) {
                        Relay.this.buffer.skip(Relay.this.buffer.size() - Relay.this.bufferMaxSize);
                    }
                    Relay.this.upstreamPos += l7;
                }
                long l10 = l9;
                return l10;
            }
            finally {
                Relay relay = Relay.this;
                synchronized (relay) {
                    Relay.this.upstreamReader = null;
                    Relay.this.notifyAll();
                }
            }
        }

        @Override
        public Timeout timeout() {
            return this.timeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            if (this.fileOperator == null) {
                return;
            }
            this.fileOperator = null;
            RandomAccessFile randomAccessFile = null;
            Relay relay = Relay.this;
            synchronized (relay) {
                --Relay.this.sourceCount;
                if (Relay.this.sourceCount == 0) {
                    randomAccessFile = Relay.this.file;
                    Relay.this.file = null;
                }
            }
            if (randomAccessFile != null) {
                Util.closeQuietly(randomAccessFile);
            }
        }
    }
}

