/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.annotation.Nullable;
import okhttp3.internal.Util;
import okhttp3.internal.http.HttpDate;

public final class Headers {
    private final String[] namesAndValues;

    Headers(Builder builder) {
        this.namesAndValues = builder.namesAndValues.toArray(new String[builder.namesAndValues.size()]);
    }

    private Headers(String[] stringArray) {
        this.namesAndValues = stringArray;
    }

    @Nullable
    public String get(String string) {
        return Headers.get(this.namesAndValues, string);
    }

    @Nullable
    public Date getDate(String string) {
        String string2 = this.get(string);
        return string2 != null ? HttpDate.parse(string2) : null;
    }

    public int size() {
        return this.namesAndValues.length / 2;
    }

    public String name(int n2) {
        return this.namesAndValues[n2 * 2];
    }

    public String value(int n2) {
        return this.namesAndValues[n2 * 2 + 1];
    }

    public Set<String> names() {
        TreeSet<String> treeSet = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            treeSet.add(this.name(i2));
        }
        return Collections.unmodifiableSet(treeSet);
    }

    public List<String> values(String string) {
        ArrayList<String> arrayList = null;
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!string.equalsIgnoreCase(this.name(i2))) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<String>(2);
            }
            arrayList.add(this.value(i2));
        }
        return arrayList != null ? Collections.unmodifiableList(arrayList) : Collections.emptyList();
    }

    public long byteCount() {
        long l2 = this.namesAndValues.length * 2;
        int n2 = this.namesAndValues.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            l2 += (long)this.namesAndValues[i2].length();
        }
        return l2;
    }

    public Builder newBuilder() {
        Builder builder = new Builder();
        Collections.addAll(builder.namesAndValues, this.namesAndValues);
        return builder;
    }

    public boolean equals(@Nullable Object object) {
        return object instanceof Headers && Arrays.equals(((Headers)object).namesAndValues, this.namesAndValues);
    }

    public int hashCode() {
        return Arrays.hashCode(this.namesAndValues);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append(this.name(i2)).append(": ").append(this.value(i2)).append("\n");
        }
        return stringBuilder.toString();
    }

    public Map<String, List<String>> toMultimap() {
        TreeMap<String, List<String>> treeMap = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = this.name(i2).toLowerCase(Locale.US);
            ArrayList<String> arrayList = (ArrayList<String>)treeMap.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<String>(2);
                treeMap.put(string, arrayList);
            }
            arrayList.add(this.value(i2));
        }
        return treeMap;
    }

    private static String get(String[] stringArray, String string) {
        for (int i2 = stringArray.length - 2; i2 >= 0; i2 -= 2) {
            if (!string.equalsIgnoreCase(stringArray[i2])) continue;
            return stringArray[i2 + 1];
        }
        return null;
    }

    public static Headers of(String ... stringArray) {
        int n2;
        if (stringArray == null) {
            throw new NullPointerException("namesAndValues == null");
        }
        if (stringArray.length % 2 != 0) {
            throw new IllegalArgumentException("Expected alternating header names and values");
        }
        stringArray = (String[])stringArray.clone();
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if (stringArray[n2] == null) {
                throw new IllegalArgumentException("Headers cannot be null");
            }
            stringArray[n2] = stringArray[n2].trim();
        }
        for (n2 = 0; n2 < stringArray.length; n2 += 2) {
            String string = stringArray[n2];
            String string2 = stringArray[n2 + 1];
            if (string.length() != 0 && string.indexOf(0) == -1 && string2.indexOf(0) == -1) continue;
            throw new IllegalArgumentException("Unexpected header: " + string + ": " + string2);
        }
        return new Headers(stringArray);
    }

    public static Headers of(Map<String, String> map) {
        if (map == null) {
            throw new NullPointerException("headers == null");
        }
        String[] stringArray = new String[map.size() * 2];
        int n2 = 0;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) {
                throw new IllegalArgumentException("Headers cannot be null");
            }
            String string = entry.getKey().trim();
            String string2 = entry.getValue().trim();
            if (string.length() == 0 || string.indexOf(0) != -1 || string2.indexOf(0) != -1) {
                throw new IllegalArgumentException("Unexpected header: " + string + ": " + string2);
            }
            stringArray[n2] = string;
            stringArray[n2 + 1] = string2;
            n2 += 2;
        }
        return new Headers(stringArray);
    }

    public static final class Builder {
        final List<String> namesAndValues = new ArrayList<String>(20);

        Builder addLenient(String string) {
            int n2 = string.indexOf(":", 1);
            if (n2 != -1) {
                return this.addLenient(string.substring(0, n2), string.substring(n2 + 1));
            }
            if (string.startsWith(":")) {
                return this.addLenient("", string.substring(1));
            }
            return this.addLenient("", string);
        }

        public Builder add(String string) {
            int n2 = string.indexOf(":");
            if (n2 == -1) {
                throw new IllegalArgumentException("Unexpected header: " + string);
            }
            return this.add(string.substring(0, n2).trim(), string.substring(n2 + 1));
        }

        public Builder add(String string, String string2) {
            this.checkNameAndValue(string, string2);
            return this.addLenient(string, string2);
        }

        Builder addLenient(String string, String string2) {
            this.namesAndValues.add(string);
            this.namesAndValues.add(string2.trim());
            return this;
        }

        public Builder removeAll(String string) {
            for (int i2 = 0; i2 < this.namesAndValues.size(); i2 += 2) {
                if (!string.equalsIgnoreCase(this.namesAndValues.get(i2))) continue;
                this.namesAndValues.remove(i2);
                this.namesAndValues.remove(i2);
                i2 -= 2;
            }
            return this;
        }

        public Builder set(String string, String string2) {
            this.checkNameAndValue(string, string2);
            this.removeAll(string);
            this.addLenient(string, string2);
            return this;
        }

        private void checkNameAndValue(String string, String string2) {
            char c2;
            int n2;
            if (string == null) {
                throw new NullPointerException("name == null");
            }
            if (string.isEmpty()) {
                throw new IllegalArgumentException("name is empty");
            }
            int n3 = string.length();
            for (n2 = 0; n2 < n3; ++n2) {
                c2 = string.charAt(n2);
                if (c2 > ' ' && c2 < '\u007f') continue;
                throw new IllegalArgumentException(Util.format("Unexpected char %#04x at %d in header name: %s", c2, n2, string));
            }
            if (string2 == null) {
                throw new NullPointerException("value for name " + string + " == null");
            }
            n3 = string2.length();
            for (n2 = 0; n2 < n3; ++n2) {
                c2 = string2.charAt(n2);
                if ((c2 > '\u001f' || c2 == '\t') && c2 < '\u007f') continue;
                throw new IllegalArgumentException(Util.format("Unexpected char %#04x at %d in %s value: %s", c2, n2, string, string2));
            }
        }

        public String get(String string) {
            for (int i2 = this.namesAndValues.size() - 2; i2 >= 0; i2 -= 2) {
                if (!string.equalsIgnoreCase(this.namesAndValues.get(i2))) continue;
                return this.namesAndValues.get(i2 + 1);
            }
            return null;
        }

        public Headers build() {
            return new Headers(this);
        }
    }
}

