/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import okhttp3.Call;
import okhttp3.RealCall;
import okhttp3.internal.Util;

public final class Dispatcher {
    private int maxRequests = 64;
    private int maxRequestsPerHost = 5;
    @Nullable
    private Runnable idleCallback;
    @Nullable
    private ExecutorService executorService;
    private final Deque<RealCall.AsyncCall> readyAsyncCalls = new ArrayDeque<RealCall.AsyncCall>();
    private final Deque<RealCall.AsyncCall> runningAsyncCalls = new ArrayDeque<RealCall.AsyncCall>();
    private final Deque<RealCall> runningSyncCalls = new ArrayDeque<RealCall>();

    public Dispatcher(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public Dispatcher() {
    }

    public synchronized ExecutorService executorService() {
        if (this.executorService == null) {
            this.executorService = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), Util.threadFactory("OkHttp Dispatcher", false));
        }
        return this.executorService;
    }

    public synchronized void setMaxRequests(int n2) {
        if (n2 < 1) {
            throw new IllegalArgumentException("max < 1: " + n2);
        }
        this.maxRequests = n2;
        this.promoteCalls();
    }

    public synchronized int getMaxRequests() {
        return this.maxRequests;
    }

    public synchronized void setMaxRequestsPerHost(int n2) {
        if (n2 < 1) {
            throw new IllegalArgumentException("max < 1: " + n2);
        }
        this.maxRequestsPerHost = n2;
        this.promoteCalls();
    }

    public synchronized int getMaxRequestsPerHost() {
        return this.maxRequestsPerHost;
    }

    public synchronized void setIdleCallback(@Nullable Runnable runnable) {
        this.idleCallback = runnable;
    }

    synchronized void enqueue(RealCall.AsyncCall asyncCall) {
        if (this.runningAsyncCalls.size() < this.maxRequests && this.runningCallsForHost(asyncCall) < this.maxRequestsPerHost) {
            this.runningAsyncCalls.add(asyncCall);
            this.executorService().execute(asyncCall);
        } else {
            this.readyAsyncCalls.add(asyncCall);
        }
    }

    public synchronized void cancelAll() {
        for (RealCall.AsyncCall object : this.readyAsyncCalls) {
            object.get().cancel();
        }
        for (RealCall.AsyncCall asyncCall : this.runningAsyncCalls) {
            asyncCall.get().cancel();
        }
        for (RealCall realCall : this.runningSyncCalls) {
            realCall.cancel();
        }
    }

    private void promoteCalls() {
        if (this.runningAsyncCalls.size() >= this.maxRequests) {
            return;
        }
        if (this.readyAsyncCalls.isEmpty()) {
            return;
        }
        Iterator<RealCall.AsyncCall> iterator = this.readyAsyncCalls.iterator();
        while (iterator.hasNext()) {
            RealCall.AsyncCall asyncCall = iterator.next();
            if (this.runningCallsForHost(asyncCall) < this.maxRequestsPerHost) {
                iterator.remove();
                this.runningAsyncCalls.add(asyncCall);
                this.executorService().execute(asyncCall);
            }
            if (this.runningAsyncCalls.size() < this.maxRequests) continue;
            return;
        }
    }

    private int runningCallsForHost(RealCall.AsyncCall asyncCall) {
        int n2 = 0;
        for (RealCall.AsyncCall asyncCall2 : this.runningAsyncCalls) {
            if (asyncCall2.get().forWebSocket || !asyncCall2.host().equals(asyncCall.host())) continue;
            ++n2;
        }
        return n2;
    }

    synchronized void executed(RealCall realCall) {
        this.runningSyncCalls.add(realCall);
    }

    void finished(RealCall.AsyncCall asyncCall) {
        this.finished(this.runningAsyncCalls, asyncCall, true);
    }

    void finished(RealCall realCall) {
        this.finished(this.runningSyncCalls, realCall, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void finished(Deque<T> deque, T t2, boolean bl2) {
        Runnable runnable;
        int n2;
        Dispatcher dispatcher = this;
        synchronized (dispatcher) {
            if (!deque.remove(t2)) {
                throw new AssertionError((Object)"Call wasn't in-flight!");
            }
            if (bl2) {
                this.promoteCalls();
            }
            n2 = this.runningCallsCount();
            runnable = this.idleCallback;
        }
        if (n2 == 0 && runnable != null) {
            runnable.run();
        }
    }

    public synchronized List<Call> queuedCalls() {
        ArrayList<RealCall> arrayList = new ArrayList<RealCall>();
        for (RealCall.AsyncCall asyncCall : this.readyAsyncCalls) {
            arrayList.add(asyncCall.get());
        }
        return Collections.unmodifiableList(arrayList);
    }

    public synchronized List<Call> runningCalls() {
        ArrayList<RealCall> arrayList = new ArrayList<RealCall>();
        arrayList.addAll(this.runningSyncCalls);
        for (RealCall.AsyncCall asyncCall : this.runningAsyncCalls) {
            arrayList.add(asyncCall.get());
        }
        return Collections.unmodifiableList(arrayList);
    }

    public synchronized int queuedCallsCount() {
        return this.readyAsyncCalls.size();
    }

    public synchronized int runningCallsCount() {
        return this.runningAsyncCalls.size() + this.runningSyncCalls.size();
    }
}

