/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.bind.helpers;

import java.net.URL;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.ValidationEventLocator;
import javax.xml.bind.helpers.Messages;
import org.w3c.dom.Node;

public class DefaultValidationEventHandler
implements ValidationEventHandler {
    @Override
    public boolean handleEvent(ValidationEvent validationEvent) {
        if (validationEvent == null) {
            throw new IllegalArgumentException();
        }
        String string = null;
        boolean bl2 = false;
        switch (validationEvent.getSeverity()) {
            case 0: {
                string = Messages.format("DefaultValidationEventHandler.Warning");
                bl2 = true;
                break;
            }
            case 1: {
                string = Messages.format("DefaultValidationEventHandler.Error");
                bl2 = false;
                break;
            }
            case 2: {
                string = Messages.format("DefaultValidationEventHandler.FatalError");
                bl2 = false;
                break;
            }
            default: {
                assert (false) : Messages.format("DefaultValidationEventHandler.UnrecognizedSeverity", validationEvent.getSeverity());
                break;
            }
        }
        String string2 = this.getLocation(validationEvent);
        System.out.println(Messages.format("DefaultValidationEventHandler.SeverityMessage", string, validationEvent.getMessage(), string2));
        return bl2;
    }

    private String getLocation(ValidationEvent validationEvent) {
        StringBuffer stringBuffer = new StringBuffer();
        ValidationEventLocator validationEventLocator = validationEvent.getLocator();
        if (validationEventLocator != null) {
            URL uRL = validationEventLocator.getURL();
            Object object = validationEventLocator.getObject();
            Node node = validationEventLocator.getNode();
            int n2 = validationEventLocator.getLineNumber();
            if (uRL != null || n2 != -1) {
                stringBuffer.append("line " + n2);
                if (uRL != null) {
                    stringBuffer.append(" of " + uRL);
                }
            } else if (object != null) {
                stringBuffer.append(" obj: " + object.toString());
            } else if (node != null) {
                stringBuffer.append(" node: " + node.toString());
            }
        } else {
            stringBuffer.append(Messages.format("DefaultValidationEventHandler.LocationUnavailable"));
        }
        return stringBuffer.toString();
    }
}

