/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.bind;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.DatatypeConverterInterface;
import javax.xml.bind.WhiteSpaceProcessor;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;

final class DatatypeConverterImpl
implements DatatypeConverterInterface {
    public static final DatatypeConverterInterface theInstance = new DatatypeConverterImpl();
    private static final char[] hexCode = "0123456789ABCDEF".toCharArray();
    private static final byte[] decodeMap = DatatypeConverterImpl.initDecodeMap();
    private static final byte PADDING = 127;
    private static final char[] encodeMap = DatatypeConverterImpl.initEncodeMap();
    private static final DatatypeFactory datatypeFactory;

    protected DatatypeConverterImpl() {
    }

    @Override
    public String parseString(String string) {
        return string;
    }

    @Override
    public BigInteger parseInteger(String string) {
        return DatatypeConverterImpl._parseInteger(string);
    }

    public static BigInteger _parseInteger(CharSequence charSequence) {
        return new BigInteger(DatatypeConverterImpl.removeOptionalPlus(WhiteSpaceProcessor.trim(charSequence)).toString());
    }

    @Override
    public String printInteger(BigInteger bigInteger) {
        return DatatypeConverterImpl._printInteger(bigInteger);
    }

    public static String _printInteger(BigInteger bigInteger) {
        return bigInteger.toString();
    }

    @Override
    public int parseInt(String string) {
        return DatatypeConverterImpl._parseInt(string);
    }

    public static int _parseInt(CharSequence charSequence) {
        int n2 = charSequence.length();
        int n3 = 1;
        int n4 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = charSequence.charAt(i2);
            if (WhiteSpaceProcessor.isWhiteSpace(c2)) continue;
            if ('0' <= c2 && c2 <= '9') {
                n4 = n4 * 10 + (c2 - 48);
                continue;
            }
            if (c2 == '-') {
                n3 = -1;
                continue;
            }
            if (c2 == '+') continue;
            throw new NumberFormatException("Not a number: " + charSequence);
        }
        return n4 * n3;
    }

    @Override
    public long parseLong(String string) {
        return DatatypeConverterImpl._parseLong(string);
    }

    public static long _parseLong(CharSequence charSequence) {
        return Long.parseLong(DatatypeConverterImpl.removeOptionalPlus(WhiteSpaceProcessor.trim(charSequence)).toString());
    }

    @Override
    public short parseShort(String string) {
        return DatatypeConverterImpl._parseShort(string);
    }

    public static short _parseShort(CharSequence charSequence) {
        return (short)DatatypeConverterImpl._parseInt(charSequence);
    }

    @Override
    public String printShort(short s2) {
        return DatatypeConverterImpl._printShort(s2);
    }

    public static String _printShort(short s2) {
        return String.valueOf(s2);
    }

    @Override
    public BigDecimal parseDecimal(String string) {
        return DatatypeConverterImpl._parseDecimal(string);
    }

    public static BigDecimal _parseDecimal(CharSequence charSequence) {
        if ((charSequence = WhiteSpaceProcessor.trim(charSequence)).length() <= 0) {
            return null;
        }
        return new BigDecimal(charSequence.toString());
    }

    @Override
    public float parseFloat(String string) {
        return DatatypeConverterImpl._parseFloat(string);
    }

    public static float _parseFloat(CharSequence charSequence) {
        String string = WhiteSpaceProcessor.trim(charSequence).toString();
        if (string.equals("NaN")) {
            return Float.NaN;
        }
        if (string.equals("INF")) {
            return Float.POSITIVE_INFINITY;
        }
        if (string.equals("-INF")) {
            return Float.NEGATIVE_INFINITY;
        }
        if (string.length() == 0 || !DatatypeConverterImpl.isDigitOrPeriodOrSign(string.charAt(0)) || !DatatypeConverterImpl.isDigitOrPeriodOrSign(string.charAt(string.length() - 1))) {
            throw new NumberFormatException();
        }
        return Float.parseFloat(string);
    }

    @Override
    public String printFloat(float f2) {
        return DatatypeConverterImpl._printFloat(f2);
    }

    public static String _printFloat(float f2) {
        if (Float.isNaN(f2)) {
            return "NaN";
        }
        if (f2 == Float.POSITIVE_INFINITY) {
            return "INF";
        }
        if (f2 == Float.NEGATIVE_INFINITY) {
            return "-INF";
        }
        return String.valueOf(f2);
    }

    @Override
    public double parseDouble(String string) {
        return DatatypeConverterImpl._parseDouble(string);
    }

    public static double _parseDouble(CharSequence charSequence) {
        String string = WhiteSpaceProcessor.trim(charSequence).toString();
        if (string.equals("NaN")) {
            return Double.NaN;
        }
        if (string.equals("INF")) {
            return Double.POSITIVE_INFINITY;
        }
        if (string.equals("-INF")) {
            return Double.NEGATIVE_INFINITY;
        }
        if (string.length() == 0 || !DatatypeConverterImpl.isDigitOrPeriodOrSign(string.charAt(0)) || !DatatypeConverterImpl.isDigitOrPeriodOrSign(string.charAt(string.length() - 1))) {
            throw new NumberFormatException(string);
        }
        return Double.parseDouble(string);
    }

    @Override
    public boolean parseBoolean(String string) {
        Boolean bl2 = DatatypeConverterImpl._parseBoolean(string);
        return bl2 == null ? false : bl2;
    }

    public static Boolean _parseBoolean(CharSequence charSequence) {
        char c2;
        if (charSequence == null) {
            return null;
        }
        int n2 = 0;
        int n3 = charSequence.length();
        boolean bl2 = false;
        if (charSequence.length() <= 0) {
            return null;
        }
        while (WhiteSpaceProcessor.isWhiteSpace(c2 = charSequence.charAt(n2++)) && n2 < n3) {
        }
        int n4 = 0;
        switch (c2) {
            case '1': {
                bl2 = true;
                break;
            }
            case '0': {
                bl2 = false;
                break;
            }
            case 't': {
                String string = "rue";
                do {
                    c2 = charSequence.charAt(n2++);
                } while (string.charAt(n4++) == c2 && n2 < n3 && n4 < 3);
                if (n4 == 3) {
                    bl2 = true;
                    break;
                }
                return false;
            }
            case 'f': {
                String string = "alse";
                do {
                    c2 = charSequence.charAt(n2++);
                } while (string.charAt(n4++) == c2 && n2 < n3 && n4 < 4);
                if (n4 == 4) {
                    bl2 = false;
                    break;
                }
                return false;
            }
        }
        if (n2 < n3) {
            while (WhiteSpaceProcessor.isWhiteSpace(c2 = charSequence.charAt(n2++)) && n2 < n3) {
            }
        }
        if (n2 == n3) {
            return bl2;
        }
        return null;
    }

    @Override
    public String printBoolean(boolean bl2) {
        return bl2 ? "true" : "false";
    }

    public static String _printBoolean(boolean bl2) {
        return bl2 ? "true" : "false";
    }

    @Override
    public byte parseByte(String string) {
        return DatatypeConverterImpl._parseByte(string);
    }

    public static byte _parseByte(CharSequence charSequence) {
        return (byte)DatatypeConverterImpl._parseInt(charSequence);
    }

    @Override
    public String printByte(byte by2) {
        return DatatypeConverterImpl._printByte(by2);
    }

    public static String _printByte(byte by2) {
        return String.valueOf(by2);
    }

    @Override
    public QName parseQName(String string, NamespaceContext namespaceContext) {
        return DatatypeConverterImpl._parseQName(string, namespaceContext);
    }

    public static QName _parseQName(CharSequence charSequence, NamespaceContext namespaceContext) {
        String string;
        String string2;
        String string3;
        int n2;
        int n3;
        int n4;
        int n5 = charSequence.length();
        for (n4 = 0; n4 < n5 && WhiteSpaceProcessor.isWhiteSpace(charSequence.charAt(n4)); ++n4) {
        }
        for (n3 = n5; n3 > n4 && WhiteSpaceProcessor.isWhiteSpace(charSequence.charAt(n3 - 1)); --n3) {
        }
        if (n3 == n4) {
            throw new IllegalArgumentException("input is empty");
        }
        for (n2 = n4 + 1; n2 < n3 && charSequence.charAt(n2) != ':'; ++n2) {
        }
        if (n2 == n3) {
            string3 = namespaceContext.getNamespaceURI("");
            string2 = charSequence.subSequence(n4, n3).toString();
            string = "";
        } else {
            string = charSequence.subSequence(n4, n2).toString();
            string2 = charSequence.subSequence(n2 + 1, n3).toString();
            string3 = namespaceContext.getNamespaceURI(string);
            if (string3 == null || string3.length() == 0) {
                throw new IllegalArgumentException("prefix " + string + " is not bound to a namespace");
            }
        }
        return new QName(string3, string2, string);
    }

    @Override
    public Calendar parseDateTime(String string) {
        return DatatypeConverterImpl._parseDateTime(string);
    }

    public static GregorianCalendar _parseDateTime(CharSequence charSequence) {
        String string = WhiteSpaceProcessor.trim(charSequence).toString();
        return datatypeFactory.newXMLGregorianCalendar(string).toGregorianCalendar();
    }

    @Override
    public String printDateTime(Calendar calendar) {
        return DatatypeConverterImpl._printDateTime(calendar);
    }

    public static String _printDateTime(Calendar calendar) {
        return CalendarFormatter.doFormat("%Y-%M-%DT%h:%m:%s%z", calendar);
    }

    @Override
    public byte[] parseBase64Binary(String string) {
        return DatatypeConverterImpl._parseBase64Binary(string);
    }

    @Override
    public byte[] parseHexBinary(String string) {
        int n2 = string.length();
        if (n2 % 2 != 0) {
            throw new IllegalArgumentException("hexBinary needs to be even-length: " + string);
        }
        byte[] byArray = new byte[n2 / 2];
        for (int i2 = 0; i2 < n2; i2 += 2) {
            int n3 = DatatypeConverterImpl.hexToBin(string.charAt(i2));
            int n4 = DatatypeConverterImpl.hexToBin(string.charAt(i2 + 1));
            if (n3 == -1 || n4 == -1) {
                throw new IllegalArgumentException("contains illegal character for hexBinary: " + string);
            }
            byArray[i2 / 2] = (byte)(n3 * 16 + n4);
        }
        return byArray;
    }

    private static int hexToBin(char c2) {
        if ('0' <= c2 && c2 <= '9') {
            return c2 - 48;
        }
        if ('A' <= c2 && c2 <= 'F') {
            return c2 - 65 + 10;
        }
        if ('a' <= c2 && c2 <= 'f') {
            return c2 - 97 + 10;
        }
        return -1;
    }

    @Override
    public String printHexBinary(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(byArray.length * 2);
        for (byte by2 : byArray) {
            stringBuilder.append(hexCode[by2 >> 4 & 0xF]);
            stringBuilder.append(hexCode[by2 & 0xF]);
        }
        return stringBuilder.toString();
    }

    @Override
    public long parseUnsignedInt(String string) {
        return DatatypeConverterImpl._parseLong(string);
    }

    @Override
    public String printUnsignedInt(long l2) {
        return DatatypeConverterImpl._printLong(l2);
    }

    @Override
    public int parseUnsignedShort(String string) {
        return DatatypeConverterImpl._parseInt(string);
    }

    @Override
    public Calendar parseTime(String string) {
        return datatypeFactory.newXMLGregorianCalendar(string).toGregorianCalendar();
    }

    @Override
    public String printTime(Calendar calendar) {
        return CalendarFormatter.doFormat("%h:%m:%s%z", calendar);
    }

    @Override
    public Calendar parseDate(String string) {
        return datatypeFactory.newXMLGregorianCalendar(string).toGregorianCalendar();
    }

    @Override
    public String printDate(Calendar calendar) {
        return DatatypeConverterImpl._printDate(calendar);
    }

    public static String _printDate(Calendar calendar) {
        return CalendarFormatter.doFormat("%Y-%M-%D" + "%z", calendar);
    }

    @Override
    public String parseAnySimpleType(String string) {
        return string;
    }

    @Override
    public String printString(String string) {
        return string;
    }

    @Override
    public String printInt(int n2) {
        return DatatypeConverterImpl._printInt(n2);
    }

    public static String _printInt(int n2) {
        return String.valueOf(n2);
    }

    @Override
    public String printLong(long l2) {
        return DatatypeConverterImpl._printLong(l2);
    }

    public static String _printLong(long l2) {
        return String.valueOf(l2);
    }

    @Override
    public String printDecimal(BigDecimal bigDecimal) {
        return DatatypeConverterImpl._printDecimal(bigDecimal);
    }

    public static String _printDecimal(BigDecimal bigDecimal) {
        return bigDecimal.toPlainString();
    }

    @Override
    public String printDouble(double d2) {
        return DatatypeConverterImpl._printDouble(d2);
    }

    public static String _printDouble(double d2) {
        if (Double.isNaN(d2)) {
            return "NaN";
        }
        if (d2 == Double.POSITIVE_INFINITY) {
            return "INF";
        }
        if (d2 == Double.NEGATIVE_INFINITY) {
            return "-INF";
        }
        return String.valueOf(d2);
    }

    @Override
    public String printQName(QName qName, NamespaceContext namespaceContext) {
        return DatatypeConverterImpl._printQName(qName, namespaceContext);
    }

    public static String _printQName(QName qName, NamespaceContext namespaceContext) {
        String string = namespaceContext.getPrefix(qName.getNamespaceURI());
        String string2 = qName.getLocalPart();
        String string3 = string == null || string.length() == 0 ? string2 : string + ':' + string2;
        return string3;
    }

    @Override
    public String printBase64Binary(byte[] byArray) {
        return DatatypeConverterImpl._printBase64Binary(byArray);
    }

    @Override
    public String printUnsignedShort(int n2) {
        return String.valueOf(n2);
    }

    @Override
    public String printAnySimpleType(String string) {
        return string;
    }

    public static String installHook(String string) {
        DatatypeConverter.setDatatypeConverter(theInstance);
        return string;
    }

    private static byte[] initDecodeMap() {
        int n2;
        byte[] byArray = new byte[128];
        for (n2 = 0; n2 < 128; ++n2) {
            byArray[n2] = -1;
        }
        for (n2 = 65; n2 <= 90; ++n2) {
            byArray[n2] = (byte)(n2 - 65);
        }
        for (n2 = 97; n2 <= 122; ++n2) {
            byArray[n2] = (byte)(n2 - 97 + 26);
        }
        for (n2 = 48; n2 <= 57; ++n2) {
            byArray[n2] = (byte)(n2 - 48 + 52);
        }
        byArray[43] = 62;
        byArray[47] = 63;
        byArray[61] = 127;
        return byArray;
    }

    private static int guessLength(String string) {
        int n2;
        int n3;
        int n4 = string.length();
        for (n3 = n4 - 1; n3 >= 0; --n3) {
            n2 = decodeMap[string.charAt(n3)];
            if (n2 == 127) continue;
            if (n2 != -1) break;
            return string.length() / 4 * 3;
        }
        if ((n2 = n4 - ++n3) > 2) {
            return string.length() / 4 * 3;
        }
        return string.length() / 4 * 3 - n2;
    }

    public static byte[] _parseBase64Binary(String string) {
        int n2 = DatatypeConverterImpl.guessLength(string);
        byte[] byArray = new byte[n2];
        int n3 = 0;
        int n4 = string.length();
        byte[] byArray2 = new byte[4];
        int n5 = 0;
        for (int i2 = 0; i2 < n4; ++i2) {
            char c2 = string.charAt(i2);
            byte by2 = decodeMap[c2];
            if (by2 != -1) {
                byArray2[n5++] = by2;
            }
            if (n5 != 4) continue;
            byArray[n3++] = (byte)(byArray2[0] << 2 | byArray2[1] >> 4);
            if (byArray2[2] != 127) {
                byArray[n3++] = (byte)(byArray2[1] << 4 | byArray2[2] >> 2);
            }
            if (byArray2[3] != 127) {
                byArray[n3++] = (byte)(byArray2[2] << 6 | byArray2[3]);
            }
            n5 = 0;
        }
        if (n2 == n3) {
            return byArray;
        }
        byte[] byArray3 = new byte[n3];
        System.arraycopy(byArray, 0, byArray3, 0, n3);
        return byArray3;
    }

    private static char[] initEncodeMap() {
        int n2;
        char[] cArray = new char[64];
        for (n2 = 0; n2 < 26; ++n2) {
            cArray[n2] = (char)(65 + n2);
        }
        for (n2 = 26; n2 < 52; ++n2) {
            cArray[n2] = (char)(97 + (n2 - 26));
        }
        for (n2 = 52; n2 < 62; ++n2) {
            cArray[n2] = (char)(48 + (n2 - 52));
        }
        cArray[62] = 43;
        cArray[63] = 47;
        return cArray;
    }

    public static char encode(int n2) {
        return encodeMap[n2 & 0x3F];
    }

    public static byte encodeByte(int n2) {
        return (byte)encodeMap[n2 & 0x3F];
    }

    public static String _printBase64Binary(byte[] byArray) {
        return DatatypeConverterImpl._printBase64Binary(byArray, 0, byArray.length);
    }

    public static String _printBase64Binary(byte[] byArray, int n2, int n3) {
        char[] cArray = new char[(n3 + 2) / 3 * 4];
        int n4 = DatatypeConverterImpl._printBase64Binary(byArray, n2, n3, cArray, 0);
        assert (n4 == cArray.length);
        return new String(cArray);
    }

    public static int _printBase64Binary(byte[] byArray, int n2, int n3, char[] cArray, int n4) {
        int n5 = n3;
        int n6 = n2;
        while (n5 >= 3) {
            cArray[n4++] = DatatypeConverterImpl.encode(byArray[n6] >> 2);
            cArray[n4++] = DatatypeConverterImpl.encode((byArray[n6] & 3) << 4 | byArray[n6 + 1] >> 4 & 0xF);
            cArray[n4++] = DatatypeConverterImpl.encode((byArray[n6 + 1] & 0xF) << 2 | byArray[n6 + 2] >> 6 & 3);
            cArray[n4++] = DatatypeConverterImpl.encode(byArray[n6 + 2] & 0x3F);
            n5 -= 3;
            n6 += 3;
        }
        if (n5 == 1) {
            cArray[n4++] = DatatypeConverterImpl.encode(byArray[n6] >> 2);
            cArray[n4++] = DatatypeConverterImpl.encode((byArray[n6] & 3) << 4);
            cArray[n4++] = 61;
            cArray[n4++] = 61;
        }
        if (n5 == 2) {
            cArray[n4++] = DatatypeConverterImpl.encode(byArray[n6] >> 2);
            cArray[n4++] = DatatypeConverterImpl.encode((byArray[n6] & 3) << 4 | byArray[n6 + 1] >> 4 & 0xF);
            cArray[n4++] = DatatypeConverterImpl.encode((byArray[n6 + 1] & 0xF) << 2);
            cArray[n4++] = 61;
        }
        return n4;
    }

    public static int _printBase64Binary(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        byte[] byArray3 = byArray2;
        int n5 = n3;
        int n6 = n2;
        while (n5 >= 3) {
            byArray3[n4++] = DatatypeConverterImpl.encodeByte(byArray[n6] >> 2);
            byArray3[n4++] = DatatypeConverterImpl.encodeByte((byArray[n6] & 3) << 4 | byArray[n6 + 1] >> 4 & 0xF);
            byArray3[n4++] = DatatypeConverterImpl.encodeByte((byArray[n6 + 1] & 0xF) << 2 | byArray[n6 + 2] >> 6 & 3);
            byArray3[n4++] = DatatypeConverterImpl.encodeByte(byArray[n6 + 2] & 0x3F);
            n5 -= 3;
            n6 += 3;
        }
        if (n5 == 1) {
            byArray3[n4++] = DatatypeConverterImpl.encodeByte(byArray[n6] >> 2);
            byArray3[n4++] = DatatypeConverterImpl.encodeByte((byArray[n6] & 3) << 4);
            byArray3[n4++] = 61;
            byArray3[n4++] = 61;
        }
        if (n5 == 2) {
            byArray3[n4++] = DatatypeConverterImpl.encodeByte(byArray[n6] >> 2);
            byArray3[n4++] = DatatypeConverterImpl.encodeByte((byArray[n6] & 3) << 4 | byArray[n6 + 1] >> 4 & 0xF);
            byArray3[n4++] = DatatypeConverterImpl.encodeByte((byArray[n6 + 1] & 0xF) << 2);
            byArray3[n4++] = 61;
        }
        return n4;
    }

    private static CharSequence removeOptionalPlus(CharSequence charSequence) {
        int n2 = charSequence.length();
        if (n2 <= 1 || charSequence.charAt(0) != '+') {
            return charSequence;
        }
        char c2 = (charSequence = charSequence.subSequence(1, n2)).charAt(0);
        if ('0' <= c2 && c2 <= '9') {
            return charSequence;
        }
        if ('.' == c2) {
            return charSequence;
        }
        throw new NumberFormatException();
    }

    private static boolean isDigitOrPeriodOrSign(char c2) {
        if ('0' <= c2 && c2 <= '9') {
            return true;
        }
        return c2 == '+' || c2 == '-' || c2 == '.';
    }

    static {
        try {
            datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            throw new Error(datatypeConfigurationException);
        }
    }

    private static final class CalendarFormatter {
        private CalendarFormatter() {
        }

        public static String doFormat(String string, Calendar calendar) throws IllegalArgumentException {
            int n2 = 0;
            int n3 = string.length();
            StringBuilder stringBuilder = new StringBuilder();
            block9: while (n2 < n3) {
                char c2;
                if ((c2 = string.charAt(n2++)) != '%') {
                    stringBuilder.append(c2);
                    continue;
                }
                switch (string.charAt(n2++)) {
                    case 'Y': {
                        CalendarFormatter.formatYear(calendar, stringBuilder);
                        continue block9;
                    }
                    case 'M': {
                        CalendarFormatter.formatMonth(calendar, stringBuilder);
                        continue block9;
                    }
                    case 'D': {
                        CalendarFormatter.formatDays(calendar, stringBuilder);
                        continue block9;
                    }
                    case 'h': {
                        CalendarFormatter.formatHours(calendar, stringBuilder);
                        continue block9;
                    }
                    case 'm': {
                        CalendarFormatter.formatMinutes(calendar, stringBuilder);
                        continue block9;
                    }
                    case 's': {
                        CalendarFormatter.formatSeconds(calendar, stringBuilder);
                        continue block9;
                    }
                    case 'z': {
                        CalendarFormatter.formatTimeZone(calendar, stringBuilder);
                        continue block9;
                    }
                }
                throw new InternalError();
            }
            return stringBuilder.toString();
        }

        private static void formatYear(Calendar calendar, StringBuilder stringBuilder) {
            int n2 = calendar.get(1);
            String string = n2 <= 0 ? Integer.toString(1 - n2) : Integer.toString(n2);
            while (string.length() < 4) {
                string = '0' + string;
            }
            if (n2 <= 0) {
                string = '-' + string;
            }
            stringBuilder.append(string);
        }

        private static void formatMonth(Calendar calendar, StringBuilder stringBuilder) {
            CalendarFormatter.formatTwoDigits(calendar.get(2) + 1, stringBuilder);
        }

        private static void formatDays(Calendar calendar, StringBuilder stringBuilder) {
            CalendarFormatter.formatTwoDigits(calendar.get(5), stringBuilder);
        }

        private static void formatHours(Calendar calendar, StringBuilder stringBuilder) {
            CalendarFormatter.formatTwoDigits(calendar.get(11), stringBuilder);
        }

        private static void formatMinutes(Calendar calendar, StringBuilder stringBuilder) {
            CalendarFormatter.formatTwoDigits(calendar.get(12), stringBuilder);
        }

        private static void formatSeconds(Calendar calendar, StringBuilder stringBuilder) {
            int n2;
            CalendarFormatter.formatTwoDigits(calendar.get(13), stringBuilder);
            if (calendar.isSet(14) && (n2 = calendar.get(14)) != 0) {
                String string = Integer.toString(n2);
                while (string.length() < 3) {
                    string = '0' + string;
                }
                stringBuilder.append('.');
                stringBuilder.append(string);
            }
        }

        private static void formatTimeZone(Calendar calendar, StringBuilder stringBuilder) {
            TimeZone timeZone = calendar.getTimeZone();
            if (timeZone == null) {
                return;
            }
            int n2 = timeZone.getOffset(calendar.getTime().getTime());
            if (n2 == 0) {
                stringBuilder.append('Z');
                return;
            }
            if (n2 >= 0) {
                stringBuilder.append('+');
            } else {
                stringBuilder.append('-');
                n2 *= -1;
            }
            CalendarFormatter.formatTwoDigits((n2 /= 60000) / 60, stringBuilder);
            stringBuilder.append(':');
            CalendarFormatter.formatTwoDigits(n2 % 60, stringBuilder);
        }

        private static void formatTwoDigits(int n2, StringBuilder stringBuilder) {
            if (n2 < 10) {
                stringBuilder.append('0');
            }
            stringBuilder.append(n2);
        }
    }
}

